/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2mcrl2.tree;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.cif2mcrl2.NameMaps;
import org.eclipse.escet.cif.cif2mcrl2.storage.EventVarUsage;
import org.eclipse.escet.cif.cif2mcrl2.storage.VarUsage;
import org.eclipse.escet.cif.cif2mcrl2.storage.VariableData;
import org.eclipse.escet.cif.cif2mcrl2.tree.ProcessNode;
import org.eclipse.escet.cif.cif2mcrl2.tree.VariableProcessNode;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.HBox;
import org.eclipse.escet.common.box.StreamCodeBox;
import org.eclipse.escet.common.box.VBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;

public class CombinedProcessNode
extends ProcessNode {
    public final List<ProcessNode> children;

    public CombinedProcessNode(String name, List<ProcessNode> children) {
        super(name);
        Assert.check((!children.isEmpty() ? 1 : 0) != 0);
        this.children = children;
    }

    @Override
    public void deriveActions(Set<VariableData> localVars) {
        for (ProcessNode pn : this.children) {
            pn.deriveActions(localVars);
        }
        int count = 0;
        for (ProcessNode pn : this.children) {
            count += pn.availProcessVars.size();
        }
        this.availProcessVars = Sets.setc((int)count);
        for (ProcessNode pn : this.children) {
            this.availProcessVars.addAll(pn.availProcessVars);
        }
        count = 0;
        for (ProcessNode pn : this.children) {
            count += pn.valueVars.size();
        }
        this.valueVars = Sets.setc((int)count);
        for (ProcessNode pn : this.children) {
            this.valueVars.addAll(pn.valueVars);
        }
        this.eventVarUse = Maps.map();
        for (Event evt : this.collectAlphabet()) {
            this.eventVarUse.put(evt, this.computeEventVarUsage(evt));
        }
        for (EventVarUsage evu : this.eventVarUse.values()) {
            for (VariableData vd : this.availProcessVars) {
                if (evu.varUses.containsKey(vd)) continue;
                evu.varUses.put(vd, new VarUsage(vd));
            }
        }
    }

    private Set<Event> collectAlphabet() {
        Set events = Sets.set();
        for (ProcessNode pn : this.children) {
            events.addAll(pn.eventVarUse.keySet());
        }
        return events;
    }

    private EventVarUsage computeEventVarUsage(Event evt) {
        EventVarUsage evu = new EventVarUsage(evt);
        List childEventUsage = Lists.listc((int)this.children.size());
        for (ProcessNode pn : this.children) {
            EventVarUsage chEvu = pn.eventVarUse.get(evt);
            if (chEvu == null) continue;
            childEventUsage.add(chEvu);
        }
        Map varUsageMap = Maps.map();
        for (EventVarUsage eventVarUsage : childEventUsage) {
            for (Map.Entry<VariableData, VarUsage> entry : eventVarUsage.varUses.entrySet()) {
                List vu = (List)varUsageMap.get(entry.getKey());
                if (vu == null) {
                    vu = Lists.list();
                    varUsageMap.put(entry.getKey(), vu);
                }
                vu.add(entry.getValue());
            }
        }
        for (Map.Entry entry : varUsageMap.entrySet()) {
            evu.varUses.put((VariableData)entry.getKey(), this.computeCombinedVarUse((List)entry.getValue()));
        }
        return evu;
    }

    private VarUsage computeCombinedVarUse(List<VarUsage> uses) {
        VarUsage result = null;
        for (VarUsage vu : uses) {
            if (result == null) {
                result = vu.copy();
                continue;
            }
            result.merge(vu);
        }
        Assert.notNull(result);
        return result;
    }

    @Override
    public void addDefinitions(NameMaps names, Set<VariableData> localVars, VBox code) {
        for (ProcessNode node : this.children) {
            node.addDefinitions(names, localVars, code);
        }
    }

    @Override
    public void addInstantiations(NameMaps names, Set<VariableData> localVars, VBox code) {
        VariableProcessNode variableChild = null;
        for (ProcessNode node : this.children) {
            if (!(node instanceof VariableProcessNode)) continue;
            variableChild = (VariableProcessNode)node;
            break;
        }
        VBox vb = new VBox();
        int closingParens = 0;
        if (variableChild == null) {
            closingParens += this.addAllows(names, vb);
        } else {
            closingParens += this.addReadWriteBlocks(variableChild, names, vb);
            closingParens += this.addReadWriteSync(variableChild, names, vb);
        }
        Map<VariableData, Integer> maxVarReadAccess = this.getMaxBehaviorProcessAccessCount(true);
        Map<VariableData, Integer> maxVarWriteAccess = this.getMaxBehaviorProcessAccessCount(false);
        closingParens += this.addBehProcessSync(names, vb, maxVarReadAccess, maxVarWriteAccess);
        closingParens += this.addEventSynchronization(names, vb);
        boolean first = true;
        vb.add("(");
        ++closingParens;
        for (ProcessNode node : this.children) {
            if (!first) {
                vb.add("||");
            }
            first = false;
            VBox childBox = new VBox();
            node.addInstantiations(names, localVars, childBox);
            vb.add((Box)new HBox(new Object[]{"  ", childBox}));
        }
        if (closingParens > 0) {
            vb.add(Strings.duplicate((String)")", (int)closingParens));
        }
        code.add((Box)vb);
    }

    private int addReadWriteBlocks(VariableProcessNode varProc, NameMaps names, VBox code) {
        DiscVariable var = varProc.variable.variable;
        String blockText = Strings.fmt((String)"block({%s, %s, %s, %s},", (Object[])new Object[]{names.getBehRead(var), names.getBehWrite(var), names.getVarRead(var), names.getVarWrite(var)});
        HBox hb = new HBox();
        hb.add(blockText);
        code.add((Box)hb);
        return 1;
    }

    private int addReadWriteSync(VariableProcessNode varProc, NameMaps names, VBox code) {
        DiscVariable var = varProc.variable.variable;
        HBox hb = new HBox();
        hb.add(Strings.fmt((String)"hide({%s},", (Object[])new Object[]{names.getVarSync(var)}));
        code.add((Box)hb);
        String rdSync = Strings.fmt((String)"%s | %s -> %s", (Object[])new Object[]{names.getBehRead(var), names.getVarRead(var), names.getVarSync(var)});
        String wtSync = Strings.fmt((String)"%s | %s -> %s", (Object[])new Object[]{names.getBehWrite(var), names.getVarWrite(var), names.getVarSync(var)});
        code.add((Box)new HBox(new Object[]{"comm(", CombinedProcessNode.vertBoxify(Lists.list((Object[])new String[]{rdSync, wtSync})), ","}));
        return 2;
    }

    private int addAllows(NameMaps names, VBox code) {
        List allows = Lists.list();
        for (VariableData val : this.valueVars) {
            if (!val.getHasValueAction()) continue;
            allows.add(names.getVariableValue(val.variable));
        }
        List vus = Lists.list();
        for (EventVarUsage evu : this.eventVarUse.values()) {
            vus.clear();
            for (VarUsage vu : evu.varUses.values()) {
                vus.add(vu);
            }
            this.addActions(names.getEventName(evu.event), vus, 0, false, allows, names);
        }
        if (allows.isEmpty()) {
            return 0;
        }
        code.add((Box)new HBox(new Object[]{"allow(", CombinedProcessNode.vertBoxify(allows), ","}));
        return 1;
    }

    private void addActions(String prefix, List<VarUsage> varUsages, int index, boolean readAccess, List<String> actions, NameMaps names) {
        if (index == varUsages.size()) {
            actions.add(prefix);
            return;
        }
        VarUsage vu = varUsages.get(index);
        VariableData varData = vu.var;
        DiscVariable dv = varData.variable;
        if (readAccess) {
            if (!vu.readAccess.everUsed || !vu.readAccess.alwaysUsed) {
                if (this.availProcessVars.contains(varData)) {
                    this.addActions(prefix + " | " + names.getVarRead(dv), varUsages, index + 1, false, actions, names);
                } else {
                    this.addActions(prefix, varUsages, index + 1, false, actions, names);
                }
            }
            if (vu.readAccess.everUsed) {
                this.addActions(prefix + " | " + names.getBehRead(dv), varUsages, index + 1, false, actions, names);
            }
        } else {
            if (!vu.writeAccess.everUsed || !vu.writeAccess.alwaysUsed) {
                if (this.availProcessVars.contains(varData)) {
                    this.addActions(prefix + " | " + names.getVarWrite(dv), varUsages, index, true, actions, names);
                } else {
                    this.addActions(prefix, varUsages, index, true, actions, names);
                }
            }
            if (vu.writeAccess.everUsed) {
                this.addActions(prefix + " | " + names.getBehWrite(dv), varUsages, index, true, actions, names);
            }
        }
    }

    private int addBehProcessSync(NameMaps names, VBox code, Map<VariableData, Integer> mvra, Map<VariableData, Integer> mvwa) {
        String behAction;
        DiscVariable dv;
        List rewrites = Lists.list();
        for (Map.Entry<VariableData, Integer> entry : mvra.entrySet()) {
            dv = entry.getKey().variable;
            behAction = names.getBehRead(dv);
            this.addBehActionSync(rewrites, behAction, entry.getValue());
        }
        for (Map.Entry<VariableData, Integer> entry : mvwa.entrySet()) {
            dv = entry.getKey().variable;
            behAction = names.getBehWrite(dv);
            this.addBehActionSync(rewrites, behAction, entry.getValue());
        }
        if (rewrites.isEmpty()) {
            return 0;
        }
        int i = rewrites.size() - 1;
        while (i >= 0) {
            code.add((Box)new HBox(new Object[]{"comm(", CombinedProcessNode.vertBoxify((List)rewrites.get(i)), ","}));
            --i;
        }
        return rewrites.size();
    }

    private void addBehActionSync(List<List<String>> rewrites, String actName, int count) {
        int index = 0;
        while (count >= 2) {
            Object s = "";
            int i = 0;
            while (i < count / 2 + 1) {
                if (!((String)s).isEmpty()) {
                    s = (String)s + " | ";
                }
                s = (String)s + actName;
                ++i;
            }
            s = (String)s + " -> " + actName;
            if (rewrites.size() == index) {
                List elm = Lists.list();
                rewrites.add(elm);
            }
            rewrites.get(index).add((String)s);
            count = count - (count / 2 + 1) + 1;
            ++index;
        }
        return;
    }

    private Map<VariableData, Integer> getMaxBehaviorProcessAccessCount(boolean readAccess) {
        Set accessedVars = Sets.set();
        for (ProcessNode node : this.children) {
            for (EventVarUsage evu : node.eventVarUse.values()) {
                accessedVars.addAll(evu.varUses.keySet());
            }
        }
        Map maxCount = Maps.map();
        for (VariableData vd : accessedVars) {
            int largest = 0;
            for (Event event : this.eventVarUse.keySet()) {
                int total = 0;
                for (ProcessNode node : this.children) {
                    VarUsage vu;
                    EventVarUsage evu = node.eventVarUse.get(event);
                    if (evu == null || (vu = evu.varUses.get(vd)) == null) continue;
                    if (readAccess) {
                        if (!vu.readAccess.everUsed) continue;
                        ++total;
                        continue;
                    }
                    if (!vu.writeAccess.everUsed) continue;
                    ++total;
                }
                if (largest >= total) continue;
                largest = total;
            }
            maxCount.put(vd, largest);
        }
        return maxCount;
    }

    private int addEventSynchronization(NameMaps names, VBox code) {
        List eventCounts = Lists.list();
        for (Event event : this.eventVarUse.keySet()) {
            int count = 0;
            for (ProcessNode processNode : this.children) {
                if (!processNode.eventVarUse.containsKey(event)) continue;
                ++count;
            }
            if (count <= true) continue;
            eventCounts.add(Pair.pair((Object)event, (Object)count));
        }
        if (eventCounts.isEmpty()) {
            return 0;
        }
        List lines = Lists.listc((int)eventCounts.size());
        for (Pair evtCount : eventCounts) {
            lines.add(Strings.fmt((String)"%s -> %s", (Object[])new Object[]{names.getRenamedEventName((Event)evtCount.left), names.getEventName((Event)evtCount.left)}));
        }
        code.add((Box)new HBox(new Object[]{"rename(", CombinedProcessNode.vertBoxify(lines), ","}));
        boolean first = true;
        HBox line = new HBox();
        for (Pair evtCount : eventCounts) {
            if (!first) {
                line.add(", ");
            }
            first = false;
            line.add(names.getEventName((Event)evtCount.left));
        }
        code.add((Box)new HBox(new Object[]{"block({", line, "},"}));
        lines = Lists.listc((int)eventCounts.size());
        for (Pair evtCount : eventCounts) {
            String string = names.getEventName((Event)evtCount.left);
            Object line2 = "";
            int count = 0;
            while (count < (Integer)evtCount.right) {
                if (!((String)line2).isEmpty()) {
                    line2 = (String)line2 + " | ";
                }
                line2 = (String)line2 + string;
                ++count;
            }
            lines.add(Strings.fmt((String)"%s -> %s", (Object[])new Object[]{line2, names.getRenamedEventName((Event)evtCount.left)}));
        }
        code.add((Box)new HBox(new Object[]{"comm(", CombinedProcessNode.vertBoxify(lines), ","}));
        return 3;
    }

    @Override
    public void dumpActions(StreamCodeBox code) {
        super.dumpActions(code);
        code.add();
        code.add("Children:");
        code.indent();
        for (ProcessNode pn : this.children) {
            code.add("node " + pn.name);
        }
        code.dedent();
        for (ProcessNode pn : this.children) {
            code.add();
            pn.dumpActions(code);
        }
    }

    private static VBox vertBoxify(List<String> lines) {
        VBox vb = new VBox();
        int last = lines.size() - 1;
        int idx = 0;
        while (idx <= last) {
            String line = Strings.fmt((String)"%s%s%s", (Object[])new Object[]{idx == 0 ? "{" : " ", lines.get(idx), idx == last ? "}" : ","});
            vb.add(line);
            ++idx;
        }
        return vb;
    }
}

