/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2mcrl2.tree;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.cif2mcrl2.NameMaps;
import org.eclipse.escet.cif.cif2mcrl2.storage.AutomatonData;
import org.eclipse.escet.cif.cif2mcrl2.storage.EventVarUsage;
import org.eclipse.escet.cif.cif2mcrl2.storage.VariableData;
import org.eclipse.escet.cif.cif2mcrl2.tree.ProcessNode;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.HBox;
import org.eclipse.escet.common.box.VBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;

public class AutomatonProcessNode
extends ProcessNode {
    public final AutomatonData autData;

    public AutomatonProcessNode(String name, AutomatonData autData) {
        super(name);
        this.autData = autData;
    }

    @Override
    protected String getCifName() {
        return "automaton " + this.autData.name;
    }

    @Override
    public void deriveActions(Set<VariableData> localVars) {
        this.valueVars = Sets.set();
        for (VariableData vd : this.autData.vars.values()) {
            if (!localVars.contains(vd)) continue;
            this.valueVars.add(vd);
        }
        this.availProcessVars = Sets.set();
        this.eventVarUse = Maps.map();
        for (Location loc : this.autData.aut.getLocations()) {
            for (Edge edge : loc.getEdges()) {
                Set<VariableData> readVars = this.autData.getReadVariables(edge);
                Set<VariableData> writeVars = this.autData.getWriteVariables(edge);
                for (Event evt : this.autData.getEvents(edge)) {
                    EventVarUsage evu = (EventVarUsage)this.eventVarUse.get(evt);
                    boolean firstEdge = false;
                    if (evu == null) {
                        evu = new EventVarUsage(evt);
                        this.eventVarUse.put(evt, evu);
                        firstEdge = true;
                    }
                    evu.addReadEdgeAccess(readVars, firstEdge, localVars);
                    evu.addWriteEdgeAccess(writeVars, firstEdge, localVars);
                }
            }
        }
        for (Event evt : this.autData.getAlphabet()) {
            if (this.eventVarUse.containsKey(evt)) continue;
            EventVarUsage evu = new EventVarUsage(evt);
            this.eventVarUse.put(evt, evu);
        }
    }

    @Override
    public void addDefinitions(NameMaps names, Set<VariableData> localVars, VBox code) {
        String behProcName = names.getBehaviorProcess(this.autData.aut);
        String locSortName = names.getLocationSortName(this.autData.aut);
        String locVarName = names.getLocationVariableName(this.autData.aut);
        HBox locNamesBox = new HBox(" | ");
        for (Location loc : this.autData.aut.getLocations()) {
            locNamesBox.add(names.getLocationName(loc, this.autData.aut));
        }
        code.add((Box)new HBox(new Object[]{"sort ", locSortName, " = struct ", locNamesBox, ";"}));
        code.add();
        boolean addedAct = false;
        for (VariableData vd : this.autData.vars.values()) {
            if (!localVars.contains(vd) || !vd.getHasValueAction()) continue;
            String varVal = names.getVariableValue(vd.variable);
            Iterator<VariableData> typeName = names.getTypeName(vd.getType());
            code.add("act " + varVal + " : " + (String)((Object)typeName) + ";");
            addedAct = true;
        }
        if (addedAct) {
            code.add();
        }
        Object selfloopParams = locVarName;
        String params = locVarName + " : " + locSortName;
        for (VariableData vd : this.autData.vars.values()) {
            if (!localVars.contains(vd)) continue;
            String varName = names.getVariableName(vd.variable);
            String typeName = names.getTypeName(vd.getType());
            params = params + ", " + varName + " : " + typeName;
            selfloopParams = (String)selfloopParams + ", " + varName;
        }
        code.add(Strings.fmt((String)"proc %s(%s) =", (Object[])new Object[]{behProcName, params}));
        for (VariableData vd : this.autData.vars.values()) {
            if (!localVars.contains(vd) || !vd.getHasValueAction()) continue;
            String varVal = names.getVariableValue(vd.variable);
            String varName = names.getVariableName(vd.variable);
            code.add(Strings.fmt((String)"  %s(%s) . %s(%s) +", (Object[])new Object[]{varVal, varName, behProcName, selfloopParams}));
        }
        int edgeCount = 0;
        for (Location loc : this.autData.aut.getLocations()) {
            for (Edge edge : loc.getEdges()) {
                edgeCount += edge.getEvents().size();
            }
        }
        int idx = 0;
        int last = edgeCount - 1;
        for (Location loc : this.autData.aut.getLocations()) {
            for (Edge edge : loc.getEdges()) {
                for (EdgeEvent ee : edge.getEvents()) {
                    Box b = this.makeEdge(names, localVars, loc, edge, ee);
                    b = new HBox(new Object[]{"  ", b, idx == last ? ";" : " +"});
                    code.add(b);
                    ++idx;
                }
            }
        }
        code.add();
    }

    private Box makeEdge(NameMaps names, Set<VariableData> localVars, Location loc, Edge edge, EdgeEvent event) {
        Set<VariableData> readVars = this.autData.getReadVariables(edge);
        List sums = Lists.list();
        List conds = Lists.list();
        List actions = Lists.list();
        for (VariableData vd : readVars) {
            if (localVars.contains(vd)) continue;
            String varName = names.getVariableName(vd.variable);
            String varType = names.getTypeName(vd.variable.getType());
            sums.add(Strings.fmt((String)"sum %s : %s . ", (Object[])new Object[]{varName, varType}));
            Object limit = vd.getLowerLimit();
            if (limit != null) {
                conds.add(Strings.fmt((String)"(%s >= %d)", (Object[])new Object[]{varName, limit}));
            }
            if ((limit = vd.getUpperLimit()) == null) continue;
            conds.add(Strings.fmt((String)"(%s <= %d)", (Object[])new Object[]{varName, limit}));
        }
        String locVar = names.getLocationVariableName(this.autData.aut);
        String locName = names.getLocationName(loc, this.autData.aut);
        conds.add(Strings.fmt((String)"(%s == %s)", (Object[])new Object[]{locVar, locName}));
        if (!edge.getGuards().isEmpty()) {
            conds.add(this.makeExpression(names, (List<Expression>)edge.getGuards()));
        }
        EventExpression eex = (EventExpression)event.getEvent();
        actions.add(names.getEventName(eex.getEvent()));
        for (VariableData vd : readVars) {
            if (localVars.contains(vd)) continue;
            String varName = names.getVariableName(vd.variable);
            String behRead = names.getBehRead(vd.variable);
            actions.add(Strings.fmt((String)"%s(%s)", (Object[])new Object[]{behRead, varName}));
        }
        Map newLocalValues = Maps.map();
        for (Update upd : edge.getUpdates()) {
            Assignment asg = (Assignment)upd;
            String asgVal = this.makeExpression(names, asg.getValue());
            DiscVariableExpression dve = (DiscVariableExpression)asg.getAddressable();
            VariableData wVar = this.autData.vars.get(dve.getVariable());
            Assert.notNull((Object)wVar);
            if (localVars.contains(wVar)) {
                Integer limit = wVar.getLowerLimit();
                if (limit != null) {
                    conds.add(Strings.fmt((String)"(%s >= %d)", (Object[])new Object[]{asgVal, limit}));
                }
                if ((limit = wVar.getUpperLimit()) != null) {
                    conds.add(Strings.fmt((String)"(%s <= %d)", (Object[])new Object[]{asgVal, limit}));
                }
                newLocalValues.put(wVar, asgVal);
                continue;
            }
            String behWrite = names.getBehWrite(dve.getVariable());
            actions.add(Strings.fmt((String)"%s(%s)", (Object[])new Object[]{behWrite, asgVal}));
        }
        String behProcName = names.getBehaviorProcess(this.autData.aut);
        String targetLocName = edge.getTarget() == null ? names.getLocationVariableName(this.autData.aut) : names.getLocationName(edge.getTarget(), this.autData.aut);
        Object params = targetLocName;
        for (VariableData vd : this.autData.vars.values()) {
            if (!localVars.contains(vd)) continue;
            Object nVal = (String)newLocalValues.get(vd);
            if (nVal == null) {
                nVal = names.getVariableName(vd.variable);
            }
            params = (String)params + ", " + (String)nVal;
        }
        HBox line = new HBox();
        for (String s : sums) {
            line.add(s);
        }
        Assert.check((!conds.isEmpty() ? 1 : 0) != 0);
        if (conds.size() == 1) {
            line.add((String)conds.get(0) + " -> ");
        } else {
            line.add("(");
            boolean first = true;
            for (String c : conds) {
                if (!first) {
                    line.add(" && ");
                }
                line.add(c);
                first = false;
            }
            line.add(") -> ");
        }
        boolean first = true;
        for (String a : actions) {
            if (!first) {
                line.add(" | ");
            }
            first = false;
            line.add(a);
        }
        line.add(Strings.fmt((String)" . %s(%s)", (Object[])new Object[]{behProcName, params}));
        return line;
    }

    private String makeExpression(NameMaps names, List<Expression> exprs) {
        if (exprs.isEmpty()) {
            return "true";
        }
        Object line = "";
        for (Expression e : exprs) {
            if (!((String)line).isEmpty()) {
                line = (String)line + " && ";
            }
            line = (String)line + this.makeExpression(names, e);
        }
        return line;
    }

    private String makeExpression(NameMaps names, Expression expr) {
        if (expr instanceof BoolExpression) {
            BoolExpression be = (BoolExpression)expr;
            return be.isValue() ? "true" : "false";
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression be = (BinaryExpression)expr;
            String left = this.makeExpression(names, be.getLeft());
            String right = this.makeExpression(names, be.getRight());
            switch (be.getOperator()) {
                case CONJUNCTION: {
                    return "(" + left + " && " + right + ")";
                }
                case DISJUNCTION: {
                    return "(" + left + " || " + right + ")";
                }
                case EQUAL: {
                    return "(" + left + " == " + right + ")";
                }
                case GREATER_EQUAL: {
                    return "(" + left + " >= " + right + ")";
                }
                case GREATER_THAN: {
                    return "(" + left + " > " + right + ")";
                }
                case LESS_EQUAL: {
                    return "(" + left + " <= " + right + ")";
                }
                case LESS_THAN: {
                    return "(" + left + " < " + right + ")";
                }
                case UNEQUAL: {
                    return "(" + left + " != " + right + ")";
                }
                case ADDITION: {
                    return "(" + left + " + " + right + ")";
                }
                case MULTIPLICATION: {
                    return "(" + left + " * " + right + ")";
                }
                case SUBTRACTION: {
                    return "(" + left + " - " + right + ")";
                }
                case IMPLICATION: {
                    return "(" + left + " => " + right + ")";
                }
            }
            Assert.fail((Object)Strings.fmt((String)"Unexpected binary operator %s found.", (Object[])new Object[]{be.getOperator()}));
        } else if (expr instanceof UnaryExpression) {
            UnaryExpression ue = (UnaryExpression)expr;
            String child = this.makeExpression(names, ue.getChild());
            switch (ue.getOperator()) {
                case INVERSE: {
                    return "!" + child;
                }
                case NEGATE: {
                    return "-" + child;
                }
                case PLUS: {
                    return child;
                }
            }
            Assert.fail((Object)Strings.fmt((String)"Unexpected unary operator %s found.", (Object[])new Object[]{ue.getOperator()}));
        } else {
            if (expr instanceof DiscVariableExpression) {
                DiscVariableExpression de = (DiscVariableExpression)expr;
                return names.getVariableName(de.getVariable());
            }
            if (expr instanceof IntExpression) {
                IntExpression ie = (IntExpression)expr;
                return Integer.toString(ie.getValue());
            }
            if (expr instanceof EnumLiteralExpression) {
                EnumLiteralExpression ele = (EnumLiteralExpression)expr;
                return names.getEnumLitName(ele.getLiteral());
            }
        }
        throw new RuntimeException("Unexpected expression: " + String.valueOf(expr));
    }

    @Override
    public void addInstantiations(NameMaps names, Set<VariableData> localVars, VBox code) {
        String behProcName = names.getBehaviorProcess(this.autData.aut);
        Location initLoc = this.autData.initialLocation;
        Object params = names.getLocationName(initLoc, this.autData.aut);
        for (VariableData vd : this.autData.vars.values()) {
            if (!localVars.contains(vd)) continue;
            params = (String)params + Strings.fmt((String)", %s", (Object[])new Object[]{vd.initialValue});
        }
        code.add(Strings.fmt((String)"%s(%s)", (Object[])new Object[]{behProcName, params}));
    }
}

