/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2mcrl2;

public class InstanceTreeScanner {
    private int index = 0;
    private final String text;
    private String token;

    public InstanceTreeScanner(String text) {
        this.text = text;
        this.scanNext();
    }

    public void scanNext() {
        char k;
        while (this.index < this.text.length()) {
            k = this.text.charAt(this.index);
            if (k != ' ' && k != ',' && k != '\t' && k != '\n' && k != '\r') break;
            ++this.index;
        }
        if (this.index == this.text.length()) {
            this.token = null;
            return;
        }
        k = this.text.charAt(this.index);
        if (k == '(') {
            this.token = "(";
            ++this.index;
            return;
        }
        if (k == ')') {
            this.token = ")";
            ++this.index;
            return;
        }
        int j = this.index++;
        while (this.index < this.text.length()) {
            k = this.text.charAt(this.index);
            if (k == ' ' || k == ',' || k == '\t' || k == '\n' || k == '\r' || k == '(' || k == ')') break;
            ++this.index;
        }
        this.token = this.text.substring(j, this.index);
    }

    public boolean peekEOF() {
        return this.token == null;
    }

    public boolean peekParOpen() {
        return !this.peekEOF() && this.token.equals("(");
    }

    public boolean peekParClose() {
        return !this.peekEOF() && this.token.equals(")");
    }

    public String peekName() {
        if (this.peekEOF() || this.peekParOpen() || this.peekParClose()) {
            return null;
        }
        return this.token;
    }
}

