/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2mcrl2;

import java.util.List;
import org.eclipse.escet.cif.cif2mcrl2.InstanceTreeScanner;
import org.eclipse.escet.cif.cif2mcrl2.tree.CombinedTextNode;
import org.eclipse.escet.cif.cif2mcrl2.tree.ElementaryTextNode;
import org.eclipse.escet.cif.cif2mcrl2.tree.TextNode;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.exceptions.InvalidInputException;

public class InstanceTreeHelper {
    private InstanceTreeHelper() {
    }

    public static TextNode parseTreeText(String text) {
        InstanceTreeScanner scanner = new InstanceTreeScanner(text);
        return InstanceTreeHelper.parseTreeText(scanner, true);
    }

    private static TextNode parseTreeText(InstanceTreeScanner scanner, boolean outer) {
        if (!outer) {
            Assert.check((boolean)scanner.peekParOpen());
            scanner.scanNext();
        }
        List nodes = Lists.list();
        while (true) {
            if (scanner.peekParOpen()) {
                nodes.add(InstanceTreeHelper.parseTreeText(scanner, false));
                continue;
            }
            String name = scanner.peekName();
            if (name == null) break;
            nodes.add(new ElementaryTextNode(name));
            scanner.scanNext();
        }
        TextNode n = switch (nodes.size()) {
            case 0 -> {
                String msg = "Missing node name in the instance tree option text.";
                throw new InvalidInputException(msg);
            }
            case 1 -> (TextNode)nodes.get(0);
            default -> new CombinedTextNode(nodes);
        };
        if (outer) {
            if (scanner.peekEOF()) {
                return n;
            }
            Assert.check((boolean)scanner.peekParClose());
            String msg = "Unexpected ')' at top-level in the instance tree option text.";
            throw new InvalidInputException(msg);
        }
        if (scanner.peekParClose()) {
            scanner.scanNext();
            return n;
        }
        Assert.check((boolean)scanner.peekEOF());
        String msg = "Missing ')' in the instance tree option text.";
        throw new InvalidInputException(msg);
    }
}

