/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2mcrl2;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeReceive;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeSend;
import org.eclipse.escet.cif.metamodel.cif.automata.IfUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.TypeDecl;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryOperator;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.UnsupportedException;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class Cif2Mcrl2PreChecker {
    public List<String> problems = null;

    public void checkSpec(Specification spec) {
        this.problems = Lists.list();
        if (!this.checkGroup((Group)spec)) {
            this.problems.add("Specification must have at least one automaton.");
        }
        if (this.problems.isEmpty()) {
            return;
        }
        Collections.sort(this.problems, Strings.SORTER);
        if (!this.problems.isEmpty()) {
            String msg = "CIF to mCRL2 transformation failed due to unsatisfied preconditions:\n - " + String.join((CharSequence)"\n - ", this.problems);
            throw new UnsupportedException(msg);
        }
    }

    private boolean checkGroup(Group grp) {
        Assert.check((boolean)grp.getDefinitions().isEmpty());
        this.checkComponent((ComplexComponent)grp);
        boolean foundAut = false;
        for (Component c : grp.getComponents()) {
            if (c instanceof Automaton) {
                foundAut = true;
                Automaton aut = (Automaton)c;
                this.checkAutomaton(aut);
                continue;
            }
            if (c instanceof Group) {
                Group g = (Group)c;
                foundAut |= this.checkGroup(g);
                continue;
            }
            throw new RuntimeException("Unexpected type of Component.");
        }
        return foundAut;
    }

    private void checkAutomaton(Automaton aut) {
        Object msg;
        this.checkComponent((ComplexComponent)aut);
        for (Declaration decl : aut.getDeclarations()) {
            if (!(decl instanceof DiscVariable)) continue;
            DiscVariable dv = (DiscVariable)decl;
            CifType tp = CifTypeUtils.normalizeType((CifType)dv.getType());
            if (!(tp instanceof BoolType || tp instanceof IntType || tp instanceof EnumType)) {
                msg = Strings.fmt((String)"Discrete variable \"%s\" does not have a boolean, integer, or enumeration type.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)dv)});
                this.problems.add((String)msg);
                continue;
            }
            if (dv.getValue().getValues().size() != 1) {
                msg = Strings.fmt((String)"Discrete variable \"%s\" does not have a single initial value.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)dv)});
                this.problems.add((String)msg);
                continue;
            }
            try {
                CifEvalUtils.eval((Expression)((Expression)dv.getValue().getValues().get(0)), (boolean)true);
            }
            catch (CifEvalException err) {
                msg = Strings.fmt((String)"Initial value of discrete variable \"%s\" cannot be evaluated.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)dv)});
                this.problems.add((String)msg);
            }
        }
        for (Location loc : aut.getLocations()) {
            String locTextMid = CifTextUtils.getLocationText2((Location)loc);
            String locTextStart = StringUtils.capitalize((String)locTextMid);
            if (!loc.getInvariants().isEmpty()) {
                msg = locTextStart + " has invariants.";
                this.problems.add((String)msg);
            }
            if (!loc.getEquations().isEmpty()) {
                msg = locTextStart + " has equations.";
                this.problems.add((String)msg);
            }
            for (Edge edge : loc.getEdges()) {
                for (Update upd : edge.getUpdates()) {
                    Expression e;
                    if (upd instanceof IfUpdate) {
                        msg = locTextStart + " has conditional updates.";
                        this.problems.add((String)msg);
                        continue;
                    }
                    Assignment asg = (Assignment)upd;
                    msg = this.checkExpression(asg.getValue());
                    if (msg != null) {
                        msg = Strings.fmt((String)"A value in %s %s", (Object[])new Object[]{locTextMid, msg});
                        this.problems.add((String)msg);
                    }
                    if ((e = asg.getAddressable()) instanceof DiscVariableExpression) continue;
                    msg = Strings.fmt((String)"An assignment in %s assigns to unsupported addressable form \"%s\".", (Object[])new Object[]{locTextMid, CifTextUtils.exprToStr((Expression)e)});
                    this.problems.add((String)msg);
                }
                for (Expression e : edge.getGuards()) {
                    msg = this.checkExpression(e);
                    if (msg == null) continue;
                    msg = Strings.fmt((String)"A guard in %s %s", (Object[])new Object[]{locTextMid, msg});
                    this.problems.add((String)msg);
                }
                if (edge.getEvents().isEmpty()) {
                    msg = locTextStart + " has a \"tau\" event.";
                    this.problems.add((String)msg);
                    continue;
                }
                for (EdgeEvent ee : edge.getEvents()) {
                    if (ee instanceof EdgeSend) {
                        msg = locTextStart + " has a send edge.";
                        this.problems.add((String)msg);
                        continue;
                    }
                    if (ee instanceof EdgeReceive) {
                        msg = locTextStart + " has a receive edge.";
                        this.problems.add((String)msg);
                        continue;
                    }
                    if (ee.getEvent() instanceof TauExpression) {
                        msg = locTextStart + " has a \"tau\" event.";
                        this.problems.add((String)msg);
                        continue;
                    }
                    Assert.check((boolean)(ee.getEvent() instanceof EventExpression));
                }
            }
        }
        int initLocCount = 0;
        for (Location loc : aut.getLocations()) {
            if (loc.getInitials().isEmpty() || !CifValueUtils.isTriviallyTrue((List)loc.getInitials(), (boolean)true, (boolean)true)) continue;
            ++initLocCount;
        }
        if (initLocCount == 0) {
            msg = Strings.fmt((String)"Automaton \"%s\" has no initial location.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)aut)});
            this.problems.add((String)msg);
        }
        if (initLocCount > 1) {
            msg = Strings.fmt((String)"Automaton \"%s\" has more than one initial location.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)aut)});
            this.problems.add((String)msg);
        }
    }

    private String checkExpression(Expression e) {
        CifType t = CifTypeUtils.normalizeType((CifType)e.getType());
        if (t instanceof BoolType) {
            if (e instanceof BoolExpression) {
                return null;
            }
            if (e instanceof BinaryExpression) {
                BinaryExpression be = (BinaryExpression)e;
                switch (be.getOperator()) {
                    case DISJUNCTION: 
                    case IMPLICATION: 
                    case CONJUNCTION: 
                    case LESS_THAN: 
                    case LESS_EQUAL: 
                    case GREATER_THAN: 
                    case GREATER_EQUAL: 
                    case EQUAL: 
                    case UNEQUAL: {
                        break;
                    }
                    default: {
                        String msg = Strings.fmt((String)"has unsupported boolean binary operator \"%s\".", (Object[])new Object[]{CifTextUtils.operatorToStr((BinaryOperator)be.getOperator())});
                        return msg;
                    }
                }
                String msg = this.checkExpression(be.getLeft());
                if (msg == null) {
                    msg = this.checkExpression(be.getRight());
                }
                return msg;
            }
            if (e instanceof UnaryExpression) {
                UnaryExpression ue = (UnaryExpression)e;
                switch (ue.getOperator()) {
                    case INVERSE: {
                        break;
                    }
                    default: {
                        String msg = Strings.fmt((String)"has unsupported boolean unary operator \"%s\".", (Object[])new Object[]{CifTextUtils.operatorToStr((UnaryOperator)ue.getOperator())});
                        return msg;
                    }
                }
                return this.checkExpression(ue.getChild());
            }
            if (e instanceof DiscVariableExpression) {
                return null;
            }
            return Strings.fmt((String)"has unsupported boolean expression \"%s\".", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)e)});
        }
        if (t instanceof IntType) {
            if (e instanceof IntExpression) {
                return null;
            }
            if (e instanceof BinaryExpression) {
                BinaryExpression be = (BinaryExpression)e;
                switch (be.getOperator()) {
                    case MULTIPLICATION: 
                    case SUBTRACTION: 
                    case ADDITION: {
                        break;
                    }
                    default: {
                        String msg = Strings.fmt((String)"has unsupported integer binary operator \"%s\".", (Object[])new Object[]{CifTextUtils.operatorToStr((BinaryOperator)be.getOperator())});
                        return msg;
                    }
                }
                String msg = this.checkExpression(be.getLeft());
                if (msg == null) {
                    msg = this.checkExpression(be.getRight());
                }
                return msg;
            }
            if (e instanceof UnaryExpression) {
                UnaryExpression ue = (UnaryExpression)e;
                switch (ue.getOperator()) {
                    case NEGATE: 
                    case PLUS: {
                        break;
                    }
                    default: {
                        String msg = Strings.fmt((String)"has unsupported integer unary operator \"%s\".", (Object[])new Object[]{CifTextUtils.operatorToStr((UnaryOperator)ue.getOperator())});
                        return msg;
                    }
                }
                return this.checkExpression(ue.getChild());
            }
            if (e instanceof DiscVariableExpression) {
                return null;
            }
            return Strings.fmt((String)"has unsupported integer expression \"%s\".", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)e)});
        }
        if (t instanceof EnumType) {
            if (e instanceof EnumLiteralExpression) {
                return null;
            }
            if (e instanceof DiscVariableExpression) {
                return null;
            }
            return Strings.fmt((String)"has unsupported enumeration expression \"%s\".", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)e)});
        }
        String msg = CifTextUtils.typeToStr((CifType)t);
        return Strings.fmt((String)"has an unsupported type \"%s\" in expression \"%s\".", (Object[])new Object[]{msg, CifTextUtils.exprToStr((Expression)e)});
    }

    private void checkDeclarations(List<Declaration> decls) {
        for (Declaration decl : decls) {
            if (!(decl instanceof AlgVariable) && !(decl instanceof Constant)) {
                String msg;
                if (decl instanceof EnumDecl || decl instanceof Event) continue;
                if (decl instanceof ContVariable) {
                    msg = Strings.fmt((String)"Continuous variable \"%s\" is unsupported in the transformation.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)decl)});
                    this.problems.add(msg);
                    continue;
                }
                if (decl instanceof Function || decl instanceof TypeDecl || decl instanceof DiscVariable) continue;
                if (decl instanceof InputVariable) {
                    msg = Strings.fmt((String)"Input variable \"%s\" is unsupported in the transformation.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)decl)});
                    this.problems.add(msg);
                    continue;
                }
            }
            throw new RuntimeException("Unexpected type of CIF declaration.");
        }
    }

    private void checkComponent(ComplexComponent comp) {
        String msg;
        Assert.check((boolean)comp.getIoDecls().isEmpty());
        this.checkDeclarations((List<Declaration>)comp.getDeclarations());
        if (!comp.getEquations().isEmpty()) {
            msg = Strings.fmt((String)"Equations are not supported in %s.", (Object[])new Object[]{CifTextUtils.getComponentText2((ComplexComponent)comp)});
            this.problems.add(msg);
        }
        if (!comp.getInitials().isEmpty()) {
            msg = Strings.fmt((String)"Initialization predicates are not supported in %s.", (Object[])new Object[]{CifTextUtils.getComponentText2((ComplexComponent)comp)});
            this.problems.add(msg);
        }
        if (!comp.getInvariants().isEmpty()) {
            msg = Strings.fmt((String)"Invariants are not supported in %s.", (Object[])new Object[]{CifTextUtils.getComponentText2((ComplexComponent)comp)});
            this.problems.add(msg);
        }
    }
}

