/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.system.buffering;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphMemFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphPlain;
import org.apache.jena.query.TxnType;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.TransactionalLock;
import org.apache.jena.sparql.graph.GraphWrapper;
import org.apache.jena.system.G;
import org.apache.jena.system.buffering.BufferingCtl;
import org.apache.jena.system.buffering.BufferingPrefixMapping;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class BufferingGraph
extends GraphWrapper
implements BufferingCtl {
    private static final boolean CHECK = true;
    private final Graph addedGraph;
    private final Set<Triple> deletedTriples = new HashSet<Triple>();
    private final BufferingPrefixMapping prefixMapping;
    private Transactional transactional = TransactionalLock.createMRSW();

    public static BufferingGraph create(Graph graph) {
        if (graph instanceof BufferingGraph) {
            Log.warn(BufferingGraph.class, "Creating a BufferingGraph over a BufferingGraph");
        }
        return new BufferingGraph(graph);
    }

    public BufferingGraph(Graph graph) {
        super(graph);
        this.prefixMapping = new BufferingPrefixMapping(graph.getPrefixMapping());
        this.addedGraph = graph.getCapabilities().handlesLiteralTyping() ? GraphMemFactory.createDefaultGraph() : GraphPlain.plain();
    }

    public Graph base() {
        return this.get();
    }

    @Override
    public void flush() {
        Graph base = this.get();
        G.execTxn(base, () -> this.flushDirect(base));
    }

    public void flushDirect() {
        this.transactional.begin(TxnType.WRITE);
        Graph base = this.get();
        this.flushDirect(base);
        this.transactional.commit();
        this.transactional.end();
    }

    private void flushDirect(Graph base) {
        this.deletedTriples.forEach(base::delete);
        this.addedGraph.find().forEachRemaining(base::add);
        this.deletedTriples.clear();
        this.addedGraph.clear();
        this.prefixMapping.flush();
    }

    private void updateOperation() {
    }

    private void readOperation() {
    }

    @Override
    public void add(Triple t) {
        this.execAdd(t);
    }

    @Override
    public void delete(Triple t) {
        this.execDelete(t);
    }

    private void execAdd(Triple triple) {
        this.updateOperation();
        Graph base = this.get();
        this.deletedTriples.remove(triple);
        if (G.containsBySameTerm(this.addedGraph, triple)) {
            return;
        }
        if (G.containsBySameTerm(base, triple)) {
            return;
        }
        this.addedGraph.add(triple);
    }

    private void execDelete(Triple triple) {
        this.updateOperation();
        Graph base = this.get();
        this.addedGraph.delete(triple);
        if (!G.containsBySameTerm(base, triple)) {
            return;
        }
        this.deletedTriples.add(triple);
    }

    public Graph getAdded() {
        return this.addedGraph;
    }

    public Set<Triple> getDeleted() {
        return this.deletedTriples;
    }

    @Override
    public boolean contains(Node s, Node p, Node o) {
        return this.contains(Triple.create(s, p, o));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Triple triple) {
        this.readOperation();
        if (this.addedGraph.contains(triple)) {
            return true;
        }
        Graph base = this.get();
        try (ExtendedIterator<Triple> iter = base.find(triple).filterDrop(t -> this.deletedTriples.contains(t));){
            boolean bl = iter.hasNext();
            return bl;
        }
    }

    @Override
    public ExtendedIterator<Triple> find(Node s, Node p, Node o) {
        this.readOperation();
        Iterator<Triple> extra = this.findInAdded(s, p, o);
        Iter<Triple> iter = Iter.iter(this.get().find(s, p, o)).filter(t -> !this.deletedTriples.contains(t)).append(extra);
        return WrappedIterator.create(iter);
    }

    private Iterator<Triple> findInAdded(Node s, Node p, Node o) {
        return this.addedGraph.find(s, p, o);
    }

    @Override
    public ExtendedIterator<Triple> find(Triple m) {
        return this.find(m.getMatchSubject(), m.getMatchPredicate(), m.getMatchObject());
    }

    @Override
    public PrefixMapping getPrefixMapping() {
        return this.prefixMapping;
    }

    @Override
    public boolean isEmpty() {
        this.readOperation();
        if (!this.addedGraph.isEmpty()) {
            return false;
        }
        Graph base = this.get();
        if (this.deletedTriples.isEmpty()) {
            return base.isEmpty();
        }
        return !this.contains(Triple.ANY);
    }

    @Override
    public int size() {
        this.readOperation();
        return super.size() - this.deletedTriples.size() + this.addedGraph.size();
    }
}

