/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.parser;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.irix.IRIxResolver;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.ParserProfileStd;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.shex.ShapeMap;
import org.apache.jena.shex.ShexSchema;
import org.apache.jena.shex.ShexShape;
import org.apache.jena.shex.expressions.DatatypeConstraint;
import org.apache.jena.shex.expressions.NodeConstraint;
import org.apache.jena.shex.expressions.NodeConstraintComponent;
import org.apache.jena.shex.expressions.NumLengthConstraint;
import org.apache.jena.shex.expressions.NumRangeConstraint;
import org.apache.jena.shex.expressions.ShapeExprVisitor;
import org.apache.jena.shex.expressions.ShapeExpression;
import org.apache.jena.shex.expressions.ShapeNodeConstraint;
import org.apache.jena.shex.expressions.StrLengthConstraint;
import org.apache.jena.shex.expressions.StrLengthKind;
import org.apache.jena.shex.parser.ShexParseException;
import org.apache.jena.shex.parser.javacc.ParseException;
import org.apache.jena.shex.parser.javacc.ShExJavacc;
import org.apache.jena.shex.parser.javacc.TokenMgrError;
import org.apache.jena.shex.sys.ShexLib;
import org.apache.jena.shex.sys.SysShex;
import org.apache.jena.sparql.expr.nodevalue.XSDFuncOp;
import org.apache.jena.sparql.util.Context;

public class ShExC {
    public static ShexSchema parse(String filename) {
        return ShExC.parse(filename, IRILib.filenameToIRI(filename));
    }

    public static ShexSchema parse(String filename, String baseURI) {
        InputStream input = IO.openFile(filename);
        return ShExC.parse(input, filename, baseURI);
    }

    public static ShexSchema parse(InputStream input, String originURI, String baseURI) {
        ShexSchema shexSchema;
        block8: {
            Reader r = ShExC.setReader(input);
            try {
                ShExJavacc parser = new ShExJavacc(r);
                shexSchema = ShExC.parse$(parser, originURI, baseURI, null);
                if (r == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    IO.exception(ex);
                    return null;
                }
            }
            r.close();
        }
        return shexSchema;
    }

    private static Reader setReader(InputStream input) {
        Reader r = IO.asUTF8(input);
        if (!(input instanceof BufferedInputStream)) {
            r = new BufferedReader(r, 131072);
        }
        return r;
    }

    public static ShexSchema parse(StringReader input, String baseURI) {
        try (StringReader in = input;){
            ShExJavacc parser = new ShExJavacc(input);
            ShexSchema shexSchema = ShExC.parse$(parser, null, baseURI, null);
            return shexSchema;
        }
    }

    public static ShapeMap parseShapeMap(String filename) {
        return ShExC.parseShapeMap(filename, IRILib.filenameToIRI(filename));
    }

    public static ShapeMap parseShapeMap(String filename, String baseURI) {
        InputStream input = IO.openFile(filename);
        return ShExC.parseShapeMap(input, baseURI);
    }

    public static ShapeMap parseShapeMap(InputStream input, String baseURI) {
        ShapeMap shapeMap;
        block8: {
            Reader r = ShExC.setReader(input);
            try {
                ShExJavacc parser = new ShExJavacc(r);
                shapeMap = ShExC.parseShapeMap$(parser, baseURI, null);
                if (r == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    IO.exception(ex);
                    return null;
                }
            }
            r.close();
        }
        return shapeMap;
    }

    public static ShapeMap parseShapeMap(StringReader input, String baseURI) {
        ShExJavacc parser = new ShExJavacc(input);
        return ShExC.parseShapeMap$(parser, baseURI, null);
    }

    private static ShexSchema parse$(ShExJavacc parser, String sourceURI, String baseURI, Context context2) {
        ParserProfileStd profile = new ParserProfileStd(RiotLib.factoryRDF(), ErrorHandlerFactory.errorHandlerStd, IRIxResolver.create(baseURI).build(), PrefixMapFactory.create(), context2, false, false);
        sourceURI = IRILib.filenameToIRI(sourceURI);
        parser.setProfile(profile);
        parser.setDest(StreamRDFLib.sinkNull());
        parser.setSourceAndBase(sourceURI, baseURI);
        try {
            parser.parseShapesStart();
            parser.UnitShapes();
            ShexSchema shapes = parser.parseShapesFinish();
            ShExC.validatePhase2(shapes);
            return shapes;
        }
        catch (ParseException ex) {
            throw new ShexParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
        catch (TokenMgrError tErr) {
            int col = parser.token.endColumn;
            int line = parser.token.endLine;
            throw new ShexParseException(tErr.getMessage(), line, col);
        }
    }

    private static void validatePhase2(ShexSchema shapes) {
        if (!SysShex.STRICT) {
            return;
        }
        shapes.getShapes().forEach(shape -> ShExC.validatePhase2(shapes, shape));
    }

    private static void validatePhase2(ShexSchema shapes, ShexShape shape) {
        ShapeExpression shExpr = shape.getShapeExpression();
        CheckFacets checker = new CheckFacets();
        ShexLib.walk(shExpr, checker, null, null);
    }

    private static ShapeMap parseShapeMap$(ShExJavacc parser, String baseURI, Context context2) {
        ParserProfileStd profile = new ParserProfileStd(RiotLib.factoryRDF(), ErrorHandlerFactory.errorHandlerStd, IRIxResolver.create(baseURI).build(), PrefixMapFactory.create(), context2, false, false);
        parser.setProfile(profile);
        parser.setDest(StreamRDFLib.sinkNull());
        try {
            parser.parseShapeMapStart();
            parser.UnitShapeMap();
            ShapeMap map = parser.parseShapeMapFinish();
            return map;
        }
        catch (ParseException ex) {
            throw new ShexParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
        catch (TokenMgrError tErr) {
            int col = parser.token.endColumn;
            int line = parser.token.endLine;
            throw new ShexParseException(tErr.getMessage(), line, col);
        }
    }

    private static class CheckFacets
    implements ShapeExprVisitor {
        private CheckFacets() {
        }

        @Override
        public void visit(ShapeNodeConstraint shape) {
            NodeConstraint nc = shape.getNodeConstraint();
            if (nc == null) {
                return;
            }
            DatatypeConstraint dtConstraint = null;
            HashSet<StrLengthKind> x = new HashSet<StrLengthKind>(3);
            for (NodeConstraintComponent expr : nc.components()) {
                String msg;
                if (expr instanceof StrLengthConstraint) {
                    StrLengthConstraint constraint = (StrLengthConstraint)expr;
                    StrLengthKind lenType = constraint.getLengthType();
                    if (x.contains((Object)lenType)) {
                        throw new ShexParseException("Multiple string length facets of the same kind: " + lenType, -1, -1);
                    }
                    x.add(lenType);
                    continue;
                }
                if (expr instanceof DatatypeConstraint) {
                    dtConstraint = (DatatypeConstraint)expr;
                    continue;
                }
                if (dtConstraint == null || !(expr instanceof NumLengthConstraint) && !(expr instanceof NumRangeConstraint)) continue;
                RDFDatatype rdfDT = dtConstraint.getRDFDatatype();
                if (!(rdfDT instanceof XSDDatatype)) {
                    msg = String.format("Numeric facet: Not a numeric: <%s> ", dtConstraint.getDatatypeURI());
                    throw new ShexParseException(msg, -1, -1);
                }
                if (XSDFuncOp.isNumericDatatype((XSDDatatype)rdfDT)) continue;
                msg = String.format("Numeric facet: Not an XSD numeric: <%s> ", dtConstraint.getDatatypeURI());
                throw new ShexParseException(msg, -1, -1);
            }
        }
    }
}

