/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.validation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.common.TableViewerColumnSorter;
import org.eclipse.emf.ecp.common.commands.ECPCommand;
import org.eclipse.emf.ecp.common.model.ECPWorkspaceManager;
import org.eclipse.emf.ecp.common.model.NoWorkspaceException;
import org.eclipse.emf.ecp.common.model.workSpaceModel.ECPProject;
import org.eclipse.emf.ecp.common.model.workSpaceModel.ECPWorkspace;
import org.eclipse.emf.ecp.common.utilities.ActionHelper;
import org.eclipse.emf.ecp.validation.Activator;
import org.eclipse.emf.ecp.validation.ValidationFilterList;
import org.eclipse.emf.ecp.validation.filter.FilterTableViewer;
import org.eclipse.emf.ecp.validation.filter.ValidationFilter;
import org.eclipse.emf.ecp.validation.providers.ConstraintLabelProvider;
import org.eclipse.emf.ecp.validation.providers.SeverityLabelProvider;
import org.eclipse.emf.ecp.validation.providers.ValidationContentProvider;
import org.eclipse.emf.ecp.validation.providers.ValidationFilterLabelProvider;
import org.eclipse.emf.ecp.validation.providers.ValidationLabelProvider;
import org.eclipse.emf.ecp.validation.refactoring.strategy.RefactoringResult;
import org.eclipse.emf.ecp.validation.refactoring.strategy.RefactoringStrategy;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.part.ViewPart;

public class ValidationView
extends ViewPart {
    private TableViewer tableViewer;
    private DialogSettings settings;
    private String filename;
    private final String viewId = "org.eclipse.emf.ecp.validation.customValidationView";
    private AdapterImpl workspaceListenerAdapter;
    private Shell shell;
    private Table table;
    private ArrayList<ValidationFilter> validationFilters;
    private TableItem tableItem;
    private ECPWorkspace workspace;
    private ValidationLabelProvider labelProvider;

    public ValidationView() {
        IPath path = org.eclipse.emf.ecp.common.Activator.getDefault().getStateLocation();
        this.filename = path.append("settings.txt").toOSString();
        this.settings = new DialogSettings("Top");
        try {
            this.settings.load(this.filename);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.workspace = ECPWorkspaceManager.getInstance().getWorkSpace();
        }
        catch (NoWorkspaceException e) {
            Activator.getDefault().logException(e.getMessage(), (Exception)((Object)e));
            return;
        }
        this.workspaceListenerAdapter = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (msg.getFeatureID(ECPWorkspace.class) == 0 && msg.getOldValue() != null && (msg.getOldValue() instanceof List || msg.getOldValue() instanceof ECPProject)) {
                    ValidationView.this.tableViewer.setInput(new ArrayList());
                }
                super.notifyChanged(msg);
            }
        };
        this.workspace.eAdapters().add((Object)this.workspaceListenerAdapter);
    }

    public void createPartControl(Composite parent) {
        this.tableViewer = new FilterTableViewer(parent, 68356);
        this.createTable();
        this.shell = parent.getShell();
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager menuManager = bars.getToolBarManager();
        OpenFilterDialogAction openFilterDialogAction = new OpenFilterDialogAction();
        openFilterDialogAction.setImageDescriptor(Activator.getImageDescriptor("icons/openfilterlist.png"));
        openFilterDialogAction.setToolTipText("Add one or more filters to be applied to the validation view.");
        menuManager.add((IAction)openFilterDialogAction);
        this.hookDoubleClickAction();
        this.tableViewer.getTable().addMenuDetectListener((MenuDetectListener)new MenuDetectListenerImplementation());
    }

    private void createTable() {
        this.table = this.tableViewer.getTable();
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 5;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableViewerColumn column = new TableViewerColumn(this.tableViewer, 0x1000000, 0);
        column.getColumn().setText("Severity");
        column.getColumn().setWidth(50);
        this.setLabelProviderAndComparator(column, new SeverityLabelProvider());
        column = new TableViewerColumn(this.tableViewer, 16384, 1);
        column.getColumn().setText("Constraint");
        column.getColumn().setWidth(200);
        this.setLabelProviderAndComparator(column, new ConstraintLabelProvider());
        column = new TableViewerColumn(this.tableViewer, 16384, 2);
        column.getColumn().setText("Affected ModelElement");
        column.getColumn().setWidth(200);
        this.labelProvider = new ValidationLabelProvider();
        this.setLabelProviderAndComparator(column, this.labelProvider);
        this.tableViewer.setContentProvider((IContentProvider)new ValidationContentProvider());
        TableCursor tableCursor = new TableCursor(this.table, 0);
        tableCursor.setVisible(false);
        this.table.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.stateMask == 65536 && e.keyCode == 114) {
                    ValidationView.this.tableItem = ((Table)e.getSource()).getSelection()[0];
                    ValidationView.this.startRefactoring();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
    }

    private void setLabelProviderAndComparator(TableViewerColumn column, ColumnLabelProvider labelProvider) {
        column.setLabelProvider((CellLabelProvider)labelProvider);
        column.getViewer().setComparator((ViewerComparator)new TableViewerColumnSorter(this.tableViewer, column, labelProvider));
    }

    private void hookDoubleClickAction() {
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                IStatus constraintStatus = (IStatus)selection.getFirstElement();
                BasicDiagnostic inputElement = (BasicDiagnostic)BasicDiagnostic.toDiagnostic((IStatus)constraintStatus);
                EObject me = (EObject)inputElement.getData().get(0);
                if (me instanceof EObject) {
                    ActionHelper.openModelElement((EObject)me, (String)"org.eclipse.emf.ecp.validation.customValidationView");
                }
            }
        });
    }

    private ArrayList<RefactoringStrategy> getRefactoringStrategiesFromExtensionPoint(IStatus status) {
        IConfigurationElement[] config;
        ArrayList<RefactoringStrategy> refactoringStrategies = new ArrayList<RefactoringStrategy>();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.emf.ecp.bulidInValidation.refactoring.strategies");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                if (element.getAttribute("applicableFor").equals(status.getCode())) {
                    Object object = element.createExecutableExtension("strategy");
                    RefactoringStrategy strategy = (RefactoringStrategy)object;
                    strategy.setConstraintStatus(status);
                    refactoringStrategies.add(strategy);
                }
            }
            catch (CoreException e) {
                Activator.getDefault().logWarning("Exception loading refactoring strategies from the extension point", (Exception)((Object)e));
            }
            ++n2;
        }
        return refactoringStrategies;
    }

    public void setFocus() {
    }

    public void updateTable(Diagnostic diagnostic) {
        this.tableViewer.setInput((Object)diagnostic);
        this.tableViewer.getTable().setFocus();
    }

    private ArrayList<ValidationFilter> getFiltersFromExtensionPoint() {
        if (this.validationFilters == null) {
            IConfigurationElement[] config;
            this.validationFilters = new ArrayList();
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.emf.ecp.validation.filters");
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    ValidationFilter validationFilter;
                    Object object = element.createExecutableExtension("filter");
                    if (object instanceof ValidationFilter && (validationFilter = (ValidationFilter)((Object)object)).init()) {
                        this.validationFilters.add(validationFilter);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
        return this.validationFilters;
    }

    public void dispose() {
        this.workspace.eAdapters().remove((Object)this.workspaceListenerAdapter);
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        super.dispose();
    }

    private void startRefactoring() {
        IStatus constraintStatus = (IStatus)this.tableItem.getData();
        ArrayList<RefactoringStrategy> abstractRefactoringStrategies = this.getRefactoringStrategiesFromExtensionPoint(constraintStatus);
        if (abstractRefactoringStrategies.isEmpty()) {
            return;
        }
        RefactoringResult refactoringResult = RefactoringResult.ABORT;
        if (abstractRefactoringStrategies.size() == 1) {
            RefactoringStrategy refactoringStrategy = (RefactoringStrategy)abstractRefactoringStrategies.get(0);
            refactoringStrategy.setShell(this.shell);
            refactoringResult = refactoringStrategy.startRefactoring();
        } else {
            ListDialog listDialog = new ListDialog(this.shell);
            listDialog.setInput(abstractRefactoringStrategies);
            listDialog.setLabelProvider((ILabelProvider)new RefactoringStrategyLabelProvider());
            listDialog.setContentProvider((IStructuredContentProvider)new SimpleContentProvider());
            listDialog.setTitle("Choose a refactoring strategy");
            listDialog.open();
            Object[] result = listDialog.getResult();
            if (result != null && result.length > 0) {
                RefactoringStrategy refactoringStrategy = (RefactoringStrategy)result[0];
                refactoringStrategy.setShell(this.shell);
                refactoringResult = refactoringStrategy.startRefactoring();
            }
        }
        if (refactoringResult == RefactoringResult.NO_VIOLATION || refactoringResult == RefactoringResult.SUCCESS_CREATE) {
            this.tableItem.dispose();
        }
    }

    private void removeAllTableItemsForEObject(IStatus status) {
        BasicDiagnostic inputElement1 = (BasicDiagnostic)BasicDiagnostic.toDiagnostic((IStatus)status);
        EObject deletee = (EObject)inputElement1.getData().get(0);
        TableItem[] tableItemArray = this.tableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            IStatus constraintStatus = (IStatus)tableItem.getData();
            BasicDiagnostic inputElement2 = (BasicDiagnostic)BasicDiagnostic.toDiagnostic((IStatus)constraintStatus);
            EObject modelElement = (EObject)inputElement2.getData().get(0);
            if (deletee == modelElement) {
                tableItem.dispose();
            }
            ++n2;
        }
    }

    private final class MenuDetectListenerImplementation
    implements MenuDetectListener {
        private MenuDetectListenerImplementation() {
        }

        public void menuDetected(MenuDetectEvent e) {
            Table table = (Table)e.getSource();
            if (table.getSelection() == null || table.getSelection().length == 0) {
                return;
            }
            ValidationView.this.tableItem = table.getSelection()[0];
            final IStatus status = (IStatus)ValidationView.this.tableItem.getData();
            Menu leftClickMenu = new Menu((Decorations)ValidationView.this.shell, 8);
            ArrayList refactoringStrategies = ValidationView.this.getRefactoringStrategiesFromExtensionPoint(status);
            if (refactoringStrategies.size() != 0) {
                MenuItem refactorMenuItem = new MenuItem(leftClickMenu, 0);
                refactorMenuItem.setData((Object)ValidationView.this.tableItem);
                refactorMenuItem.setText("Perform refactoring");
                refactorMenuItem.setImage(Activator.getImageDescriptor("icons/bell.png").createImage());
                refactorMenuItem.addSelectionListener((SelectionListener)new RefactoringSelectionListener());
            }
            MenuItem deleteMenuItem = new MenuItem(leftClickMenu, 0);
            deleteMenuItem.setData((Object)refactoringStrategies);
            deleteMenuItem.setText("Delete underlying element");
            deleteMenuItem.setImage(Activator.getImageDescriptor("icons/delete.png").createImage());
            deleteMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BasicDiagnostic inputElement = (BasicDiagnostic)BasicDiagnostic.toDiagnostic((IStatus)status);
                    EObject target = (EObject)inputElement.getData().get(0);
                    if (MessageDialog.openQuestion((Shell)ValidationView.this.shell, (String)"Confirm deletion", (String)("Do you really wish to delete " + target.getClass().getSimpleName() + "?"))) {
                        new ECPCommand(target){

                            protected void doRun() {
                                BasicDiagnostic inputElement = (BasicDiagnostic)BasicDiagnostic.toDiagnostic((IStatus)status);
                                EObject target = (EObject)inputElement.getData().get(0);
                                EcoreUtil.delete((EObject)target);
                            }
                        }.run(false);
                    }
                    ValidationView.this.removeAllTableItemsForEObject(status);
                }
            });
            leftClickMenu.setVisible(true);
        }

        private final class RefactoringSelectionListener
        implements SelectionListener {
            private RefactoringSelectionListener() {
            }

            public void widgetSelected(SelectionEvent e) {
                ValidationView.this.startRefactoring();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        }
    }

    private final class OpenFilterDialogAction
    extends Action {
        private OpenFilterDialogAction() {
        }

        public void run() {
            ValidationFilterList validationFilterList = new ValidationFilterList(ValidationView.this.shell, ValidationView.this.getFiltersFromExtensionPoint(), new SimpleContentProvider(), (ILabelProvider)new ValidationFilterLabelProvider(), "Test");
            validationFilterList.setTitle("Choose one or more filters");
            validationFilterList.setInitialSelections(ValidationView.this.tableViewer.getFilters());
            validationFilterList.open();
            if (validationFilterList.getReturnCode() == 0) {
                this.removeAllFilters();
                Object[] objectArray = validationFilterList.getResult();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof ValidationFilter) {
                        ValidationFilter validationFilter = (ValidationFilter)((Object)object);
                        this.applyFilter(validationFilter);
                    }
                    ++n2;
                }
            }
        }

        private void applyFilter(ValidationFilter validationFilter) {
            ValidationView.this.tableViewer.addFilter((ViewerFilter)validationFilter);
        }

        private void removeAllFilters() {
            ValidationView.this.tableViewer.resetFilters();
        }
    }

    private final class RefactoringStrategyLabelProvider
    extends LabelProvider {
        private RefactoringStrategyLabelProvider() {
        }

        public Image getImage(Object element) {
            return Activator.getImageDescriptor("icons/bell.png").createImage();
        }

        public String getText(Object element) {
            return ((RefactoringStrategy)((Object[])element)[0]).getDescription();
        }
    }

    private final class SimpleContentProvider
    implements IStructuredContentProvider {
        private SimpleContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            List list = (List)inputElement;
            if (list.isEmpty()) {
                return new Object[0];
            }
            return list.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

