/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.conflictDetection;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.emfstore.common.model.ModelElementId;
import org.eclipse.emf.emfstore.server.conflictDetection.ConflictDetectionStrategy;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AttributeOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.CompositeOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.ContainmentType;
import org.eclipse.emf.emfstore.server.model.versioning.operations.CreateDeleteOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.FeatureOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.MultiAttributeMoveOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.MultiAttributeOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.MultiAttributeSetOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.MultiReferenceMoveOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.MultiReferenceOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.MultiReferenceSetOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.ReferenceOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.SingleReferenceOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.util.OperationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexSensitiveConflictDetectionStrategy
implements ConflictDetectionStrategy {
    @Override
    public boolean doConflict(AbstractOperation operationA, AbstractOperation operationB) {
        if (operationA instanceof CompositeOperation) {
            CompositeOperation compA = (CompositeOperation)operationA;
            for (AbstractOperation op : compA.getSubOperations()) {
                if (!this.doConflict(op, operationB)) continue;
                return true;
            }
            return false;
        }
        if (operationB instanceof CompositeOperation) {
            CompositeOperation compB = (CompositeOperation)operationB;
            for (AbstractOperation op : compB.getSubOperations()) {
                if (!this.doConflict(operationA, op)) continue;
                return true;
            }
            return false;
        }
        return this.doConflictHard(operationA, operationB);
    }

    private boolean doConflictHard(AbstractOperation operationA, AbstractOperation operationB) {
        if (OperationUtil.isCreateDelete((AbstractOperation)operationA)) {
            return this.doConflictHardCreateDelete((CreateDeleteOperation)operationA, operationB);
        }
        if (OperationUtil.isCreateDelete((AbstractOperation)operationB)) {
            return this.doConflictHardCreateDelete((CreateDeleteOperation)operationB, operationA);
        }
        if (OperationUtil.isAttribute((AbstractOperation)operationA) && OperationUtil.isAttribute((AbstractOperation)operationB)) {
            return this.doConflictHardAttributes((AttributeOperation)operationA, (AttributeOperation)operationB);
        }
        if (OperationUtil.isMultiAtt((AbstractOperation)operationA) && OperationUtil.isMultiAtt((AbstractOperation)operationB)) {
            return this.doConflictHardMultiAttributes((MultiAttributeOperation)operationA, (MultiAttributeOperation)operationB);
        }
        if (OperationUtil.isMultiAttSet((AbstractOperation)operationA) && OperationUtil.isMultiAttSet((AbstractOperation)operationB)) {
            return this.doConflictHardMultiAttributeSets((MultiAttributeSetOperation)operationA, (MultiAttributeSetOperation)operationB);
        }
        if (OperationUtil.isMultiAttSet((AbstractOperation)operationA) && OperationUtil.isMultiAtt((AbstractOperation)operationB)) {
            return this.doConflictHardMultiAttAndSet((MultiAttributeOperation)operationB, (MultiAttributeSetOperation)operationA);
        }
        if (OperationUtil.isMultiAtt((AbstractOperation)operationA) && OperationUtil.isMultiAttSet((AbstractOperation)operationB)) {
            return this.doConflictHardMultiAttAndSet((MultiAttributeOperation)operationA, (MultiAttributeSetOperation)operationB);
        }
        if (OperationUtil.isMultiAttMove((AbstractOperation)operationA) && OperationUtil.isMultiAttMove((AbstractOperation)operationB)) {
            return this.doConflictHardMultiAttributeMoves((MultiAttributeMoveOperation)operationA, (MultiAttributeMoveOperation)operationB);
        }
        if (OperationUtil.isMultiAttMove((AbstractOperation)operationA) && OperationUtil.isMultiAtt((AbstractOperation)operationB)) {
            return this.doConflictHardMultiAttAndMove((MultiAttributeMoveOperation)operationA, (MultiAttributeOperation)operationB);
        }
        if (OperationUtil.isMultiAtt((AbstractOperation)operationA) && OperationUtil.isMultiAttMove((AbstractOperation)operationB)) {
            return this.doConflictHardMultiAttAndMove((MultiAttributeMoveOperation)operationB, (MultiAttributeOperation)operationA);
        }
        if (OperationUtil.isMultiAttSet((AbstractOperation)operationA) && OperationUtil.isMultiAttMove((AbstractOperation)operationB)) {
            return this.doConflictHardMultiAttMoveAndSet((MultiAttributeMoveOperation)operationB, (MultiAttributeSetOperation)operationA);
        }
        if (OperationUtil.isMultiAttMove((AbstractOperation)operationA) && OperationUtil.isMultiAttSet((AbstractOperation)operationB)) {
            return this.doConflictHardMultiAttMoveAndSet((MultiAttributeMoveOperation)operationA, (MultiAttributeSetOperation)operationB);
        }
        if (OperationUtil.isSingleRef((AbstractOperation)operationA) && OperationUtil.isSingleRef((AbstractOperation)operationB)) {
            return this.doConflictHardSingleReferences((SingleReferenceOperation)operationA, (SingleReferenceOperation)operationB);
        }
        if (OperationUtil.isSingleRef((AbstractOperation)operationA) && OperationUtil.isMultiRef((AbstractOperation)operationB)) {
            return this.doConflictHardSingleMultiReferences((SingleReferenceOperation)operationA, (MultiReferenceOperation)operationB);
        }
        if (OperationUtil.isMultiRef((AbstractOperation)operationA) && OperationUtil.isSingleRef((AbstractOperation)operationB)) {
            return this.doConflictHardSingleMultiReferences((SingleReferenceOperation)operationB, (MultiReferenceOperation)operationA);
        }
        if (OperationUtil.isSingleRef((AbstractOperation)operationA) && OperationUtil.isMultiRefSet((AbstractOperation)operationB)) {
            return this.doConflictHardSingeMultiSet((SingleReferenceOperation)operationA, (MultiReferenceSetOperation)operationB);
        }
        if (OperationUtil.isMultiRefSet((AbstractOperation)operationA) && OperationUtil.isSingleRef((AbstractOperation)operationB)) {
            return this.doConflictHardSingeMultiSet((SingleReferenceOperation)operationB, (MultiReferenceSetOperation)operationA);
        }
        if (OperationUtil.isMultiRef((AbstractOperation)operationA) && OperationUtil.isMultiRefSet((AbstractOperation)operationB)) {
            return this.doConflictHardMultiReferenceAndSet((MultiReferenceOperation)operationA, (MultiReferenceSetOperation)operationB);
        }
        if (OperationUtil.isMultiRefSet((AbstractOperation)operationA) && OperationUtil.isMultiRef((AbstractOperation)operationB)) {
            return this.doConflictHardMultiReferenceAndSet((MultiReferenceOperation)operationB, (MultiReferenceSetOperation)operationA);
        }
        if (OperationUtil.isMultiRefSet((AbstractOperation)operationA) && OperationUtil.isMultiRefSet((AbstractOperation)operationB)) {
            return this.doConflictHardMultiReferenceSet((MultiReferenceSetOperation)operationA, (MultiReferenceSetOperation)operationB);
        }
        if (OperationUtil.isMultiRef((AbstractOperation)operationA) && OperationUtil.isMultiRef((AbstractOperation)operationB)) {
            return this.doConflictHardMultiReferences((MultiReferenceOperation)operationA, (MultiReferenceOperation)operationB);
        }
        return false;
    }

    private boolean doConflictHardSingeMultiSet(SingleReferenceOperation opA, MultiReferenceSetOperation opB) {
        if (!this.bothContaining((ReferenceOperation)opA, (ReferenceOperation)opB)) {
            return false;
        }
        return opA.getNewValue() != null && IndexSensitiveConflictDetectionStrategy.isSame(opA.getNewValue(), opB.getNewValue());
    }

    private boolean doConflictHardMultiAttributeMoves(MultiAttributeMoveOperation operationA, MultiAttributeMoveOperation operationB) {
        return false;
    }

    private boolean doConflictHardMultiAttributeSets(MultiAttributeSetOperation operationA, MultiAttributeSetOperation operationB) {
        if (!this.sameFeatureAndId((FeatureOperation)operationA, (FeatureOperation)operationB)) {
            return false;
        }
        return operationA.getIndex() == operationB.getIndex() && IndexSensitiveConflictDetectionStrategy.isDifferent(operationA.getNewValue(), operationB.getNewValue());
    }

    private boolean doConflictHardMultiReferenceSet(MultiReferenceSetOperation operationA, MultiReferenceSetOperation operationB) {
        if (this.sameFeatureAndId((FeatureOperation)operationA, (FeatureOperation)operationB)) {
            return operationA.getIndex() == operationB.getIndex() && IndexSensitiveConflictDetectionStrategy.isDifferent(operationA.getNewValue(), operationB.getNewValue());
        }
        if (!this.bothContaining((ReferenceOperation)operationA, (ReferenceOperation)operationB)) {
            return false;
        }
        return IndexSensitiveConflictDetectionStrategy.isSame(operationA.getNewValue(), operationB.getNewValue());
    }

    private boolean doConflictHardMultiReferenceAndSet(MultiReferenceOperation operationA, MultiReferenceSetOperation operationB) {
        if (this.sameFeatureAndId((FeatureOperation)operationA, (FeatureOperation)operationB)) {
            if (!operationA.isAdd()) {
                for (ModelElementId id : operationA.getReferencedModelElements()) {
                    if (!id.equals(operationB.getOldValue())) continue;
                    return true;
                }
            }
        } else {
            if (!this.bothContaining((ReferenceOperation)operationA, (ReferenceOperation)operationB)) {
                return false;
            }
            if (!operationA.isAdd()) {
                return false;
            }
            return this.containsId((Iterable<ModelElementId>)operationA.getReferencedModelElements(), operationB.getNewValue());
        }
        return false;
    }

    private boolean doConflictHardMultiAttAndMove(MultiAttributeMoveOperation operationB, MultiAttributeOperation operationA) {
        if (!this.sameFeatureAndId((FeatureOperation)operationA, (FeatureOperation)operationB)) {
            return false;
        }
        int index = this.getLowestIndex((EList<Integer>)operationA.getIndexes());
        if (index == -1) {
            return false;
        }
        return index <= operationB.getOldIndex() || index <= operationB.getNewIndex();
    }

    private boolean doConflictHardMultiAttMoveAndSet(MultiAttributeMoveOperation operationA, MultiAttributeSetOperation operationB) {
        if (!this.sameFeatureAndId((FeatureOperation)operationA, (FeatureOperation)operationB)) {
            return false;
        }
        return this.between(operationB.getIndex(), operationA.getOldIndex(), operationA.getNewIndex());
    }

    private boolean doConflictHardMultiAttAndSet(MultiAttributeOperation operationB, MultiAttributeSetOperation operationA) {
        if (!this.sameFeatureAndId((FeatureOperation)operationA, (FeatureOperation)operationB)) {
            return false;
        }
        int index = this.getLowestIndex((EList<Integer>)operationB.getIndexes());
        if (index == -1) {
            return false;
        }
        return index <= operationA.getIndex();
    }

    private boolean doConflictHardMultiAttributes(MultiAttributeOperation operationA, MultiAttributeOperation operationB) {
        return this.sameFeatureAndId((FeatureOperation)operationA, (FeatureOperation)operationB);
    }

    private boolean doConflictHardCreateDelete(CreateDeleteOperation opA, AbstractOperation opB) {
        if (IndexSensitiveConflictDetectionStrategy.isCreateOperation((AbstractOperation)opA)) {
            return false;
        }
        if (IndexSensitiveConflictDetectionStrategy.isCreateOperation(opB)) {
            return false;
        }
        if (opB instanceof CreateDeleteOperation) {
            Set<ModelElementId> allDeletedElementsB;
            Set<ModelElementId> allDeletedElementsA = this.getAllDeletedElements(opA);
            boolean intersecting = allDeletedElementsA.removeAll(allDeletedElementsB = this.getAllDeletedElements((CreateDeleteOperation)opB));
            return intersecting && !allDeletedElementsA.isEmpty();
        }
        for (ModelElementId m : this.getAllDeletedElements(opA)) {
            if (!IndexSensitiveConflictDetectionStrategy.changesModelElement(opB, m)) continue;
            return true;
        }
        for (ReferenceOperation referenceOperation : opA.getSubOperations()) {
            if (!this.doConflictHard((AbstractOperation)referenceOperation, opB)) continue;
            return true;
        }
        return false;
    }

    private Set<ModelElementId> getAllDeletedElements(CreateDeleteOperation op) {
        return new HashSet<ModelElementId>(op.getEObjectToIdMap().values());
    }

    private boolean doConflictHardMultiReferences(MultiReferenceOperation opA, MultiReferenceOperation opB) {
        if (this.sameFeatureAndId((FeatureOperation)opA, (FeatureOperation)opB)) {
            if (opA.isAdd() != opB.isAdd()) {
                for (ModelElementId mA : opA.getOtherInvolvedModelElements()) {
                    for (ModelElementId mB : opB.getOtherInvolvedModelElements()) {
                        if (!mA.equals(mB)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        if (!this.bothContaining((ReferenceOperation)opA, (ReferenceOperation)opB)) {
            return false;
        }
        if (opA.isAdd() != opB.isAdd()) {
            return false;
        }
        for (ModelElementId mA : opA.getOtherInvolvedModelElements()) {
            for (ModelElementId mB : opB.getOtherInvolvedModelElements()) {
                if (!mA.equals(mB)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean doConflictHardSingleMultiReferences(SingleReferenceOperation opA, MultiReferenceOperation opB) {
        if (!this.bothContaining((ReferenceOperation)opA, (ReferenceOperation)opB)) {
            return false;
        }
        if (!opB.isAdd()) {
            return false;
        }
        for (ModelElementId id : opB.getOtherInvolvedModelElements()) {
            if (!id.equals(opA.getNewValue())) continue;
            return true;
        }
        return false;
    }

    private boolean doConflictHardSingleReferences(SingleReferenceOperation opA, SingleReferenceOperation opB) {
        if (this.sameFeatureAndId((FeatureOperation)opA, (FeatureOperation)opB)) {
            return IndexSensitiveConflictDetectionStrategy.isDifferent(opA.getNewValue(), opB.getNewValue());
        }
        if (!this.bothContaining((ReferenceOperation)opA, (ReferenceOperation)opB)) {
            return false;
        }
        return opA.getNewValue() != null && IndexSensitiveConflictDetectionStrategy.isSame(opA.getNewValue(), opB.getNewValue());
    }

    private boolean doConflictHardAttributes(AttributeOperation opA, AttributeOperation opB) {
        if (this.sameFeatureAndId((FeatureOperation)opA, (FeatureOperation)opB)) {
            return !IndexSensitiveConflictDetectionStrategy.isSame(opA.getNewValue(), opB.getNewValue());
        }
        return false;
    }

    public boolean doConflictIndexIntegrity(AbstractOperation operationA, AbstractOperation operationB) {
        if (operationA instanceof CompositeOperation) {
            CompositeOperation compA = (CompositeOperation)operationA;
            for (AbstractOperation op : compA.getSubOperations()) {
                if (!this.doConflictIndexIntegrity(op, operationB)) continue;
                return true;
            }
            return false;
        }
        if (operationB instanceof CompositeOperation) {
            CompositeOperation compB = (CompositeOperation)operationB;
            for (AbstractOperation op : compB.getSubOperations()) {
                if (!this.doConflictIndexIntegrity(operationA, op)) continue;
                return true;
            }
            return false;
        }
        if (operationA instanceof MultiReferenceOperation && operationB instanceof MultiReferenceOperation) {
            return this.doConflictIndexIntegrityMultiReferences((MultiReferenceOperation)operationA, (MultiReferenceOperation)operationB);
        }
        if (operationA instanceof SingleReferenceOperation && operationB instanceof MultiReferenceOperation) {
            return this.doConflictIndexIntegritySingleMultiReferences((SingleReferenceOperation)operationA, (MultiReferenceOperation)operationB);
        }
        if (operationB instanceof SingleReferenceOperation && operationA instanceof MultiReferenceOperation) {
            return this.doConflictIndexIntegritySingleMultiReferences((SingleReferenceOperation)operationB, (MultiReferenceOperation)operationA);
        }
        if (operationA instanceof MultiReferenceMoveOperation && operationB instanceof MultiReferenceMoveOperation) {
            return this.doConflictIndexIntegrityMultiMoveReferences((MultiReferenceMoveOperation)operationA, (MultiReferenceMoveOperation)operationB);
        }
        if (operationA instanceof MultiReferenceMoveOperation && operationB instanceof MultiReferenceOperation) {
            return this.doConflictIndexIntegrityMultiMoveMultiReferences((MultiReferenceMoveOperation)operationA, (MultiReferenceOperation)operationB);
        }
        if (operationB instanceof MultiReferenceMoveOperation && operationA instanceof MultiReferenceOperation) {
            return this.doConflictIndexIntegrityMultiMoveMultiReferences((MultiReferenceMoveOperation)operationB, (MultiReferenceOperation)operationA);
        }
        if (operationA instanceof MultiReferenceMoveOperation && operationB instanceof SingleReferenceOperation) {
            return this.doConflictIndexIntegrityMultiMoveSingleReferences((MultiReferenceMoveOperation)operationA, (SingleReferenceOperation)operationB);
        }
        if (operationB instanceof MultiReferenceMoveOperation && operationA instanceof SingleReferenceOperation) {
            return this.doConflictIndexIntegrityMultiMoveSingleReferences((MultiReferenceMoveOperation)operationB, (SingleReferenceOperation)operationA);
        }
        if (operationA instanceof SingleReferenceOperation && operationB instanceof SingleReferenceOperation) {
            return this.doConflictIndexIntegritySingleReferences((SingleReferenceOperation)operationA, (SingleReferenceOperation)operationB);
        }
        return false;
    }

    private boolean doConflictIndexIntegritySingleReferences(SingleReferenceOperation opA, SingleReferenceOperation opB) {
        return false;
    }

    private boolean doConflictIndexIntegrityMultiMoveSingleReferences(MultiReferenceMoveOperation opA, SingleReferenceOperation opB) {
        return false;
    }

    private boolean doConflictIndexIntegrityMultiMoveMultiReferences(MultiReferenceMoveOperation opA, MultiReferenceOperation opB) {
        if (opA.getModelElementId().equals(opB.getModelElementId()) && opA.getFeatureName().equals(opB.getFeatureName())) {
            if (this.containsId((Iterable<ModelElementId>)opB.getReferencedModelElements(), opA.getReferencedModelElementId())) {
                return opB.isAdd();
            }
            if (opB.isAdd() && opB.getIndex() >= opA.getNewIndex()) {
                return true;
            }
            return !opB.isAdd() && opB.getIndex() + opB.getReferencedModelElements().size() - 1 < opA.getNewIndex();
        }
        return false;
    }

    private boolean doConflictIndexIntegrityMultiMoveReferences(MultiReferenceMoveOperation opA, MultiReferenceMoveOperation opB) {
        if (opA.getModelElementId().equals(opB.getModelElementId()) && opA.getFeatureName().equals(opB.getFeatureName())) {
            if (opA.getReferencedModelElementId().equals(opB.getReferencedModelElementId())) {
                return opA.getNewIndex() != opB.getNewIndex();
            }
            return opA.getNewIndex() == opB.getNewIndex();
        }
        return false;
    }

    private boolean doConflictIndexIntegritySingleMultiReferences(SingleReferenceOperation opA, MultiReferenceOperation opB) {
        return false;
    }

    private boolean doConflictIndexIntegrityMultiReferences(MultiReferenceOperation opA, MultiReferenceOperation opB) {
        if (opA.getModelElementId().equals(opB.getModelElementId()) && opA.getFeatureName().equals(opB.getFeatureName())) {
            if (opA.isAdd() && opB.isAdd()) {
                if (opA.getIndex() == opB.getIndex()) {
                    for (ModelElementId mA : opA.getOtherInvolvedModelElements()) {
                        if (this.containsId(opB.getOtherInvolvedModelElements(), mA)) continue;
                        return true;
                    }
                    for (ModelElementId mB : opB.getOtherInvolvedModelElements()) {
                        if (this.containsId(opA.getOtherInvolvedModelElements(), mB)) continue;
                        return true;
                    }
                } else {
                    return true;
                }
            }
            if (opA.isAdd() != opB.isAdd()) {
                for (ModelElementId mA : opA.getOtherInvolvedModelElements()) {
                    if (this.containsId(opB.getOtherInvolvedModelElements(), mA)) continue;
                    if (opB.getReferencedModelElements().size() == 1 && opA.getReferencedModelElements().size() == 1) {
                        if (opA.isAdd()) {
                            return opA.getIndex() > opB.getIndex() && opA.getIndex() != 0 && opB.getIndex() != 0;
                        }
                        return opA.getIndex() < opB.getIndex() && opA.getIndex() != 0 && opB.getIndex() != 0;
                    }
                    return true;
                }
                for (ModelElementId mB : opB.getOtherInvolvedModelElements()) {
                    if (this.containsId(opA.getOtherInvolvedModelElements(), mB)) continue;
                    if (opB.getReferencedModelElements().size() == 1 && opA.getReferencedModelElements().size() == 1) {
                        if (opA.isAdd()) {
                            return opA.getIndex() > opB.getIndex() && opA.getIndex() != 0 && opB.getIndex() != 0;
                        }
                        return opA.getIndex() < opB.getIndex() && opA.getIndex() != 0 && opB.getIndex() != 0;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isRequired(AbstractOperation requiredOperation, AbstractOperation operation) {
        if (requiredOperation instanceof CompositeOperation) {
            CompositeOperation compA = (CompositeOperation)requiredOperation;
            for (AbstractOperation op : compA.getSubOperations()) {
                if (!this.isRequired(op, operation)) continue;
                return true;
            }
            return false;
        }
        if (operation instanceof CompositeOperation) {
            CompositeOperation compB = (CompositeOperation)operation;
            for (AbstractOperation op : compB.getSubOperations()) {
                if (!this.isRequired(requiredOperation, op)) continue;
                return true;
            }
            return false;
        }
        if (requiredOperation instanceof CreateDeleteOperation) {
            return this.isRequiredCreate((CreateDeleteOperation)requiredOperation, operation);
        }
        if (requiredOperation instanceof MultiReferenceOperation && operation instanceof MultiReferenceMoveOperation) {
            return this.isRequiredMultiByMoveReference((MultiReferenceOperation)requiredOperation, (MultiReferenceMoveOperation)operation);
        }
        if (requiredOperation instanceof MultiReferenceOperation && operation instanceof MultiReferenceOperation) {
            return this.isRequiredMutiByMultiReference((MultiReferenceOperation)requiredOperation, (MultiReferenceOperation)operation);
        }
        if (requiredOperation instanceof SingleReferenceOperation && operation instanceof MultiReferenceMoveOperation) {
            return this.isRequiredSingleByMoveReference((SingleReferenceOperation)requiredOperation, (MultiReferenceMoveOperation)operation);
        }
        if (requiredOperation instanceof SingleReferenceOperation && operation instanceof MultiReferenceOperation) {
            return this.isRequiredSingleByMultiReference((SingleReferenceOperation)requiredOperation, (MultiReferenceOperation)operation);
        }
        return false;
    }

    private boolean isRequiredSingleByMultiReference(SingleReferenceOperation requiredOperation, MultiReferenceOperation operation) {
        return false;
    }

    private boolean isRequiredSingleByMoveReference(SingleReferenceOperation requiredOperation, MultiReferenceMoveOperation operation) {
        if (!requiredOperation.isBidirectional()) {
            return false;
        }
        boolean sameFeature = requiredOperation.getOppositeFeatureName().equals(operation.getFeatureName());
        boolean sameMovedElement = requiredOperation.getModelElementId().equals(operation.getReferencedModelElementId());
        boolean sameElement = IndexSensitiveConflictDetectionStrategy.isSame(requiredOperation.getNewValue(), operation.getModelElementId());
        return sameElement && sameFeature && sameMovedElement;
    }

    private boolean isRequiredMutiByMultiReference(MultiReferenceOperation requiredOperation, MultiReferenceOperation operation) {
        return false;
    }

    private boolean isRequiredMultiByMoveReference(MultiReferenceOperation requiredOperation, MultiReferenceMoveOperation operation) {
        boolean sameElement = requiredOperation.getModelElementId().equals(operation.getModelElementId());
        boolean sameFeature = requiredOperation.getFeatureName().equals(operation.getFeatureName());
        if (sameElement && sameFeature) {
            for (ModelElementId modelElementId : requiredOperation.getReferencedModelElements()) {
                if (!modelElementId.equals(operation.getReferencedModelElementId())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRequiredCreate(CreateDeleteOperation requiredOperation, AbstractOperation operation) {
        if (!requiredOperation.isDelete()) {
            SingleReferenceOperation op;
            if (operation instanceof CreateDeleteOperation) {
                CreateDeleteOperation op2 = (CreateDeleteOperation)operation;
                return op2.isDelete() && op2.getModelElementId().equals(requiredOperation.getModelElementId());
            }
            if (operation instanceof SingleReferenceOperation && IndexSensitiveConflictDetectionStrategy.isSame((op = (SingleReferenceOperation)operation).getOldValue(), requiredOperation.getModelElementId())) {
                return false;
            }
            if (IndexSensitiveConflictDetectionStrategy.changesModelElement(operation, requiredOperation.getModelElementId())) {
                return true;
            }
        }
        return false;
    }

    private static boolean isDifferent(Object a, Object b) {
        if (a == null && b == null) {
            return false;
        }
        if (a == null || b == null) {
            return true;
        }
        return !a.equals(b);
    }

    private static boolean isSame(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    private boolean bothContaining(ReferenceOperation opA, ReferenceOperation opB) {
        return ContainmentType.CONTAINMENT.equals((Object)opA.getContainmentType()) && ContainmentType.CONTAINMENT.equals((Object)opB.getContainmentType());
    }

    private boolean sameFeatureAndId(FeatureOperation operationA, FeatureOperation operationB) {
        return IndexSensitiveConflictDetectionStrategy.isSame(operationA.getModelElementId(), operationB.getModelElementId()) && IndexSensitiveConflictDetectionStrategy.isSame(operationA.getFeatureName(), operationB.getFeatureName());
    }

    private boolean between(int index, int lower, int upper) {
        if (lower > upper) {
            return this.between(index, upper, lower);
        }
        return lower <= index && index <= upper;
    }

    private int getLowestIndex(EList<Integer> indexes) {
        int result = -1;
        for (Integer tmp : indexes) {
            if (result < tmp && result != -1) continue;
            result = tmp;
        }
        return result;
    }

    private static boolean isCreateOperation(AbstractOperation op) {
        if (op instanceof CreateDeleteOperation) {
            CreateDeleteOperation cdop = (CreateDeleteOperation)op;
            return !cdop.isDelete();
        }
        return false;
    }

    private boolean containsId(Iterable<ModelElementId> list, ModelElementId id) {
        for (ModelElementId m : list) {
            if (!m.equals(id)) continue;
            return true;
        }
        return false;
    }

    public static boolean changesModelElement(AbstractOperation op, ModelElementId id) {
        for (ModelElementId m : op.getAllInvolvedModelElements()) {
            if (!m.equals(id)) continue;
            return true;
        }
        return false;
    }
}

