/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.conflicts;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.DecisionManager;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.Conflict;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.ConflictDescription;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.ConflictOption;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.util.DecisionUtil;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.MultiReferenceSetOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiReferenceSetSetConflict
extends Conflict {
    private boolean containmentConflict = this.getMyOperation().getModelElementId().equals(this.getTheirOperation().getModelElementId());

    public MultiReferenceSetSetConflict(List<AbstractOperation> opsA, List<AbstractOperation> opsB, DecisionManager decisionManager) {
        super(opsA, opsB, decisionManager, true, false);
        this.init();
    }

    @Override
    protected ConflictDescription initConflictDescription(ConflictDescription description) {
        String txt = "";
        txt = !this.containmentConflict ? "You have set the value [value] to the [feature] reference of [modelelement], it was set to [ovalue] on the repository" : "You have moved the element [value] to [modelelement], it was moved to [othercontainer] on the repository.";
        description.add("value", this.getMyOperation(MultiReferenceSetOperation.class).getNewValue());
        description.add("ovalue", this.getTheirOperation(MultiReferenceSetOperation.class).getNewValue());
        description.add("othercontainer", this.getTheirOperation().getModelElementId());
        description.setDescription(txt);
        description.setImage("multiref.gif");
        return description;
    }

    @Override
    protected void initConflictOptions(List<ConflictOption> options) {
        ConflictOption myOption = new ConflictOption("", ConflictOption.OptionType.MyOperation);
        myOption.addOperations(this.getMyOperations());
        ConflictOption theirOption = new ConflictOption("", ConflictOption.OptionType.TheirOperation);
        theirOption.addOperations(this.getTheirOperations());
        if (!this.containmentConflict) {
            myOption.setOptionLabel(DecisionUtil.getClassAndName(this.getDecisionManager().getModelElement(this.getMyOperation(MultiReferenceSetOperation.class).getNewValue())));
            theirOption.setOptionLabel(DecisionUtil.getClassAndName(this.getDecisionManager().getModelElement(this.getTheirOperation(MultiReferenceSetOperation.class).getNewValue())));
        } else {
            EObject target = this.getDecisionManager().getModelElement(this.getMyOperation(MultiReferenceSetOperation.class).getNewValue());
            myOption.setOptionLabel("Move " + DecisionUtil.getClassAndName(target) + "to" + DecisionUtil.getClassAndName(this.getDecisionManager().getModelElement(this.getMyOperation().getModelElementId())));
            theirOption.setOptionLabel("Move " + DecisionUtil.getClassAndName(target) + " to" + DecisionUtil.getClassAndName(this.getDecisionManager().getModelElement(this.getTheirOperation().getModelElementId())));
        }
        options.add(myOption);
        options.add(theirOption);
    }
}

