/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.controller;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.client.ui.handlers.AbstractEMFStoreUIController;
import org.eclipse.emf.emfstore.client.ui.views.historybrowserview.HistoryBrowserView;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.emf.emfstore.server.model.versioning.HistoryInfo;
import org.eclipse.emf.emfstore.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.TagVersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.VersioningFactory;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class UITagController
extends AbstractEMFStoreUIController {
    public UITagController(Shell shell) {
        super(shell);
    }

    public void addTag(ProjectSpace projectSpace, HistoryInfo historyInfo) throws EmfStoreException {
        PrimaryVersionSpec versionSpec = (PrimaryVersionSpec)ModelUtil.clone((EObject)historyInfo.getPrimerySpec());
        InputDialog inputDialog = new InputDialog(this.getShell(), "Add tag", "Please enter the tag's name.", "", null);
        inputDialog.open();
        String str = inputDialog.getValue().trim();
        if (str != null && str.length() > 0) {
            TagVersionSpec tag = VersioningFactory.eINSTANCE.createTagVersionSpec();
            tag.setName(str);
            projectSpace.addTag(versionSpec, tag);
        }
    }

    public void removeTag(HistoryInfo historyInfo) throws EmfStoreException {
        Object[] tags;
        LabelProvider tagLabelProvider = new LabelProvider(){

            public String getText(Object element) {
                return ((TagVersionSpec)element).getName();
            }
        };
        ElementListSelectionDialog dlg = new ElementListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)tagLabelProvider);
        dlg.setElements(historyInfo.getTagSpecs().toArray());
        dlg.setTitle("Tag selection");
        dlg.setBlockOnOpen(true);
        dlg.setMultipleSelection(true);
        int ret = dlg.open();
        if (ret != 0) {
            return;
        }
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null || !(activePage.getActivePart() instanceof HistoryBrowserView)) {
            return;
        }
        HistoryBrowserView historyBrowserView = (HistoryBrowserView)activePage.getActivePart();
        Object[] objectArray = tags = dlg.getResult();
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            Object tag = objectArray[n2];
            historyBrowserView.getProjectSpace().removeTag(historyInfo.getPrimerySpec(), (TagVersionSpec)tag);
            ++n2;
        }
        historyBrowserView.refresh();
    }
}

