/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.views;

import java.security.cert.X509Certificate;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.emfstore.client.exceptions.ESCertificateException;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.KeyStoreManager;
import org.eclipse.emf.emfstore.internal.client.ui.util.FileDialogHelper;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.views.ElementListSelectionDialog;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.views.Messages;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class CertificateSelectionDialog
extends ElementListSelectionDialog {
    public static final long serialVersionUID = 1L;
    private TableItem selectedTableItem;
    private String alias = "";

    public CertificateSelectionDialog(Shell parent, ILabelProvider renderer) {
        super(parent, renderer);
        this.setShellStyle(1248);
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        Composite grid = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(grid);
        Composite left = new Composite(grid, 0);
        GridLayoutFactory.fillDefaults().applyTo(left);
        Composite right = new Composite(grid, 0);
        GridLayoutFactory.createFrom((GridLayout)layout).margins(layout.marginWidth, 35).applyTo(right);
        GridDataFactory.fillDefaults().grab(true, true).hint(300, 200).applyTo((Control)right);
        CertificateSelectionDialog.applyDialogFont((Control)right);
        new Label(right, 0).setText(Messages.CertificateSelectionDialog_Alias);
        Text certAlias = new Text(right, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)certAlias);
        certAlias.setBackground(Display.getCurrent().getSystemColor(1));
        certAlias.setEditable(false);
        new Label(right, 0).setText(Messages.CertificateSelectionDialog_Details);
        Text certDetails = new Text(right, 578);
        GridDataFactory.fillDefaults().grab(true, false).hint(300, 230).applyTo((Control)certDetails);
        certDetails.setBackground(Display.getCurrent().getSystemColor(1));
        certDetails.setEditable(false);
        Composite dialogArea = new Composite(left, 0);
        GridLayoutFactory.fillDefaults().applyTo(dialogArea);
        Control control = super.createDialogArea(dialogArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(control);
        Composite certButtonsComposite = new Composite(grid, 0);
        GridLayoutFactory.createFrom((GridLayout)layout).numColumns(3).equalWidth(true).margins(layout.marginWidth, 0).applyTo(certButtonsComposite);
        CertificateSelectionDialog.applyDialogFont((Control)certButtonsComposite);
        Button browse = new Button(certButtonsComposite, 0);
        browse.setText(Messages.CertificateSelectionDialog_Import);
        browse.addSelectionListener((SelectionListener)new CertificateSelectionListener());
        Button delete = new Button(certButtonsComposite, 0);
        delete.setText(Messages.CertificateSelectionDialog_Delete);
        delete.addSelectionListener((SelectionListener)new DeleteButtonSelectionListener());
        this.getFilteredList().addSelectionListener((SelectionListener)new SelectionListenerImplementation(certDetails, certAlias));
        return control;
    }

    public String getCertificateAlias() {
        return this.alias;
    }

    public void setErrorMessage(String errorMessage) {
        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.CertificateSelectionDialog_Attention_Title, (String)errorMessage);
    }

    class CertificateSelectionListener
    implements SelectionListener {
        public static final long serialVersionUID = 1L;

        CertificateSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            String absoluteFilePath = FileDialogHelper.openImportDialog(CertificateSelectionDialog.this.getShell());
            if (StringUtils.isNotBlank((String)absoluteFilePath)) {
                String location = absoluteFilePath;
                InputDialog inputDialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.CertificateSelectionDialog_CertificateDesignation_Title, Messages.CertificateSelectionDialog_CertificateDesignation_Message, "", null);
                inputDialog.setBlockOnOpen(true);
                if (inputDialog.open() != 0) {
                    return;
                }
                String alias = inputDialog.getValue();
                if (StringUtils.isBlank((String)alias)) {
                    alias = String.valueOf(Messages.CertificateSelectionDialog_Unnamed) + EcoreUtil.generateUUID();
                }
                try {
                    KeyStoreManager.getInstance().addCertificate(alias, location);
                }
                catch (ESCertificateException e) {
                    CertificateSelectionDialog.this.setErrorMessage(e.getMessage());
                }
                try {
                    CertificateSelectionDialog.this.setListElements(KeyStoreManager.getInstance().getCertificates().toArray());
                }
                catch (ESCertificateException e1) {
                    CertificateSelectionDialog.this.setErrorMessage(e1.getMessage());
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    final class DeleteButtonSelectionListener
    implements SelectionListener {
        public static final long serialVersionUID = 1L;

        DeleteButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (CertificateSelectionDialog.this.selectedTableItem != null && StringUtils.isNotBlank((String)CertificateSelectionDialog.this.selectedTableItem.getText())) {
                String alias = CertificateSelectionDialog.this.selectedTableItem.getText();
                try {
                    KeyStoreManager.getInstance().deleteCertificate(alias);
                    CertificateSelectionDialog.this.setListElements(KeyStoreManager.getInstance().getCertificates().toArray());
                }
                catch (ESCertificateException e1) {
                    CertificateSelectionDialog.this.setErrorMessage(e1.getMessage());
                }
            }
        }
    }

    final class SelectionListenerImplementation
    implements SelectionListener {
        public static final long serialVersionUID = 1L;
        private final Text certDetails;
        private final Text certAlias;

        private SelectionListenerImplementation(Text certDetails, Text certAlias) {
            this.certDetails = certDetails;
            this.certAlias = certAlias;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (((Table)e.getSource()).getItems().length > 0) {
                CertificateSelectionDialog.this.selectedTableItem = ((Table)e.getSource()).getItems()[((Table)e.getSource()).getSelectionIndex()];
                CertificateSelectionDialog.this.alias = CertificateSelectionDialog.this.selectedTableItem.getText();
                try {
                    X509Certificate selectedCertificate = (X509Certificate)KeyStoreManager.getInstance().getCertificate(CertificateSelectionDialog.this.alias);
                    String[] details = selectedCertificate.toString().split("\n");
                    String tmp = "";
                    int i = 2;
                    while (i < 14) {
                        tmp = String.valueOf(tmp) + (i == 7 || i == 8 ? "" : String.valueOf(details[i].trim()) + "\n");
                        ++i;
                    }
                    this.certAlias.setText(CertificateSelectionDialog.this.alias);
                    this.certDetails.setText(tmp);
                }
                catch (ESCertificateException e1) {
                    CertificateSelectionDialog.this.setErrorMessage(e1.getMessage());
                }
            }
        }
    }
}

