/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfatic.ui.contentassist;

import java.util.TreeSet;
import org.eclipse.emf.emfatic.core.util.EmfaticKeywords;
import org.eclipse.emf.emfatic.ui.contentassist.WordPartDetector;
import org.eclipse.emf.emfatic.ui.editor.EmfaticEditor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class EmfaticKeywordContentAssistProcessor
implements IContentAssistProcessor {
    private TreeSet<String> proposalList = new TreeSet();
    private IContextInformationValidator fValidator = new Validator();

    public EmfaticKeywordContentAssistProcessor(EmfaticEditor editor) {
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        try {
            if (viewer.getDocument().getChar(offset - 1) == '@') {
                return new ICompletionProposal[0];
            }
        }
        catch (BadLocationException badLocationException) {}
        WordPartDetector wpd = new WordPartDetector(viewer, offset);
        String start = wpd.wordPart;
        this.proposalList = new TreeSet();
        String[] stringArray = EmfaticKeywords.GetKeywords();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String kw = stringArray[n2];
            if (kw.startsWith(start)) {
                this.proposalList.add(kw);
            }
            ++n2;
        }
        ICompletionProposal[] res = this.turnProposalVectorIntoAdaptedArray(wpd);
        return res;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[0];
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.fValidator;
    }

    public String getErrorMessage() {
        return null;
    }

    protected ICompletionProposal[] turnProposalVectorIntoAdaptedArray(WordPartDetector word) {
        ICompletionProposal[] result = new ICompletionProposal[this.proposalList.size()];
        int index = 0;
        for (String keyWord : this.proposalList) {
            new ContextInformation(keyWord, this.getContentInfoString(keyWord));
            result[index] = new CompletionProposal(keyWord, word.getOffset(), word.getLength(), keyWord.length(), null, keyWord, null, this.getContentInfoString(keyWord));
            ++index;
        }
        this.proposalList.clear();
        return result;
    }

    private String getContentInfoString(String keyWord) {
        return "";
    }

    protected static class Validator
    implements IContextInformationValidator,
    IContextInformationPresenter {
        protected int fInstallOffset;

        protected Validator() {
        }

        public boolean isContextInformationValid(int offset) {
            return Math.abs(this.fInstallOffset - offset) < 5;
        }

        public void install(IContextInformation info, ITextViewer viewer, int offset) {
            this.fInstallOffset = offset;
        }

        public boolean updatePresentation(int documentPosition, TextPresentation presentation) {
            return false;
        }
    }
}

