/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gymnast.runtime.ui.editor;

import java.io.Reader;
import java.io.StringReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.gymnast.runtime.core.parser.IParser;
import org.eclipse.gymnast.runtime.core.parser.ParseContext;
import org.eclipse.gymnast.runtime.core.util.MarkerUtil;
import org.eclipse.gymnast.runtime.ui.editor.LDTEditor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;

public class LDTReconcilingStrategy
implements IReconcilingStrategy {
    private LDTEditor _editor;
    private IDocument _document;

    public LDTReconcilingStrategy(LDTEditor editor) {
        this._editor = editor;
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.updateEditorParseRoot();
    }

    public void reconcile(IRegion partition) {
        this.updateEditorParseRoot();
    }

    public void setDocument(IDocument document) {
        this._document = document;
        this.updateEditorParseRoot();
    }

    private void updateEditorParseRoot() {
        try {
            ParseContext parseContext = this.parse();
            if (parseContext != null) {
                this._editor.setParseRoot(parseContext.getParseRoot());
            } else {
                this._editor.setParseRoot(null);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this._editor.setParseRoot(null);
        }
    }

    private ParseContext parse() {
        IFile file = this._editor.getFile();
        if (file == null) {
            return null;
        }
        MarkerUtil.clearMarkers((IFile)file);
        String input = this._document.get();
        StringReader reader = new StringReader(input);
        IParser parser = this._editor.getParser();
        ParseContext parseContext = parser.parse((Reader)reader);
        MarkerUtil.placeMarkers((IFile)file, (ParseContext)parseContext);
        return parseContext;
    }
}

