/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.meta.jvmmodel;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.eclipse.elk.core.meta.metaData.MdAlgorithm;
import org.eclipse.elk.core.meta.metaData.MdBundle;
import org.eclipse.elk.core.meta.metaData.MdBundleMember;
import org.eclipse.elk.core.meta.metaData.MdCategory;
import org.eclipse.elk.core.meta.metaData.MdGraphFeature;
import org.eclipse.elk.core.meta.metaData.MdGroup;
import org.eclipse.elk.core.meta.metaData.MdModel;
import org.eclipse.elk.core.meta.metaData.MdOption;
import org.eclipse.elk.core.meta.metaData.MdOptionDependency;
import org.eclipse.elk.core.meta.metaData.MdOptionSupport;
import org.eclipse.elk.core.meta.metaData.MdOptionTargetType;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.jvmmodel.AbstractModelInferrer;
import org.eclipse.xtext.xbase.jvmmodel.IJvmDeclaredTypeAcceptor;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypesBuilder;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class MetaDataJvmModelInferrer
extends AbstractModelInferrer {
    @Inject
    @Extension
    private JvmTypesBuilder _jvmTypesBuilder;
    @Inject
    @Extension
    private Primitives _primitives;

    protected void _infer(MdModel model, IJvmDeclaredTypeAcceptor acceptor, boolean isPreIndexingPhase) {
        if (model.getName() == null || model.getBundle() == null) {
            return;
        }
        final MdBundle bundle = model.getBundle();
        Procedures.Procedure1 _function = it -> {
            EList _superTypes = it.getSuperTypes();
            JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef("org.eclipse.elk.core.data.ILayoutMetaDataProvider", new JvmTypeReference[0]);
            this._jvmTypesBuilder.operator_add(_superTypes, (Object)_typeRef);
            this._jvmTypesBuilder.setFileHeader((JvmDeclaredType)it, this._jvmTypesBuilder.getDocumentation((EObject)model));
            this._jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)it, this._jvmTypesBuilder.getDocumentation((EObject)bundle));
            Iterable<MdOption> _allOptionDefinitions = this.getAllOptionDefinitions((Iterable<? extends MdBundleMember>)bundle.getMembers());
            for (MdOption property : _allOptionDefinitions) {
                XExpression _upperBound;
                boolean _tripleNotEquals_2;
                XExpression _lowerBound;
                boolean _tripleNotEquals_1;
                boolean _tripleNotEquals;
                JvmField constant = this.toOptionConstant(property);
                XExpression _defaultValue = property.getDefaultValue();
                boolean bl = _tripleNotEquals = _defaultValue != null;
                if (_tripleNotEquals) {
                    EList _members = it.getMembers();
                    JvmField _optionDefault = this.toOptionDefault(property);
                    this._jvmTypesBuilder.operator_add(_members, (Object)_optionDefault);
                }
                boolean bl2 = _tripleNotEquals_1 = (_lowerBound = property.getLowerBound()) != null;
                if (_tripleNotEquals_1) {
                    EList _members_1 = it.getMembers();
                    JvmField _optionLowerBound = this.toOptionLowerBound(property);
                    this._jvmTypesBuilder.operator_add(_members_1, (Object)_optionLowerBound);
                }
                boolean bl3 = _tripleNotEquals_2 = (_upperBound = property.getUpperBound()) != null;
                if (_tripleNotEquals_2) {
                    EList _members_2 = it.getMembers();
                    JvmField _optionUpperBound = this.toOptionUpperBound(property);
                    this._jvmTypesBuilder.operator_add(_members_2, (Object)_optionUpperBound);
                }
                EList _members_3 = it.getMembers();
                this._jvmTypesBuilder.operator_add(_members_3, (Object)constant);
            }
            Iterable<MdOption> _allOptionDefinitions_1 = this.getAllOptionDefinitions((Iterable<? extends MdBundleMember>)bundle.getMembers());
            for (MdOption property_1 : _allOptionDefinitions_1) {
                EList<MdOptionDependency> _dependencies = property_1.getDependencies();
                for (MdOptionDependency dependency : _dependencies) {
                    boolean _tripleNotEquals;
                    XExpression _value = dependency.getValue();
                    boolean bl = _tripleNotEquals = _value != null;
                    if (!_tripleNotEquals) continue;
                    EList _members = it.getMembers();
                    JvmField _dependencyValue = this.toDependencyValue(dependency);
                    this._jvmTypesBuilder.operator_add(_members, (Object)_dependencyValue);
                }
            }
            EList _members_1 = it.getMembers();
            Procedures.Procedure1 _function_1 = it_1 -> {
                EList _parameters = it_1.getParameters();
                JvmFormalParameter _parameter = this._jvmTypesBuilder.toParameter((EObject)bundle, "registry", this._typeReferenceBuilder.typeRef("org.eclipse.elk.core.data.ILayoutMetaDataProvider.Registry", new JvmTypeReference[0]));
                this._jvmTypesBuilder.operator_add(_parameters, (Object)_parameter);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        StringConcatenationClient _registerLayoutOptions = MetaDataJvmModelInferrer.this.registerLayoutOptions(bundle);
                        _builder.append((Object)_registerLayoutOptions);
                        _builder.newLineIfNotEmpty();
                        StringConcatenationClient _registerLayoutCategories = MetaDataJvmModelInferrer.this.registerLayoutCategories(bundle);
                        _builder.append((Object)_registerLayoutCategories);
                        _builder.newLineIfNotEmpty();
                        StringConcatenationClient _registerLayoutAlgorithms = MetaDataJvmModelInferrer.this.registerLayoutAlgorithms(bundle);
                        _builder.append((Object)_registerLayoutAlgorithms);
                        _builder.newLineIfNotEmpty();
                    }
                };
                this._jvmTypesBuilder.setBody((JvmExecutable)it_1, _client);
            };
            JvmOperation _method = this._jvmTypesBuilder.toMethod((EObject)bundle, "apply", this._typeReferenceBuilder.typeRef(Void.TYPE, new JvmTypeReference[0]), _function_1);
            this._jvmTypesBuilder.operator_add(_members_1, (Object)_method);
        };
        acceptor.accept((JvmDeclaredType)this._jvmTypesBuilder.toClass((EObject)bundle, this.getQualifiedTargetClass(bundle)), _function);
        Iterable _filter = Iterables.filter(bundle.getMembers(), MdAlgorithm.class);
        for (MdAlgorithm algorithm : _filter) {
            this.inferAlgorithm(model, algorithm, acceptor, isPreIndexingPhase);
        }
    }

    private JvmField toOptionConstant(final MdOption option) {
        JvmTypeReference _typeRef;
        JvmTypeReference _elvis = null;
        JvmTypeReference _type = option.getType();
        _elvis = _type != null ? _type : (_typeRef = this._typeReferenceBuilder.typeRef(Object.class, new JvmTypeReference[0]));
        Procedures.Procedure1 _function = it -> {
            it.setVisibility(JvmVisibility.PUBLIC);
            it.setStatic(true);
            it.setFinal(true);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    JvmTypeReference _typeRef;
                    _builder.append((Object)"new ");
                    _builder.append(Property.class);
                    _builder.append((Object)"<");
                    JvmTypeReference _elvis = null;
                    JvmTypeReference _asWrapperTypeIfPrimitive = MetaDataJvmModelInferrer.this._primitives.asWrapperTypeIfPrimitive(option.getType());
                    _elvis = _asWrapperTypeIfPrimitive != null ? _asWrapperTypeIfPrimitive : (_typeRef = MetaDataJvmModelInferrer.this._typeReferenceBuilder.typeRef(Object.class, new JvmTypeReference[0]));
                    _builder.append((Object)_elvis);
                    _builder.append((Object)">(");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"        ");
                    String _codeString = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.getQualifiedName(option));
                    _builder.append((Object)_codeString, "        ");
                    boolean _hasDefaultOrBounds = MetaDataJvmModelInferrer.this.hasDefaultOrBounds(option);
                    if (_hasDefaultOrBounds) {
                        boolean _tripleNotEquals_2;
                        boolean _tripleNotEquals_1;
                        boolean _tripleNotEquals;
                        _builder.append((Object)",");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"        ");
                        XExpression _defaultValue = option.getDefaultValue();
                        boolean bl = _tripleNotEquals = _defaultValue != null;
                        if (_tripleNotEquals) {
                            String _defaultConstantName = MetaDataJvmModelInferrer.this.getDefaultConstantName(option);
                            _builder.append((Object)_defaultConstantName, "        ");
                        } else {
                            _builder.append((Object)"null");
                        }
                        _builder.append((Object)",");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"        ");
                        XExpression _lowerBound = option.getLowerBound();
                        boolean bl2 = _tripleNotEquals_1 = _lowerBound != null;
                        if (_tripleNotEquals_1) {
                            String _lowerBoundConstantName = MetaDataJvmModelInferrer.this.getLowerBoundConstantName(option);
                            _builder.append((Object)_lowerBoundConstantName, "        ");
                        } else {
                            _builder.append((Object)"null");
                        }
                        _builder.append((Object)",");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"        ");
                        XExpression _upperBound = option.getUpperBound();
                        boolean bl3 = _tripleNotEquals_2 = _upperBound != null;
                        if (_tripleNotEquals_2) {
                            String _upperBoundConstantName = MetaDataJvmModelInferrer.this.getUpperBoundConstantName(option);
                            _builder.append((Object)_upperBoundConstantName, "        ");
                        } else {
                            _builder.append((Object)"null");
                        }
                    }
                    _builder.append((Object)")");
                }
            };
            this._jvmTypesBuilder.setInitializer(it, _client);
            boolean _isDeprecated = option.isDeprecated();
            if (_isDeprecated) {
                EList _annotations = it.getAnnotations();
                JvmAnnotationReference _annotationRef = this._annotationTypesBuilder.annotationRef(Deprecated.class, new String[0]);
                this._jvmTypesBuilder.operator_add(_annotations, (Object)_annotationRef);
                it.setDeprecated(true);
            }
            this._jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)it, this.trimLines(option.getDescription()));
        };
        return this._jvmTypesBuilder.toField((EObject)option, this.getConstantName(option), this._typeReferenceBuilder.typeRef(IProperty.class, new JvmTypeReference[]{_elvis}), _function);
    }

    private boolean hasDefaultOrBounds(MdOption option) {
        return option.getDefaultValue() != null || option.getLowerBound() != null || option.getUpperBound() != null;
    }

    private JvmField toOptionDefault(MdOption option) {
        JvmTypeReference _typeRef;
        JvmTypeReference _elvis = null;
        JvmTypeReference _cloneWithProxies = this._jvmTypesBuilder.cloneWithProxies(option.getType());
        _elvis = _cloneWithProxies != null ? _cloneWithProxies : (_typeRef = this._typeReferenceBuilder.typeRef(Object.class, new JvmTypeReference[0]));
        JvmTypeReference optionType = _elvis;
        Procedures.Procedure1 _function = it -> {
            it.setVisibility(JvmVisibility.PRIVATE);
            it.setStatic(true);
            it.setFinal(true);
            this._jvmTypesBuilder.setInitializer(it, option.getDefaultValue());
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Default value for {@link #");
            String _constantName = this.getConstantName(option);
            _builder.append(_constantName);
            _builder.append("}.");
            this._jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)it, _builder.toString());
        };
        return this._jvmTypesBuilder.toField((EObject)option, this.getDefaultConstantName(option), optionType, _function);
    }

    private JvmField toOptionLowerBound(MdOption option) {
        JvmTypeReference _wildcard;
        JvmTypeReference _elvis = null;
        JvmTypeReference _asWrapperTypeIfPrimitive = this._primitives.asWrapperTypeIfPrimitive(option.getType());
        JvmTypeReference _wildcardSuper = null;
        if (_asWrapperTypeIfPrimitive != null) {
            _wildcardSuper = this._typeReferenceBuilder.wildcardSuper(_asWrapperTypeIfPrimitive);
        }
        _elvis = _wildcardSuper != null ? _wildcardSuper : (_wildcard = this._typeReferenceBuilder.wildcard());
        JvmTypeReference optionType = this._typeReferenceBuilder.typeRef(Comparable.class, new JvmTypeReference[]{_elvis});
        Procedures.Procedure1 _function = it -> {
            it.setVisibility(JvmVisibility.PRIVATE);
            it.setStatic(true);
            it.setFinal(true);
            this._jvmTypesBuilder.setInitializer(it, option.getLowerBound());
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Lower bound value for {@link #");
            String _constantName = this.getConstantName(option);
            _builder.append(_constantName);
            _builder.append("}.");
            this._jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)it, _builder.toString());
        };
        return this._jvmTypesBuilder.toField((EObject)option, this.getLowerBoundConstantName(option), optionType, _function);
    }

    private JvmField toOptionUpperBound(MdOption option) {
        JvmTypeReference _wildcard;
        JvmTypeReference _elvis = null;
        JvmTypeReference _asWrapperTypeIfPrimitive = this._primitives.asWrapperTypeIfPrimitive(option.getType());
        JvmTypeReference _wildcardSuper = null;
        if (_asWrapperTypeIfPrimitive != null) {
            _wildcardSuper = this._typeReferenceBuilder.wildcardSuper(_asWrapperTypeIfPrimitive);
        }
        _elvis = _wildcardSuper != null ? _wildcardSuper : (_wildcard = this._typeReferenceBuilder.wildcard());
        JvmTypeReference optionType = this._typeReferenceBuilder.typeRef(Comparable.class, new JvmTypeReference[]{_elvis});
        Procedures.Procedure1 _function = it -> {
            it.setVisibility(JvmVisibility.PRIVATE);
            it.setStatic(true);
            it.setFinal(true);
            this._jvmTypesBuilder.setInitializer(it, option.getUpperBound());
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Upper bound value for {@link #");
            String _constantName = this.getConstantName(option);
            _builder.append(_constantName);
            _builder.append("}.");
            this._jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)it, _builder.toString());
        };
        return this._jvmTypesBuilder.toField((EObject)option, this.getUpperBoundConstantName(option), optionType, _function);
    }

    private JvmField toDependencyValue(MdOptionDependency dependency) {
        JvmTypeReference _typeRef;
        EObject _eContainer = dependency.eContainer();
        MdOption source = (MdOption)_eContainer;
        JvmTypeReference _elvis = null;
        JvmTypeReference _cloneWithProxies = this._jvmTypesBuilder.cloneWithProxies(dependency.getTarget().getType());
        _elvis = _cloneWithProxies != null ? _cloneWithProxies : (_typeRef = this._typeReferenceBuilder.typeRef(Object.class, new JvmTypeReference[0]));
        JvmTypeReference optionType = _elvis;
        Procedures.Procedure1 _function = it -> {
            it.setVisibility(JvmVisibility.PRIVATE);
            it.setStatic(true);
            it.setFinal(true);
            this._jvmTypesBuilder.setInitializer(it, dependency.getValue());
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Required value for dependency between {@link #");
            String _constantName = this.getConstantName(source);
            _builder.append(_constantName);
            _builder.append("} and {@link #");
            String _constantName_1 = this.getConstantName(dependency.getTarget());
            _builder.append(_constantName_1);
            _builder.append("}.");
            this._jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)it, _builder.toString());
        };
        return this._jvmTypesBuilder.toField((EObject)dependency, this.getDependencyConstantName(dependency), optionType, _function);
    }

    private StringConcatenationClient registerLayoutOptions(final MdBundle bundle) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Iterable<MdOption> _allOptionDefinitions = MetaDataJvmModelInferrer.this.getAllOptionDefinitions((Iterable<? extends MdBundleMember>)bundle.getMembers());
                for (MdOption option : _allOptionDefinitions) {
                    boolean _not_1;
                    boolean _not;
                    XExpression _upperBound;
                    boolean _tripleNotEquals_2;
                    XExpression _lowerBound;
                    boolean _tripleNotEquals_1;
                    boolean _tripleNotEquals;
                    String _name;
                    _builder.append((Object)"registry.register(new ");
                    JvmTypeReference _LayoutOptionData = MetaDataJvmModelInferrer.this.LayoutOptionData();
                    _builder.append((Object)_LayoutOptionData);
                    _builder.append((Object)".Builder()");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    _builder.append((Object)".id(");
                    String _codeString = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.getQualifiedName(option));
                    _builder.append((Object)_codeString, "    ");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    _builder.append((Object)".group(");
                    Functions.Function1 _function = it -> it.getName();
                    String _codeString_1 = MetaDataJvmModelInferrer.this.toCodeString(IterableExtensions.join((Iterable)IterableExtensions.map(MetaDataJvmModelInferrer.this.getGroups(option), (Functions.Function1)_function), (CharSequence)"."));
                    _builder.append((Object)_codeString_1, "    ");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    _builder.append((Object)".name(");
                    String _elvis = null;
                    String _label = option.getLabel();
                    _elvis = _label != null ? _label : (_name = option.getName());
                    String _codeString_2 = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.shrinkWhiteSpace(_elvis));
                    _builder.append((Object)_codeString_2, "    ");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    _builder.append((Object)".description(");
                    String _codeString_3 = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.shrinkWhiteSpace(option.getDescription()));
                    _builder.append((Object)_codeString_3, "    ");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                    XExpression _defaultValue = option.getDefaultValue();
                    boolean bl = _tripleNotEquals = _defaultValue != null;
                    if (_tripleNotEquals) {
                        _builder.append((Object)"    ");
                        _builder.append((Object)".defaultValue(");
                        String _defaultConstantName = MetaDataJvmModelInferrer.this.getDefaultConstantName(option);
                        _builder.append((Object)_defaultConstantName, "    ");
                        _builder.append((Object)")");
                        _builder.newLineIfNotEmpty();
                    }
                    boolean bl2 = _tripleNotEquals_1 = (_lowerBound = option.getLowerBound()) != null;
                    if (_tripleNotEquals_1) {
                        _builder.append((Object)"    ");
                        _builder.append((Object)".lowerBound(");
                        String _lowerBoundConstantName = MetaDataJvmModelInferrer.this.getLowerBoundConstantName(option);
                        _builder.append((Object)_lowerBoundConstantName, "    ");
                        _builder.append((Object)")");
                        _builder.newLineIfNotEmpty();
                    }
                    boolean bl3 = _tripleNotEquals_2 = (_upperBound = option.getUpperBound()) != null;
                    if (_tripleNotEquals_2) {
                        _builder.append((Object)"    ");
                        _builder.append((Object)".upperBound(");
                        String _upperBoundConstantName = MetaDataJvmModelInferrer.this.getUpperBoundConstantName(option);
                        _builder.append((Object)_upperBoundConstantName, "    ");
                        _builder.append((Object)")");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)"    ");
                    _builder.append((Object)".type(");
                    JvmTypeReference _LayoutOptionData_1 = MetaDataJvmModelInferrer.this.LayoutOptionData();
                    _builder.append((Object)_LayoutOptionData_1, "    ");
                    _builder.append((Object)".Type.");
                    String _optionType = MetaDataJvmModelInferrer.this.getOptionType(option);
                    _builder.append((Object)_optionType, "    ");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    _builder.append((Object)".optionClass(");
                    JvmTypeReference _optionTypeClass = MetaDataJvmModelInferrer.this.getOptionTypeClass(option);
                    _builder.append((Object)_optionTypeClass, "    ");
                    _builder.append((Object)".class)");
                    _builder.newLineIfNotEmpty();
                    boolean _isEmpty = option.getTargets().isEmpty();
                    boolean bl4 = _not = !_isEmpty;
                    if (_not) {
                        _builder.append((Object)"    ");
                        _builder.append((Object)".targets(");
                        _builder.append(EnumSet.class, "    ");
                        _builder.append((Object)".of(");
                        EList<MdOptionTargetType> _targets = option.getTargets();
                        boolean _hasElements = false;
                        for (MdOptionTargetType t : _targets) {
                            if (!_hasElements) {
                                _hasElements = true;
                            } else {
                                _builder.appendImmediate((Object)", ", "    ");
                            }
                            JvmTypeReference _LayoutOptionData_2 = MetaDataJvmModelInferrer.this.LayoutOptionData();
                            _builder.append((Object)_LayoutOptionData_2, "    ");
                            _builder.append((Object)".Target.");
                            String _upperCase = t.toString().toUpperCase();
                            _builder.append((Object)_upperCase, "    ");
                        }
                        _builder.append((Object)"))");
                        _builder.newLineIfNotEmpty();
                    }
                    if (option.isProgrammatic() || option.isOutput() || option.isGlobal()) {
                        _builder.append((Object)"    ");
                        _builder.append((Object)".visibility(");
                        JvmTypeReference _LayoutOptionData_3 = MetaDataJvmModelInferrer.this.LayoutOptionData();
                        _builder.append((Object)_LayoutOptionData_3, "    ");
                        _builder.append((Object)".Visibility.HIDDEN)");
                        _builder.newLineIfNotEmpty();
                    } else {
                        boolean _isAdvanced = option.isAdvanced();
                        if (_isAdvanced) {
                            _builder.append((Object)"    ");
                            _builder.append((Object)".visibility(");
                            JvmTypeReference _LayoutOptionData_4 = MetaDataJvmModelInferrer.this.LayoutOptionData();
                            _builder.append((Object)_LayoutOptionData_4, "    ");
                            _builder.append((Object)".Visibility.ADVANCED)");
                            _builder.newLineIfNotEmpty();
                        } else {
                            _builder.append((Object)"    ");
                            _builder.append((Object)".visibility(");
                            JvmTypeReference _LayoutOptionData_5 = MetaDataJvmModelInferrer.this.LayoutOptionData();
                            _builder.append((Object)_LayoutOptionData_5, "    ");
                            _builder.append((Object)".Visibility.VISIBLE)");
                            _builder.newLineIfNotEmpty();
                        }
                    }
                    boolean _isEmpty_1 = option.getLegacyIds().isEmpty();
                    boolean bl5 = _not_1 = !_isEmpty_1;
                    if (_not_1) {
                        _builder.append((Object)"    ");
                        _builder.append((Object)".legacyIds(");
                        Functions.Function1 _function_1 = it -> "\"" + it + "\"";
                        String _join = IterableExtensions.join((Iterable)ListExtensions.map(option.getLegacyIds(), (Functions.Function1)_function_1), (CharSequence)", ");
                        _builder.append((Object)_join, "    ");
                        _builder.append((Object)")");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)"    ");
                    _builder.append((Object)".create()");
                    _builder.newLine();
                    _builder.append((Object)");");
                    _builder.newLine();
                    EList<MdOptionDependency> _dependencies = option.getDependencies();
                    for (MdOptionDependency dependency : _dependencies) {
                        boolean _tripleEquals;
                        _builder.append((Object)"registry.addDependency(");
                        _builder.newLine();
                        _builder.append((Object)"    ");
                        String _codeString_4 = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.getQualifiedName(option));
                        _builder.append((Object)_codeString_4, "    ");
                        _builder.append((Object)",");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"    ");
                        String _codeString_5 = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.getQualifiedName(dependency.getTarget()));
                        _builder.append((Object)_codeString_5, "    ");
                        _builder.append((Object)",");
                        _builder.newLineIfNotEmpty();
                        XExpression _value = dependency.getValue();
                        boolean bl6 = _tripleEquals = _value == null;
                        if (_tripleEquals) {
                            _builder.append((Object)"    ");
                            _builder.append((Object)"null");
                            _builder.newLine();
                        } else {
                            _builder.append((Object)"    ");
                            String _dependencyConstantName = MetaDataJvmModelInferrer.this.getDependencyConstantName(dependency);
                            _builder.append((Object)_dependencyConstantName, "    ");
                            _builder.newLineIfNotEmpty();
                        }
                        _builder.append((Object)");");
                        _builder.newLine();
                    }
                }
            }
        };
        return _client;
    }

    private JvmTypeReference LayoutOptionData() {
        return this._typeReferenceBuilder.typeRef("org.eclipse.elk.core.data.LayoutOptionData", new JvmTypeReference[0]);
    }

    private StringConcatenationClient registerLayoutCategories(final MdBundle bundle) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Iterable _filter = Iterables.filter(bundle.getMembers(), MdCategory.class);
                for (MdCategory category : _filter) {
                    String _name;
                    _builder.append((Object)"registry.register(new ");
                    JvmTypeReference _LayoutCategoryData = MetaDataJvmModelInferrer.this.LayoutCategoryData();
                    _builder.append((Object)_LayoutCategoryData);
                    _builder.append((Object)".Builder()");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    _builder.append((Object)".id(");
                    String _codeString = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.getQualifiedName(category));
                    _builder.append((Object)_codeString, "    ");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    _builder.append((Object)".name(");
                    String _elvis = null;
                    String _label = category.getLabel();
                    _elvis = _label != null ? _label : (_name = category.getName());
                    String _codeString_1 = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.shrinkWhiteSpace(_elvis));
                    _builder.append((Object)_codeString_1, "    ");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    _builder.append((Object)".description(");
                    String _codeString_2 = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.shrinkWhiteSpace(category.getDescription()));
                    _builder.append((Object)_codeString_2, "    ");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    _builder.append((Object)".create()");
                    _builder.newLine();
                    _builder.append((Object)");");
                    _builder.newLine();
                }
            }
        };
        return _client;
    }

    private JvmTypeReference LayoutCategoryData() {
        return this._typeReferenceBuilder.typeRef("org.eclipse.elk.core.data.LayoutCategoryData", new JvmTypeReference[0]);
    }

    private StringConcatenationClient registerLayoutAlgorithms(final MdBundle bundle) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Iterable _filter = Iterables.filter(bundle.getMembers(), MdAlgorithm.class);
                for (MdAlgorithm algorithm : _filter) {
                    _builder.append((Object)"new ");
                    String _qualifiedTargetClass = MetaDataJvmModelInferrer.this.getQualifiedTargetClass(algorithm);
                    _builder.append((Object)_qualifiedTargetClass);
                    _builder.append((Object)"().apply(registry);");
                    _builder.newLineIfNotEmpty();
                }
            }
        };
        return _client;
    }

    private void inferAlgorithm(MdModel model, final MdAlgorithm algorithm, IJvmDeclaredTypeAcceptor acceptor, boolean isPreIndexingPhase) {
        boolean _tripleEquals;
        String _name = algorithm.getName();
        boolean bl = _tripleEquals = _name == null;
        if (_tripleEquals) {
            return;
        }
        Procedures.Procedure1 _function = it -> {
            EList _superTypes = it.getSuperTypes();
            JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef("org.eclipse.elk.core.data.ILayoutMetaDataProvider", new JvmTypeReference[0]);
            this._jvmTypesBuilder.operator_add(_superTypes, (Object)_typeRef);
            this._jvmTypesBuilder.setFileHeader((JvmDeclaredType)it, this._jvmTypesBuilder.getDocumentation((EObject)model));
            this._jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)it, algorithm.getDocumentation());
            EList _members = it.getMembers();
            JvmField _algorithmId = this.toAlgorithmId(algorithm);
            this._jvmTypesBuilder.operator_add(_members, (Object)_algorithmId);
            EList<MdOptionSupport> _supportedOptions = algorithm.getSupportedOptions();
            for (MdOptionSupport support : _supportedOptions) {
                boolean _tripleNotEquals;
                XExpression _value = support.getValue();
                boolean bl = _tripleNotEquals = _value != null;
                if (_tripleNotEquals) {
                    EList _members_1 = it.getMembers();
                    JvmField _supportedOptionDefault = this.toSupportedOptionDefault(support);
                    this._jvmTypesBuilder.operator_add(_members_1, (Object)_supportedOptionDefault);
                }
                EList _members_2 = it.getMembers();
                JvmField _supportedOptionConstant = this.toSupportedOptionConstant(support);
                this._jvmTypesBuilder.operator_add(_members_2, (Object)_supportedOptionConstant);
            }
            EList _members_1 = it.getMembers();
            Procedures.Procedure1 _function_1 = it_1 -> {
                EList _superTypes_1 = it_1.getSuperTypes();
                JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef("org.eclipse.elk.core.util.IFactory<AbstractLayoutProvider>", new JvmTypeReference[0]);
                this._jvmTypesBuilder.operator_add(_superTypes_1, (Object)_typeRef_1);
                it_1.setStatic(true);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Layouter-specific algorithm factory.");
                this._jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)it_1, _builder.toString());
                EList _members_2 = it_1.getMembers();
                Procedures.Procedure1 _function_2 = it_2 -> {
                    it_2.setVisibility(JvmVisibility.PUBLIC);
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"AbstractLayoutProvider provider = new ");
                            JvmTypeReference _provider = algorithm.getProvider();
                            _builder.append((Object)_provider);
                            _builder.append((Object)"();");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"provider.initialize(\"");
                            String _parameter = algorithm.getParameter();
                            _builder.append((Object)_parameter);
                            _builder.append((Object)"\");");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"return provider;");
                            _builder.newLine();
                        }
                    };
                    this._jvmTypesBuilder.setBody((JvmExecutable)it_2, _client);
                };
                JvmOperation _method = this._jvmTypesBuilder.toMethod((EObject)algorithm, "create", this._typeReferenceBuilder.typeRef("org.eclipse.elk.core.AbstractLayoutProvider", new JvmTypeReference[0]), _function_2);
                this._jvmTypesBuilder.operator_add(_members_2, (Object)_method);
                EList _members_3 = it_1.getMembers();
                Procedures.Procedure1 _function_3 = it_2 -> {
                    EList _parameters = it_2.getParameters();
                    JvmFormalParameter _parameter = this._jvmTypesBuilder.toParameter((EObject)algorithm, "obj", this._typeReferenceBuilder.typeRef("org.eclipse.elk.core.AbstractLayoutProvider", new JvmTypeReference[0]));
                    this._jvmTypesBuilder.operator_add(_parameters, (Object)_parameter);
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"obj.dispose();");
                            _builder.newLine();
                        }
                    };
                    this._jvmTypesBuilder.setBody((JvmExecutable)it_2, _client);
                };
                JvmOperation _method_1 = this._jvmTypesBuilder.toMethod((EObject)algorithm, "destroy", this._typeReferenceBuilder.typeRef(Void.TYPE, new JvmTypeReference[0]), _function_3);
                this._jvmTypesBuilder.operator_add(_members_3, (Object)_method_1);
            };
            JvmGenericType _class = this._jvmTypesBuilder.toClass((EObject)algorithm, this.toFactoryClass(algorithm), _function_1);
            this._jvmTypesBuilder.operator_add(_members_1, (Object)_class);
            EList _members_2 = it.getMembers();
            Procedures.Procedure1 _function_2 = it_1 -> {
                EList _parameters = it_1.getParameters();
                JvmFormalParameter _parameter = this._jvmTypesBuilder.toParameter((EObject)algorithm, "registry", this._typeReferenceBuilder.typeRef("org.eclipse.elk.core.data.ILayoutMetaDataProvider.Registry", new JvmTypeReference[0]));
                this._jvmTypesBuilder.operator_add(_parameters, (Object)_parameter);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        StringConcatenationClient _registerLayoutAlgorithm = MetaDataJvmModelInferrer.this.registerLayoutAlgorithm(algorithm);
                        _builder.append((Object)_registerLayoutAlgorithm);
                        _builder.newLineIfNotEmpty();
                    }
                };
                this._jvmTypesBuilder.setBody((JvmExecutable)it_1, _client);
            };
            JvmOperation _method = this._jvmTypesBuilder.toMethod((EObject)algorithm, "apply", this._typeReferenceBuilder.typeRef(Void.TYPE, new JvmTypeReference[0]), _function_2);
            this._jvmTypesBuilder.operator_add(_members_2, (Object)_method);
        };
        acceptor.accept((JvmDeclaredType)this._jvmTypesBuilder.toClass((EObject)algorithm, this.getQualifiedTargetClass(algorithm)), _function);
    }

    private String toFactoryClass(MdAlgorithm algorithm) {
        String _firstUpper = StringExtensions.toFirstUpper((String)algorithm.getName());
        return _firstUpper + "Factory";
    }

    private JvmField toAlgorithmId(final MdAlgorithm algorithm) {
        Procedures.Procedure1 _function = it -> {
            it.setVisibility(JvmVisibility.PUBLIC);
            it.setStatic(true);
            it.setFinal(true);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    String _codeString = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.getQualifiedName(algorithm));
                    _builder.append((Object)_codeString);
                }
            };
            this._jvmTypesBuilder.setInitializer(it, _client);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("The id of the ");
            String _label = algorithm.getLabel();
            _builder.append(_label);
            _builder.append(" algorithm.");
            this._jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)it, _builder.toString());
        };
        return this._jvmTypesBuilder.toField((EObject)algorithm, "ALGORITHM_ID", this._typeReferenceBuilder.typeRef(String.class, new JvmTypeReference[0]), _function);
    }

    private JvmField toSupportedOptionDefault(MdOptionSupport support) {
        JvmTypeReference _typeRef;
        EObject _eContainer = support.eContainer();
        MdAlgorithm algorithm = (MdAlgorithm)_eContainer;
        JvmTypeReference _elvis = null;
        JvmTypeReference _cloneWithProxies = this._jvmTypesBuilder.cloneWithProxies(support.getOption().getType());
        _elvis = _cloneWithProxies != null ? _cloneWithProxies : (_typeRef = this._typeReferenceBuilder.typeRef(Object.class, new JvmTypeReference[0]));
        JvmTypeReference optionType = _elvis;
        Procedures.Procedure1 _function = it -> {
            String _name;
            it.setVisibility(JvmVisibility.PRIVATE);
            it.setStatic(true);
            it.setFinal(true);
            this._jvmTypesBuilder.setInitializer(it, support.getValue());
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Default value for {@link #");
            String _constantName = this.getConstantName(support.getOption());
            _builder.append(_constantName);
            _builder.append("} with algorithm \"");
            String _elvis_1 = null;
            String _label = algorithm.getLabel();
            _elvis_1 = _label != null ? _label : (_name = algorithm.getName());
            _builder.append(_elvis_1);
            _builder.append("\".");
            this._jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)it, _builder.toString());
        };
        return this._jvmTypesBuilder.toField((EObject)support, this.getDefaultConstantName(support.getOption()), optionType, _function);
    }

    private JvmField toSupportedOptionConstant(final MdOptionSupport support) {
        JvmTypeReference _typeRef;
        JvmTypeReference _elvis = null;
        JvmTypeReference _type = support.getOption().getType();
        _elvis = _type != null ? _type : (_typeRef = this._typeReferenceBuilder.typeRef(Object.class, new JvmTypeReference[0]));
        Procedures.Procedure1 _function = it -> {
            boolean _not;
            StringConcatenationClient _client_1;
            StringConcatenationClient _client;
            it.setVisibility(JvmVisibility.PUBLIC);
            it.setStatic(true);
            it.setFinal(true);
            StringConcatenationClient _xifexpression = null;
            XExpression _value = support.getValue();
            boolean _tripleEquals = _value == null;
            _xifexpression = _tripleEquals ? (_client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    JvmTypeReference _typeRef = MetaDataJvmModelInferrer.this._typeReferenceBuilder.typeRef(MetaDataJvmModelInferrer.this.getQualifiedTargetClass(MetaDataJvmModelInferrer.this.getBundle(support.getOption())), new JvmTypeReference[0]);
                    _builder.append((Object)_typeRef);
                    _builder.append((Object)".");
                    String _constantName = MetaDataJvmModelInferrer.this.getConstantName(support.getOption());
                    _builder.append((Object)_constantName);
                }
            }) : (_client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    JvmTypeReference _typeRef;
                    _builder.append((Object)"new ");
                    _builder.append(Property.class);
                    _builder.append((Object)"<");
                    JvmTypeReference _elvis = null;
                    JvmTypeReference _asWrapperTypeIfPrimitive = MetaDataJvmModelInferrer.this._primitives.asWrapperTypeIfPrimitive(support.getOption().getType());
                    _elvis = _asWrapperTypeIfPrimitive != null ? _asWrapperTypeIfPrimitive : (_typeRef = MetaDataJvmModelInferrer.this._typeReferenceBuilder.typeRef(Object.class, new JvmTypeReference[0]));
                    _builder.append((Object)_elvis);
                    _builder.append((Object)">(");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"                            ");
                    JvmTypeReference _typeRef_1 = MetaDataJvmModelInferrer.this._typeReferenceBuilder.typeRef(MetaDataJvmModelInferrer.this.getQualifiedTargetClass(MetaDataJvmModelInferrer.this.getBundle(support.getOption())), new JvmTypeReference[0]);
                    _builder.append((Object)_typeRef_1, "                            ");
                    _builder.append((Object)".");
                    String _constantName = MetaDataJvmModelInferrer.this.getConstantName(support.getOption());
                    _builder.append((Object)_constantName, "                            ");
                    _builder.append((Object)",");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"                            ");
                    String _defaultConstantName = MetaDataJvmModelInferrer.this.getDefaultConstantName(support.getOption());
                    _builder.append((Object)_defaultConstantName, "                            ");
                    _builder.append((Object)")");
                }
            });
            this._jvmTypesBuilder.setInitializer(it, _xifexpression);
            boolean _isDeprecated = support.getOption().isDeprecated();
            if (_isDeprecated) {
                EList _annotations = it.getAnnotations();
                JvmAnnotationReference _annotationRef = this._annotationTypesBuilder.annotationRef(Deprecated.class, new String[0]);
                this._jvmTypesBuilder.operator_add(_annotations, (Object)_annotationRef);
                it.setDeprecated(true);
            }
            String _trimLines = this.trimLines(support.getOption().getDescription());
            Object _xifexpression_1 = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)support.getDocumentation());
            boolean bl = _not = !_isNullOrEmpty;
            if (_not) {
                String _trimLines_1 = this.trimLines(support.getDocumentation());
                _xifexpression_1 = "\n<h3>Algorithm Specific Details</h3>\n" + _trimLines_1;
            } else {
                _xifexpression_1 = "";
            }
            String _plus = _trimLines + (String)_xifexpression_1;
            this._jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)it, _plus);
        };
        return this._jvmTypesBuilder.toField((EObject)support, this.getConstantName(support.getOption()), this._typeReferenceBuilder.typeRef(IProperty.class, new JvmTypeReference[]{_elvis}), _function);
    }

    private StringConcatenationClient registerLayoutAlgorithm(final MdAlgorithm algorithm) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                JvmTypeReference _validator;
                boolean _tripleNotEquals_4;
                boolean _isEmpty;
                boolean _not;
                String _previewImage;
                boolean _tripleNotEquals_3;
                boolean _tripleNotEquals_2;
                MdBundle _bundle;
                boolean _tripleNotEquals_1;
                boolean _tripleNotEquals;
                String _name;
                _builder.append((Object)"registry.register(new ");
                JvmTypeReference _LayoutAlgorithmData = MetaDataJvmModelInferrer.this.LayoutAlgorithmData();
                _builder.append((Object)_LayoutAlgorithmData);
                _builder.append((Object)".Builder()");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)".id(");
                String _codeString = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.getQualifiedName(algorithm));
                _builder.append((Object)_codeString, "    ");
                _builder.append((Object)")");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)".name(");
                String _elvis = null;
                String _label = algorithm.getLabel();
                _elvis = _label != null ? _label : (_name = algorithm.getName());
                String _codeString_1 = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.shrinkWhiteSpace(_elvis));
                _builder.append((Object)_codeString_1, "    ");
                _builder.append((Object)")");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)".description(");
                String _codeString_2 = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.shrinkWhiteSpace(algorithm.getDescription()));
                _builder.append((Object)_codeString_2, "    ");
                _builder.append((Object)")");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)".providerFactory(new ");
                String _factoryClass = MetaDataJvmModelInferrer.this.toFactoryClass(algorithm);
                _builder.append((Object)_factoryClass, "    ");
                _builder.append((Object)"())");
                _builder.newLineIfNotEmpty();
                MdCategory _category = algorithm.getCategory();
                boolean bl = _tripleNotEquals = _category != null;
                if (_tripleNotEquals) {
                    _builder.append((Object)"    ");
                    _builder.append((Object)".category(");
                    String _codeString_3 = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.getQualifiedName(algorithm.getCategory()));
                    _builder.append((Object)_codeString_3, "    ");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                }
                boolean bl2 = _tripleNotEquals_1 = (_bundle = MetaDataJvmModelInferrer.this.getBundle(algorithm)) != null;
                if (_tripleNotEquals_1) {
                    _builder.append((Object)"    ");
                    _builder.append((Object)".melkBundleName(");
                    String _codeString_4 = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.getBundle(algorithm).getLabel());
                    _builder.append((Object)_codeString_4, "    ");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                }
                MdModel _model = MetaDataJvmModelInferrer.this.getModel(algorithm);
                String _definingBundleId = null;
                if (_model != null) {
                    _definingBundleId = MetaDataJvmModelInferrer.this.getDefiningBundleId(_model);
                }
                boolean bl3 = _tripleNotEquals_2 = _definingBundleId != null;
                if (_tripleNotEquals_2) {
                    _builder.append((Object)"    ");
                    _builder.append((Object)".definingBundleId(");
                    String _codeString_5 = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.getDefiningBundleId(MetaDataJvmModelInferrer.this.getModel(algorithm)));
                    _builder.append((Object)_codeString_5, "    ");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                }
                boolean bl4 = _tripleNotEquals_3 = (_previewImage = algorithm.getPreviewImage()) != null;
                if (_tripleNotEquals_3) {
                    _builder.append((Object)"    ");
                    _builder.append((Object)".imagePath(");
                    String _codeString_6 = MetaDataJvmModelInferrer.this.toCodeString(algorithm.getPreviewImage());
                    _builder.append((Object)_codeString_6, "    ");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                }
                boolean bl5 = _not = !(_isEmpty = algorithm.getSupportedFeatures().isEmpty());
                if (_not) {
                    _builder.append((Object)"    ");
                    _builder.append((Object)".supportedFeatures(");
                    _builder.append(EnumSet.class, "    ");
                    _builder.append((Object)".of(");
                    EList<MdGraphFeature> _supportedFeatures = algorithm.getSupportedFeatures();
                    boolean _hasElements = false;
                    for (MdGraphFeature f : _supportedFeatures) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "    ");
                        }
                        JvmTypeReference _typeRef = MetaDataJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.eclipse.elk.graph.properties.GraphFeature", new JvmTypeReference[0]);
                        _builder.append((Object)_typeRef, "    ");
                        _builder.append((Object)".");
                        String _upperCase = f.toString().toUpperCase();
                        _builder.append((Object)_upperCase, "    ");
                    }
                    _builder.append((Object)"))");
                    _builder.newLineIfNotEmpty();
                }
                boolean bl6 = _tripleNotEquals_4 = (_validator = algorithm.getValidator()) != null;
                if (_tripleNotEquals_4) {
                    _builder.append((Object)"    ");
                    _builder.append((Object)".validatorClass(");
                    JvmTypeReference _validator_1 = algorithm.getValidator();
                    _builder.append((Object)_validator_1, "    ");
                    _builder.append((Object)".class)");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"    ");
                _builder.append((Object)".create()");
                _builder.newLine();
                _builder.append((Object)");");
                _builder.newLine();
                EList<MdOptionSupport> _supportedOptions = algorithm.getSupportedOptions();
                for (MdOptionSupport support : _supportedOptions) {
                    boolean _tripleEquals;
                    _builder.append((Object)"registry.addOptionSupport(");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    String _codeString_7 = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.getQualifiedName(algorithm));
                    _builder.append((Object)_codeString_7, "    ");
                    _builder.append((Object)",");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    String _codeString_8 = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.getQualifiedName(support.getOption()));
                    _builder.append((Object)_codeString_8, "    ");
                    _builder.append((Object)",");
                    _builder.newLineIfNotEmpty();
                    XExpression _value = support.getValue();
                    boolean bl7 = _tripleEquals = _value == null;
                    if (_tripleEquals) {
                        _builder.append((Object)"    ");
                        String _constantName = MetaDataJvmModelInferrer.this.getConstantName(support.getOption());
                        _builder.append((Object)_constantName, "    ");
                        _builder.append((Object)".getDefault()");
                        _builder.newLineIfNotEmpty();
                    } else {
                        _builder.append((Object)"    ");
                        String _defaultConstantName = MetaDataJvmModelInferrer.this.getDefaultConstantName(support.getOption());
                        _builder.append((Object)_defaultConstantName, "    ");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)");");
                    _builder.newLine();
                }
            }
        };
        return _client;
    }

    private JvmTypeReference LayoutAlgorithmData() {
        return this._typeReferenceBuilder.typeRef("org.eclipse.elk.core.data.LayoutAlgorithmData", new JvmTypeReference[0]);
    }

    private Iterable<MdOption> getAllOptionDefinitions(Iterable<? extends MdBundleMember> elements) {
        Functions.Function1 _function = it -> this.getAllOptionDefinitions((Iterable<? extends MdBundleMember>)it.getChildren());
        return Iterables.concat((Iterable)Iterables.filter(elements, MdOption.class), (Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter(elements, MdGroup.class), (Functions.Function1)_function)));
    }

    private String getQualifiedTargetClass(MdBundle bundle) {
        EObject _eContainer = bundle.eContainer();
        MdModel model = (MdModel)_eContainer;
        String _elvis = null;
        String _targetClass = bundle.getTargetClass();
        _elvis = _targetClass != null ? _targetClass : "Metadata";
        String bundleClass = _elvis;
        String _name = model.getName();
        String _plus = _name + ".";
        return _plus + bundleClass;
    }

    private String getQualifiedTargetClass(MdAlgorithm algorithm) {
        EObject _eContainer = this.getBundle(algorithm).eContainer();
        MdModel model = (MdModel)_eContainer;
        Object _elvis = null;
        String _targetClass = algorithm.getTargetClass();
        if (_targetClass != null) {
            _elvis = _targetClass;
        } else {
            String _firstUpper = StringExtensions.toFirstUpper((String)algorithm.getName());
            String _plus = _firstUpper + "Metadata";
            _elvis = _plus;
        }
        String algorithmClass = _elvis;
        String _name = model.getName();
        String _plus_1 = _name + ".";
        return _plus_1 + algorithmClass;
    }

    private Iterable<MdGroup> getGroups(MdBundleMember member) {
        LinkedList<MdGroup> _xblockexpression = null;
        LinkedList<MdGroup> groups = new LinkedList<MdGroup>();
        EObject group = member.eContainer();
        while (group instanceof MdGroup) {
            groups.addFirst((MdGroup)group);
            group = ((MdGroup)group).eContainer();
        }
        _xblockexpression = groups;
        return _xblockexpression;
    }

    private String getOptionType(MdOption option) {
        boolean _matched_1;
        String _identifier;
        JvmTypeReference _type = option.getType();
        JvmType _type_1 = null;
        if (_type != null) {
            _type_1 = _type.getType();
        }
        JvmType jvmType = _type_1;
        boolean _matched = false;
        if (jvmType instanceof JvmPrimitiveType) {
            String _name_3;
            String _name_2;
            String _name_1;
            _matched = true;
            _identifier = ((JvmPrimitiveType)jvmType).getIdentifier();
            _matched_1 = false;
            String _name = Boolean.TYPE.getName();
            if (Objects.equals(_identifier, _name)) {
                _matched_1 = true;
                return "BOOLEAN";
            }
            if (!_matched_1 && Objects.equals(_identifier, _name_1 = Integer.TYPE.getName())) {
                _matched_1 = true;
                return "INT";
            }
            if (!_matched_1 && Objects.equals(_identifier, _name_2 = Double.TYPE.getName())) {
                _matched_1 = true;
                return "DOUBLE";
            }
            if (!_matched_1 && Objects.equals(_identifier, _name_3 = Float.TYPE.getName())) {
                _matched_1 = true;
                return "DOUBLE";
            }
        }
        if (!_matched && jvmType instanceof JvmGenericType) {
            String _canonicalName_5;
            String _canonicalName_4;
            String _canonicalName_3;
            String _canonicalName_2;
            String _canonicalName_1;
            _matched = true;
            _identifier = ((JvmGenericType)jvmType).getIdentifier();
            _matched_1 = false;
            String _canonicalName = Boolean.class.getCanonicalName();
            if (Objects.equals(_identifier, _canonicalName)) {
                _matched_1 = true;
                return "BOOLEAN";
            }
            if (!_matched_1 && Objects.equals(_identifier, _canonicalName_1 = Integer.class.getCanonicalName())) {
                _matched_1 = true;
                return "INT";
            }
            if (!_matched_1 && Objects.equals(_identifier, _canonicalName_2 = Double.class.getCanonicalName())) {
                _matched_1 = true;
                return "DOUBLE";
            }
            if (!_matched_1 && Objects.equals(_identifier, _canonicalName_3 = Float.class.getCanonicalName())) {
                _matched_1 = true;
                return "DOUBLE";
            }
            if (!_matched_1 && Objects.equals(_identifier, _canonicalName_4 = String.class.getCanonicalName())) {
                _matched_1 = true;
                return "STRING";
            }
            if (!_matched_1 && Objects.equals(_identifier, _canonicalName_5 = EnumSet.class.getCanonicalName())) {
                _matched_1 = true;
                return "ENUMSET";
            }
            return "OBJECT";
        }
        if (!_matched && jvmType instanceof JvmEnumerationType) {
            _matched = true;
            return "ENUM";
        }
        return "UNDEFINED";
    }

    private JvmTypeReference getOptionTypeClass(MdOption property) {
        JvmTypeReference _xblockexpression;
        boolean _tripleNotEquals;
        JvmTypeReference _xifexpression = null;
        JvmTypeReference _type = property.getType();
        boolean bl = _tripleNotEquals = _type != null;
        if (_tripleNotEquals) {
            _xblockexpression = null;
            JvmType _type_1 = property.getType().getType();
            if (_type_1 instanceof JvmPrimitiveType) {
                JvmType _type_2 = property.getType().getType();
                JvmPrimitiveType primitiveType = (JvmPrimitiveType)_type_2;
                String _simpleName = primitiveType.getSimpleName();
                boolean _equals = Objects.equals(_simpleName, "float");
                if (_equals) {
                    return this._typeReferenceBuilder.typeRef(Double.class, new JvmTypeReference[0]);
                }
                String _simpleName_1 = primitiveType.getSimpleName();
                boolean _equals_1 = Objects.equals(_simpleName_1, "long");
                if (_equals_1) {
                    return this._typeReferenceBuilder.typeRef(Integer.class, new JvmTypeReference[0]);
                }
            } else {
                JvmType _type_3 = property.getType().getType();
                if (_type_3 instanceof JvmGenericType) {
                    JvmType _type_4 = property.getType().getType();
                    JvmGenericType genericType = (JvmGenericType)_type_4;
                    String _identifier = genericType.getIdentifier();
                    boolean _equals_2 = Objects.equals(_identifier, "java.lang.Float");
                    if (_equals_2) {
                        return this._typeReferenceBuilder.typeRef(Double.class, new JvmTypeReference[0]);
                    }
                    String _identifier_1 = genericType.getIdentifier();
                    boolean _equals_3 = Objects.equals(_identifier_1, "java.lang.Long");
                    if (_equals_3) {
                        return this._typeReferenceBuilder.typeRef(Integer.class, new JvmTypeReference[0]);
                    }
                    String _identifier_2 = genericType.getIdentifier();
                    boolean _equals_4 = Objects.equals(_identifier_2, "java.util.EnumSet");
                    if (_equals_4) {
                        JvmTypeReference _type_5 = property.getType();
                        JvmParameterizedTypeReference outer = (JvmParameterizedTypeReference)_type_5;
                        return this._jvmTypesBuilder.cloneWithProxies((JvmTypeReference)IterableExtensions.head((Iterable)outer.getArguments()));
                    }
                    String _identifier_3 = genericType.getIdentifier();
                    boolean _equals_5 = Objects.equals(_identifier_3, "java.util.List");
                    if (_equals_5) {
                        return this._typeReferenceBuilder.typeRef(List.class, new JvmTypeReference[0]);
                    }
                }
            }
        } else {
            return this._typeReferenceBuilder.typeRef(Void.class, new JvmTypeReference[0]);
        }
        _xifexpression = _xblockexpression = this._primitives.asWrapperTypeIfPrimitive(this._jvmTypesBuilder.cloneWithProxies(property.getType()));
        return _xifexpression;
    }

    private MdBundle getBundle(MdBundleMember member) {
        EObject parent = member.eContainer();
        while (!(parent instanceof MdBundle)) {
            parent = parent.eContainer();
        }
        return (MdBundle)parent;
    }

    private MdModel getModel(MdBundleMember member) {
        EObject parent = member.eContainer();
        while (!(parent instanceof MdModel)) {
            parent = parent.eContainer();
        }
        return (MdModel)parent;
    }

    private String getDefiningBundleId(MdModel model) {
        URI uri = model.eResource().getURI();
        int srcIndex = ((List)Conversions.doWrapArray((Object)uri.segments())).indexOf("src");
        if (srcIndex >= 1) {
            return uri.segments()[srcIndex - 1];
        }
        return null;
    }

    private String getQualifiedName(MdBundleMember member) {
        int _lastIndexOf;
        int _plus;
        String _substring;
        String _name;
        MdBundle bundle = this.getBundle(member);
        EObject _eContainer = bundle.eContainer();
        MdModel model = (MdModel)_eContainer;
        String _elvis = null;
        String _idPrefix = bundle.getIdPrefix();
        _elvis = _idPrefix != null ? _idPrefix : (_name = model.getName());
        String prefix = _elvis;
        String _name_1 = member.getName();
        boolean _equals = Objects.equals(_name_1, _substring = prefix.substring(_plus = (_lastIndexOf = prefix.lastIndexOf(".")) + 1, prefix.length()));
        if (_equals) {
            prefix = prefix.substring(0, prefix.lastIndexOf("."));
        }
        String _xifexpression = null;
        boolean _isEmpty = IterableExtensions.isEmpty(this.getGroups(member));
        _xifexpression = _isEmpty ? "" : ".";
        String _plus_1 = prefix + _xifexpression;
        Functions.Function1 _function = it -> it.getName();
        String _join = IterableExtensions.join((Iterable)IterableExtensions.map(this.getGroups(member), (Functions.Function1)_function), (CharSequence)".");
        String _plus_2 = _plus_1 + _join;
        String _plus_3 = _plus_2 + ".";
        String _name_2 = member.getName();
        return _plus_3 + _name_2;
    }

    private String getConstantName(MdBundleMember member) {
        String name = member.getName();
        if (name != null) {
            boolean _greaterThan;
            StringBuilder result = new StringBuilder();
            Functions.Function1 _function = it -> this.toUpperCaseWithUnderscores(it.getName());
            result.append(IterableExtensions.join((Iterable)IterableExtensions.map(this.getGroups(member), (Functions.Function1)_function), (CharSequence)"_"));
            int _length = result.length();
            boolean bl = _greaterThan = _length > 0;
            if (_greaterThan) {
                result.append("_");
            }
            result.append(this.toUpperCaseWithUnderscores(name));
            return result.toString();
        }
        return null;
    }

    private String toUpperCaseWithUnderscores(String str) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (Character.isUpperCase(c) && i > 0) {
                result.append("_");
            }
            result.append(Character.toUpperCase(c));
            ++i;
        }
        return result.toString();
    }

    private String getDefaultConstantName(MdOption option) {
        String _constantName = this.getConstantName(option);
        return _constantName + "_DEFAULT";
    }

    private String getLowerBoundConstantName(MdOption option) {
        String _constantName = this.getConstantName(option);
        return _constantName + "_LOWER_BOUND";
    }

    private String getUpperBoundConstantName(MdOption option) {
        String _constantName = this.getConstantName(option);
        return _constantName + "_UPPER_BOUND";
    }

    private String getDependencyConstantName(MdOptionDependency dependency) {
        String _xblockexpression = null;
        EObject _eContainer = dependency.eContainer();
        MdOption option = (MdOption)_eContainer;
        String _constantName = this.getConstantName(option);
        String _plus = _constantName + "_DEP_";
        String _constantName_1 = this.getConstantName(dependency.getTarget());
        String _plus_1 = _plus + _constantName_1;
        String _plus_2 = _plus_1 + "_";
        int _indexOf = option.getDependencies().indexOf((Object)dependency);
        _xblockexpression = _plus_2 + String.valueOf((Object)_indexOf);
        return _xblockexpression;
    }

    private String toCodeString(String s) {
        if (s == null) {
            return "null";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\"");
        String _convertToJavaString = Strings.convertToJavaString((String)s);
        _builder.append(_convertToJavaString);
        _builder.append("\"");
        return _builder.toString();
    }

    private String shrinkWhiteSpace(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        boolean shrink = true;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            boolean _isWhitespace = Character.isWhitespace(c);
            if (_isWhitespace) {
                if (!shrink) {
                    result.append(" ");
                }
                shrink = true;
            } else {
                result.append(c);
                shrink = false;
            }
            ++i;
        }
        if (result.length() > 0 && Character.isWhitespace(result.charAt(result.length() - 1))) {
            int _length = result.length();
            int _minus = _length - 1;
            result.deleteCharAt(_minus);
        }
        return result.toString();
    }

    private String trimLines(String s) {
        String _xifexpression = null;
        if (s == null) {
            _xifexpression = null;
        } else {
            Functions.Function1 _function = it -> it.trim();
            _xifexpression = IterableExtensions.join((Iterable)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)s.split("\r?\n"))), (Functions.Function1)_function), (CharSequence)"\n");
        }
        return _xifexpression;
    }

    @XbaseGenerated
    public void infer(EObject model, IJvmDeclaredTypeAcceptor acceptor, boolean isPreIndexingPhase) {
        if (model instanceof MdModel) {
            this._infer((MdModel)model, acceptor, isPreIndexingPhase);
            return;
        }
        if (model != null) {
            this._infer(model, acceptor, isPreIndexingPhase);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(model, acceptor, isPreIndexingPhase).toString());
    }
}

