/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.editor.contributor;

import org.eclipse.egf.common.ui.helper.EditorHelper;
import org.eclipse.egf.core.ui.contributor.MenuContributor;
import org.eclipse.egf.model.domain.DomainURI;
import org.eclipse.egf.model.editor.EGFModelEditorPlugin;
import org.eclipse.egf.model.editor.l10n.ModelEditorMessages;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;

public class URIMenuContributor
extends MenuContributor {
    public static final String EDIT_ACTION_ID = "edit-fcore";
    private final EditURIAction _editAction = new EditURIAction();

    public void menuAboutToShow(IMenuManager menuManager) {
        IStructuredSelection selection2 = (IStructuredSelection)this.selection;
        if (selection2.size() == 1 && selection2.getFirstElement() instanceof DomainURI) {
            this._editAction.setEnabled(this._editAction.isEnabled());
            menuManager.insertBefore("open", (IAction)this._editAction);
        }
    }

    private class EditURIAction
    extends Action {
        public EditURIAction() {
            super(ModelEditorMessages.URIMenuContributor_openAction_label);
            this.setId(URIMenuContributor.EDIT_ACTION_ID);
        }

        public boolean isEnabled() {
            URI uri = this.getURI();
            return uri != null;
        }

        protected URI getURI() {
            if (URIMenuContributor.this.selection == null) {
                return null;
            }
            IStructuredSelection sselection = (IStructuredSelection)URIMenuContributor.this.selection;
            if (sselection.size() != 1) {
                return null;
            }
            Object object = sselection.getFirstElement();
            if (object instanceof DomainURI) {
                DomainURI domainURI = (DomainURI)object;
                return domainURI.getUri();
            }
            return null;
        }

        public void run() {
            try {
                URI uri = this.getURI();
                if (uri == null) {
                    return;
                }
                IEditorPart part = EditorHelper.openEditor((URI)uri);
                if (part != null && part instanceof IEditingDomainProvider) {
                    EditorHelper.setSelectionToViewer((IEditorPart)part, (URI)uri);
                }
            }
            catch (PartInitException pie) {
                EGFModelEditorPlugin.getPlugin().logError(pie);
            }
        }
    }
}

