/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.ftask.producer.internal.invocation;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egf.common.helper.BundleHelper;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.l10n.EGFCoreMessages;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.ftask.producer.invocation.ITaskJavaProductionInvocation;
import org.eclipse.egf.ftask.producer.invocation.ITaskProduction;
import org.eclipse.egf.model.ftask.TaskJava;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class TaskJavaProductionInvocation
implements ITaskJavaProductionInvocation {
    private Bundle _bundle;
    private ITaskProductionContext _productionContext;
    private TaskJava _taskJava;

    public TaskJavaProductionInvocation(Bundle bundle, ITaskProductionContext productionContext, TaskJava taskJava) {
        Assert.isNotNull((Object)bundle);
        Assert.isNotNull((Object)productionContext);
        this._bundle = bundle;
        this._productionContext = productionContext;
        this._taskJava = taskJava;
    }

    protected ITaskProduction createProductionInvocationInstance() throws CoreException {
        ITaskProduction productionTask = null;
        if (this._taskJava == null || this._taskJava.getValue() == null || this._taskJava.getValue().trim().length() == 0) {
            return null;
        }
        try {
            productionTask = (ITaskProduction)BundleHelper.instantiate((String)this._taskJava.getValue().trim(), (Bundle)this._bundle);
        }
        catch (ClassNotFoundException cnfe) {
            throw new CoreException(EGFCorePlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.AbstractTask_errorTaskInstance, (Object)this._taskJava.getValue()), (Throwable)cnfe));
        }
        catch (InstantiationException ie) {
            throw new CoreException(EGFCorePlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.AbstractTask_errorTaskInstance, (Object)this._taskJava.getValue()), (Throwable)ie));
        }
        catch (IllegalAccessException iae) {
            throw new CoreException(EGFCorePlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.AbstractTask_errorTaskInstance, (Object)this._taskJava.getValue()), (Throwable)iae));
        }
        return productionTask;
    }

    public void invoke(IProgressMonitor monitor) throws InvocationException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)EGFCoreMessages.Production_Invoke, (Object)this._taskJava.getName()), (int)1000);
        ITaskProduction task = null;
        try {
            task = this.createProductionInvocationInstance();
        }
        catch (CoreException ce) {
            throw new InvocationException((Throwable)ce);
        }
        if (task == null) {
            return;
        }
        subMonitor.worked(100);
        if (subMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        task.preExecute(this._productionContext, (IProgressMonitor)subMonitor.newChild(100, 0));
        subMonitor.worked(100);
        if (subMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        task.doExecute(this._productionContext, (IProgressMonitor)subMonitor.newChild(700, 0));
        subMonitor.worked(700);
        if (subMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        task.postExecute(this._productionContext, (IProgressMonitor)subMonitor.newChild(100, 0));
        subMonitor.worked(100);
        if (subMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }
}

