/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.producer.internal.context;

import java.util.Collection;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.core.producer.context.IProductionContext;
import org.eclipse.egf.core.producer.context.ProductionContext;
import org.eclipse.egf.core.producer.l10n.CoreProducerMessages;
import org.eclipse.egf.core.session.ProjectBundleSession;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fcore.Contract;
import org.eclipse.egf.model.fcore.Invocation;
import org.eclipse.egf.model.fcore.InvocationContract;
import org.eclipse.egf.producer.context.IActivityProductionContext;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ActivityProductionContext<P extends Activity>
extends ProductionContext<P, Contract>
implements IActivityProductionContext<P> {
    public ActivityProductionContext(ProjectBundleSession projectBundleSession, P element, String name) {
        super(projectBundleSession, element, name);
    }

    public <T extends Invocation> ActivityProductionContext(IProductionContext<T, InvocationContract> parent, ProjectBundleSession projectBundleSession, P element, String name) {
        super(parent, projectBundleSession, element, name);
    }

    public boolean isSetAtRuntime(Object key) throws InvocationException {
        Contract contract = this.getContract(key, this.getInputValueKeys());
        if (contract == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_unknown_name, (Object)((String)key).trim(), (Object)this.getName()));
        }
        if (this.getParent() != null) {
            return this.getParent().isSetAtRuntime((Object)contract);
        }
        return false;
    }

    public Class<?> getInputValueType(Object key) throws InvocationException {
        Contract contract = this.getContract(key, this.getInputValueKeys());
        if (contract == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_unknown_name, (Object)((String)key).trim(), (Object)this.getName()));
        }
        return super.getInputValueType((Object)contract);
    }

    public <R> R getInputValue(Object key, Class<R> clazz) throws InvocationException {
        Contract contract = this.getContract(key, this.getInputValueKeys());
        if (contract == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_unknown_name, (Object)((String)key).trim(), (Object)this.getName()));
        }
        return (R)super.getInputValue((Object)contract, clazz);
    }

    public Class<?> getOutputValueType(Object key) throws InvocationException {
        Contract contract = this.getContract(key, this.getOutputValueKeys());
        if (contract == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_unknown_name, (Object)((String)key).trim(), (Object)this.getName()));
        }
        return super.getOutputValueType((Object)contract);
    }

    public <R> R getOutputValue(Object key, Class<R> clazz) throws InvocationException {
        Contract contract = this.getContract(key, this.getOutputValueKeys());
        if (contract == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_unknown_name, (Object)((String)key).trim(), (Object)this.getName()));
        }
        return (R)super.getOutputValue((Object)contract, clazz);
    }

    public void setOutputValue(Object key, Object value) throws InvocationException {
        Contract contract = this.getContract(key, this.getOutputValueKeys());
        if (contract == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_unknown_name, (Object)((String)key).trim(), (Object)this.getName()));
        }
        super.setOutputValue((Object)contract, value);
    }

    private Contract getContract(Object key, Collection<Contract> keys) throws InvocationException {
        if (key == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_null_name, (Object)this.getName()));
        }
        if (!(key instanceof String)) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_wrong_type, (Object[])new Object[]{String.class.getName(), EMFHelper.getText((Object)key), key.getClass().getName(), this.getName()}));
        }
        String innerName = ((String)key).trim();
        if (innerName.length() == 0) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_emtpy_name, (Object)this.getName()));
        }
        Contract contract = null;
        for (Contract innerContract : keys) {
            if (!innerName.equals(innerContract.getName())) continue;
            contract = innerContract;
            break;
        }
        if (contract == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_unknown_name, (Object)innerName, (Object)this.getName()));
        }
        return contract;
    }
}

