/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.engine;

import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternElement;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.pattern.Messages;
import org.eclipse.egf.pattern.engine.PatternHelper;

public abstract class PatternEngine {
    private final Pattern pattern;
    private final String bundleId;

    public PatternEngine(Pattern pattern) throws PatternException {
        this.pattern = pattern;
        this.bundleId = PatternHelper.getPlatformFcore((PatternElement)pattern).getPlatformBundle().getBundleId();
        if (this.bundleId == null) {
            throw new PatternException(Messages.classloader_error4);
        }
    }

    public abstract void executeWithInjection(PatternContext var1, Object ... var2) throws PatternException;

    public abstract void execute(PatternContext var1) throws PatternException;

    public abstract void translate() throws PatternException;

    protected Pattern getPattern() {
        return this.pattern;
    }

    protected String getBundleId() {
        return this.bundleId;
    }
}

