/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.css.cssext.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRule;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRuleDefinition;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CssExtension;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.Definition;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.ElementDefinition;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.PackageDefinition;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.PropertyDefinition;

public class SearchHelper {
    private Set<CssExtension> model;

    public SearchHelper(Set<CssExtension> model) {
        this.model = model;
    }

    public SearchHelper(CssExtension model) {
        this.model = new HashSet<CssExtension>();
        this.model.add(model);
    }

    public SearchHelper(Collection<CssExtension> model) {
        this.model = new HashSet<CssExtension>(model);
    }

    public List<PropertyDefinition> findPropertiesByFilter(PropertyDefinitionFilter filter) {
        ArrayList<PropertyDefinition> result = new ArrayList<PropertyDefinition>();
        for (CssExtension e : this.model) {
            this.recFindProperties((EObject)e, result, filter);
        }
        return result;
    }

    private void recFindProperties(EObject obj, List<PropertyDefinition> result, PropertyDefinitionFilter filter) {
        if (filter.returnOnFirstHit() && !result.isEmpty()) {
            return;
        }
        if (obj instanceof CssExtension) {
            CssExtension e = (CssExtension)obj;
            this.recFindProperties((EObject)e.getPackageDef(), result, filter);
        } else if (obj instanceof PackageDefinition) {
            PackageDefinition pkg = (PackageDefinition)obj;
            for (ElementDefinition el : pkg.getElements()) {
                for (Definition d : el.getProperties()) {
                    PropertyDefinition prop = (PropertyDefinition)d;
                    if (!filter.filter(prop)) continue;
                    result.add(prop);
                    if (!filter.returnOnFirstHit()) continue;
                    return;
                }
            }
            for (PackageDefinition subPkg : pkg.getSubpackages()) {
                this.recFindProperties((EObject)subPkg, result, filter);
            }
        }
    }

    public <T extends EObject> List<T> findObjects(SearchFilter<T> filter) {
        ArrayList result = new ArrayList();
        for (CssExtension e : this.model) {
            this.recFindObjects((EObject)e, result, filter);
        }
        return result;
    }

    public <T extends EObject> void recFindObjects(EObject curr, List<T> result, SearchFilter<T> filter) {
        if (filter.returnOnFirstHit() && !result.isEmpty()) {
            return;
        }
        if (filter.getSearchClass().isAssignableFrom(curr.getClass()) && filter.filter(curr)) {
            result.add(curr);
        }
        if (curr instanceof CssExtension) {
            CssExtension e = (CssExtension)curr;
            this.recFindObjects((EObject)e.getPackageDef(), result, filter);
        } else if (curr instanceof PackageDefinition) {
            PackageDefinition pkg = (PackageDefinition)curr;
            for (Definition def : pkg.getRules()) {
                this.recFindObjects((EObject)((CSSRuleDefinition)def), result, filter);
            }
            for (ElementDefinition el : pkg.getElements()) {
                this.recFindObjects((EObject)el, result, filter);
            }
            for (PackageDefinition subPkg : pkg.getSubpackages()) {
                this.recFindObjects((EObject)subPkg, result, filter);
            }
        }
    }

    public static interface ElementDefinitionFilter {
        public boolean filter(ElementDefinition var1);

        public boolean returnOnFirstHit();
    }

    public static interface PropertyDefinitionFilter {
        public boolean filter(PropertyDefinition var1);

        public boolean returnOnFirstHit();
    }

    public static interface RuleFilter {
        public boolean filter(CSSRule var1);

        public boolean returnOnFirstHit();
    }

    public static interface SearchFilter<T extends EObject> {
        public Class<T> getSearchClass();

        public boolean filter(T var1);

        public boolean returnOnFirstHit();
    }
}

