/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.jdt.ui.internal.editors;

import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.databinding.edit.IEMFEditValueProperty;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.fx.ide.jdt.ui.internal.editors.AddDialog;
import org.eclipse.fx.ide.jdt.ui.internal.editors.model.anttasks.AntTask;
import org.eclipse.fx.ide.jdt.ui.internal.editors.model.anttasks.parameters.KeyValuePair;
import org.eclipse.fx.ide.jdt.ui.internal.editors.model.anttasks.parameters.ParametersFactory;
import org.eclipse.fx.ide.jdt.ui.internal.editors.model.anttasks.parameters.ParametersPackage;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

public class AddFontDialog
extends AddDialog<KeyValuePair> {
    private KeyValuePair o;
    private Text tFontName;
    private Text tFile;
    private final EditingDomain editingDomain;
    private final AntTask task;
    private final IContainer resourceContainer;

    public AddFontDialog(Shell parentShell, EditingDomain editingDomain, AntTask task, IContainer resourceContainer) {
        super(parentShell);
        this.editingDomain = editingDomain;
        this.task = task;
        this.resourceContainer = resourceContainer;
    }

    @Override
    protected Control createDialogContent(Composite parent) {
        this.o = ParametersFactory.eINSTANCE.createKeyValuePair();
        Composite area = new Composite(parent, 0);
        area.setLayout((Layout)new GridLayout(1, false));
        area.setLayoutData((Object)new GridData(1808));
        this.getShell().setText("Add font ");
        this.setTitle("Add font");
        this.setMessage("Enter informations about the font to add");
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setLayoutData((Object)new GridData(1808));
        IWidgetValueProperty tProp = WidgetProperties.text((int)24);
        Label l = new Label(container, 0);
        l.setText("Font name*:");
        this.tFontName = new Text(container, 2048);
        GridData tFontGD = new GridData(768);
        tFontGD.horizontalSpan = 2;
        this.tFontName.setLayoutData((Object)tFontGD);
        IEMFEditValueProperty prop = EMFEditProperties.value((EditingDomain)this.editingDomain, (EStructuralFeature)ParametersPackage.Literals.KEY_VALUE_PAIR__KEY);
        this.dbContext.bindValue((IObservableValue)tProp.observeDelayed(500, (Widget)this.tFontName), prop.observe((Object)this.o), (UpdateValueStrategy)new EMFUpdateValueStrategy(EMFUpdateValueStrategy.POLICY_ON_REQUEST), (UpdateValueStrategy)new EMFUpdateValueStrategy());
        l = new Label(container, 0);
        l.setText("File*:");
        this.tFile = new Text(container, 2048);
        this.tFile.setLayoutData((Object)new GridData(768));
        this.tFile.setEditable(false);
        IEMFEditValueProperty prop2 = EMFEditProperties.value((EditingDomain)this.editingDomain, (EStructuralFeature)ParametersPackage.Literals.KEY_VALUE_PAIR__VALUE);
        this.dbContext.bindValue((IObservableValue)tProp.observeDelayed(500, (Widget)this.tFile), prop2.observe((Object)this.o), (UpdateValueStrategy)new EMFUpdateValueStrategy(EMFUpdateValueStrategy.POLICY_ON_REQUEST), (UpdateValueStrategy)new EMFUpdateValueStrategy());
        Button b = new Button(container, 0);
        b.setText("Browse ...");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] rv;
                FilteredResourcesSelectionDialog d = new FilteredResourcesSelectionDialog(AddFontDialog.this.getShell(), false, AddFontDialog.this.resourceContainer, 1){

                    protected IStatus validateItem(Object item) {
                        IFile f = (IFile)item;
                        if (f.getParent() instanceof IProject) {
                            return new Status(4, "org.eclipse.fx.ide.jdt.ui", "The selected resource has to be part of the source folder");
                        }
                        if (!f.getName().endsWith(".ttf")) {
                            return new Status(4, "org.eclipse.fx.ide.jdt.ui", "The selected resource does not seem to be a font");
                        }
                        return super.validateItem(item);
                    }
                };
                if (d.open() == 0 && (rv = d.getResult()).length == 1) {
                    IFile f = (IFile)rv[0];
                    IJavaElement j = JavaCore.create((IResource)f.getParent());
                    if (j instanceof IPackageFragment) {
                        IPackageFragment p = (IPackageFragment)j;
                        AddFontDialog.this.tFile.setText(String.valueOf(p.getElementName().replace('.', '/')) + "/" + f.getName());
                    } else if (j instanceof IPackageFragmentRoot) {
                        IPackageFragmentRoot cfr_ignored_0 = (IPackageFragmentRoot)j;
                        AddFontDialog.this.tFile.setText(f.getName());
                    } else {
                        MessageDialog.openInformation((Shell)AddFontDialog.this.getShell(), (String)"Not valid", (String)"The selected resource has to be part of the source folder");
                    }
                }
            }
        });
        return area;
    }

    @Override
    protected Command generateOkCommand() {
        return new AddCommand(this.editingDomain, this.task.getFonts(), (Object)this.o);
    }

    @Override
    protected IStatus validate() {
        Status status = this.tFontName.getText() == null || this.tFontName.getText().trim().equals("") ? new Status(4, "org.eclipse.fx.ide.jdt.ui", "Please enter a folder") : (this.tFile.getText() == null || this.tFile.getText().trim().equals("") ? new Status(4, "org.eclipse.fx.ide.jdt.ui", "Please enter a file") : new Status(0, "org.eclipse.fx.ide.jdt.ui", "OK"));
        return status;
    }

    @Override
    protected KeyValuePair getObject() {
        return this.o;
    }
}

