/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.model.internal;

import org.eclipse.fx.ide.model.FXPlugin;
import org.eclipse.fx.ide.model.IFXCtrlField;
import org.eclipse.fx.ide.model.Visibility;
import org.eclipse.fx.ide.model.internal.FXCtrlClass;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class FXCtrlField
implements IFXCtrlField {
    private FXCtrlClass clazz;
    private IField field;
    private String erasedTypeSig;

    public FXCtrlField(FXCtrlClass clazz, IField field, String erasedTypeSig) {
        this.clazz = clazz;
        this.field = field;
        this.erasedTypeSig = erasedTypeSig;
    }

    @Override
    public IJavaElement getJavaElement() {
        return this.field;
    }

    @Override
    public String getName() {
        return this.field.getElementName();
    }

    @Override
    public IType getType() {
        try {
            return this.clazz.getJavaProject().findType(this.erasedTypeSig);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Visibility getVisibility() {
        try {
            int flags = this.field.getFlags();
            if (Flags.isPublic((int)flags)) {
                return Visibility.PUBLIC;
            }
            if (Flags.isPackageDefault((int)flags)) {
                return Visibility.PACKAGE;
            }
            if (Flags.isProtected((int)flags)) {
                return Visibility.PROTECTED;
            }
            return Visibility.PRIVATE;
        }
        catch (JavaModelException e) {
            FXPlugin.getLogger().log(1, "Unable to retrieve visibility for field '" + this.field + "'", (Throwable)e);
            return Visibility.PRIVATE;
        }
    }
}

