/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.EObjectDiagnosticImpl;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.scoping.batch.IIdentifiableElementDescription;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceFlags;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputationArgument;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputer;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.CandidateCompareResult;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.typesystem.util.PendingLinkingCandidateResolver;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterByConstraintSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

public abstract class AbstractPendingLinkingCandidate<Expression extends XExpression>
extends AbstractLinkingCandidate<Expression> {
    private final PendingLinkingCandidateResolver<Expression> pendingLinkingCandidateResolver;
    protected final IIdentifiableElementDescription description;
    private Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> typeParameterMapping;

    protected AbstractPendingLinkingCandidate(Expression expression, IIdentifiableElementDescription description, ITypeExpectation expectation, ExpressionTypeComputationState state) {
        this(expression, description, expectation, state, new PendingLinkingCandidateResolver<Expression>(expression));
    }

    protected AbstractPendingLinkingCandidate(Expression expression, IIdentifiableElementDescription description, ITypeExpectation expectation, ExpressionTypeComputationState state, PendingLinkingCandidateResolver<Expression> pendingLinkingCandidateResolver) {
        super(expression, expectation, state);
        this.description = description;
        this.pendingLinkingCandidateResolver = pendingLinkingCandidateResolver;
    }

    @Override
    protected Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> getTypeParameterMapping() {
        if (this.typeParameterMapping == null) {
            this.typeParameterMapping = this.initializeTypeParameterMapping();
        }
        return this.typeParameterMapping;
    }

    protected abstract String getFeatureTypeName();

    protected String getArgumentTypesAsString() {
        if (!this.getArguments().isEmpty()) {
            StringBuilder b = new StringBuilder();
            b.append("(");
            for (int i = 0; i < this.getArguments().size(); ++i) {
                LightweightTypeReference actualType = this.getActualType(this.getArguments().get(i));
                if (actualType != null) {
                    b.append(actualType.getHumanReadableName());
                } else {
                    b.append("null");
                }
                if (i >= this.getArguments().size() - 1) continue;
                b.append(",");
            }
            b.append(")");
            return b.toString();
        }
        return "";
    }

    protected String getFeatureParameterTypesAsString() {
        if (this.getFeature() instanceof JvmExecutable) {
            return this.getFeatureParameterTypesAsString((JvmExecutable)this.getFeature());
        }
        return "";
    }

    protected String getFeatureParameterTypesAsString(JvmExecutable executable) {
        ITypeReferenceOwner referenceOwner = this.getState().getReferenceOwner();
        EList parameters = executable.getParameters();
        StringBuilder b = new StringBuilder();
        b.append("(");
        for (int i = 0; i < parameters.size(); ++i) {
            JvmTypeReference parameterType = ((JvmFormalParameter)parameters.get(i)).getParameterType();
            LightweightTypeReference typeReference = referenceOwner.toLightweightTypeReference(parameterType);
            b.append(typeReference.getHumanReadableName());
            if (i >= parameters.size() - 1) continue;
            b.append(", ");
        }
        b.append(")");
        return b.toString();
    }

    protected String getFeatureTypeParametersAsString(boolean showBounds) {
        List<JvmTypeParameter> typeParameters = this.getDeclaredTypeParameters();
        if (!typeParameters.isEmpty()) {
            StringBuilder b = new StringBuilder();
            b.append("<");
            for (int i = 0; i < typeParameters.size(); ++i) {
                JvmTypeParameter typeParameter = typeParameters.get(i);
                if (showBounds) {
                    b.append(this.getTypeParameterAsString(typeParameter));
                } else {
                    b.append(typeParameter.getSimpleName());
                }
                if (i >= typeParameters.size() - 1) continue;
                b.append(", ");
            }
            b.append(">");
            return b.toString();
        }
        return "";
    }

    protected String getTypeParameterAsString(JvmTypeParameter typeParameter) {
        StringBuilder b = new StringBuilder();
        b.append(typeParameter.getName());
        ITypeReferenceOwner referenceOwner = this.getState().getReferenceOwner();
        if (!typeParameter.getConstraints().isEmpty()) {
            for (int j = 0; j < typeParameter.getConstraints().size(); ++j) {
                JvmTypeConstraint constraint = (JvmTypeConstraint)typeParameter.getConstraints().get(j);
                LightweightTypeReference typeRef = referenceOwner.toLightweightTypeReference(constraint.getTypeReference());
                if (constraint instanceof JvmUpperBound) {
                    if (typeRef.isType(Object.class)) continue;
                    b.append(" extends ");
                } else {
                    b.append(" super ");
                }
                b.append(typeRef.getHumanReadableName());
            }
        }
        return b.toString();
    }

    protected String getTypeArgumentsAsString(List<? extends LightweightTypeReference> typeArguments) {
        if (!typeArguments.isEmpty()) {
            StringBuilder b = new StringBuilder();
            b.append("<");
            for (int i = 0; i < typeArguments.size(); ++i) {
                b.append(typeArguments.get(i).getHumanReadableName());
                if (i >= typeArguments.size() - 1) continue;
                b.append(", ");
            }
            b.append(">");
            return b.toString();
        }
        return "";
    }

    @Override
    public boolean validate(IAcceptor<? super AbstractDiagnostic> result) {
        if (!this.validateVisibility(result)) {
            return false;
        }
        if (!this.validateArity(result)) {
            return false;
        }
        if (!this.validateTypeArity(result)) {
            return false;
        }
        if (!this.validateTypeArgumentConformance(result)) {
            return false;
        }
        return this.validateUnhandledExceptions(result);
    }

    protected boolean validateVisibility(IAcceptor<? super AbstractDiagnostic> result) {
        if (!this.isVisible()) {
            String message = String.format("The %1$s %2$s%3$s is not visible", this.getFeatureTypeName(), this.getSimpleFeatureName(), this.getFeatureParameterTypesAsString());
            EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.invisible_feature", message, this.getExpression(), (EStructuralFeature)this.getDefaultValidationFeature(), -1, null);
            result.accept((Object)diagnostic);
            return false;
        }
        return true;
    }

    protected String getSimpleFeatureName() {
        return this.getFeature().getSimpleName();
    }

    protected EReference getDefaultValidationFeature() {
        return XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE;
    }

    protected EReference getInvalidArgumentsValidationFeature() {
        return XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE;
    }

    protected boolean validateArity(IAcceptor<? super AbstractDiagnostic> result) {
        if (this.getArityMismatch() != 0) {
            String message = this.getArguments().isEmpty() ? String.format("Invalid number of arguments. The %1$s %2$s%3$s is not applicable without arguments", this.getFeatureTypeName(), this.getSimpleFeatureName(), this.getFeatureParameterTypesAsString()) : String.format("Invalid number of arguments. The %1$s %2$s%3$s is not applicable for the arguments %4$s", this.getFeatureTypeName(), this.getSimpleFeatureName(), this.getFeatureParameterTypesAsString(), this.getArgumentTypesAsString());
            EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_number_of_arguments", message, this.getExpression(), (EStructuralFeature)this.getInvalidArgumentsValidationFeature(), -1, null);
            result.accept((Object)diagnostic);
            return false;
        }
        return true;
    }

    protected boolean validateTypeArity(IAcceptor<? super AbstractDiagnostic> result) {
        if (this.getTypeArityMismatch() != 0) {
            String message = String.format("Invalid number of type arguments. The %1$s %2$s%3$s is not applicable for the type arguments %4$s", this.getFeatureTypeName(), this.getSimpleFeatureName(), this.getFeatureTypeParametersAsString(true), this.getTypeArgumentsAsString(this.getSyntacticTypeArguments()));
            EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_number_of_type_arguments", message, this.getExpression(), (EStructuralFeature)this.getDefaultValidationFeature(), -1, null);
            result.accept((Object)diagnostic);
            return false;
        }
        return true;
    }

    protected boolean validateTypeArgumentConformance(IAcceptor<? super AbstractDiagnostic> result) {
        if (this.getTypeArgumentConformanceFailures(result) == 0) {
            List<XExpression> arguments = this.getSyntacticArguments();
            for (int i = 0; i < arguments.size(); ++i) {
                XExpression argument = arguments.get(i);
                if (!this.isDefiniteEarlyExit(argument)) continue;
                Object errorOn = this.getExpression();
                String message = "Unreachable code.";
                EReference errorFeature = null;
                if (i < arguments.size() - 1) {
                    errorOn = arguments.get(i + 1);
                } else {
                    errorFeature = this.getDefaultValidationFeature();
                    message = errorOn instanceof XBinaryOperation ? "Unreachable code. The right argument expression does not complete normally." : "Unreachable code. The last argument expression does not complete normally.";
                }
                EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_code", message, errorOn, (EStructuralFeature)errorFeature, -1, null);
                result.accept((Object)diagnostic);
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    protected boolean validateUnhandledExceptions(IAcceptor<? super AbstractDiagnostic> result) {
        JvmExecutable executable;
        if (this.getFeature() instanceof JvmExecutable && this.getUnhandledExceptionSeverity(executable = (JvmExecutable)this.getFeature()) != Severity.IGNORE && !executable.getExceptions().isEmpty()) {
            return this.validateUnhandledExceptions(executable, result);
        }
        return true;
    }

    protected boolean validateUnhandledExceptions(JvmExecutable executable, IAcceptor<? super AbstractDiagnostic> result) {
        TypeParameterSubstitutor<?> substitutor = this.createArgumentTypeSubstitutor();
        List unhandledExceptions = null;
        List<LightweightTypeReference> expectedExceptions = this.getState().getExpectedExceptions();
        ITypeReferenceOwner referenceOwner = this.getState().getReferenceOwner();
        block0: for (JvmTypeReference typeReference : executable.getExceptions()) {
            LightweightTypeReference exception = referenceOwner.toLightweightTypeReference(typeReference);
            LightweightTypeReference resolvedException = substitutor.substitute(exception);
            if (!resolvedException.isSubtypeOf(Throwable.class) || resolvedException.isSubtypeOf(RuntimeException.class) || resolvedException.isSubtypeOf(Error.class)) continue;
            for (LightweightTypeReference expectedException : expectedExceptions) {
                if (!expectedException.isAssignableFrom(resolvedException)) continue;
                continue block0;
            }
            if (unhandledExceptions == null) {
                unhandledExceptions = Lists.newArrayList((Object[])new LightweightTypeReference[]{resolvedException});
                continue;
            }
            unhandledExceptions.add(resolvedException);
        }
        if (unhandledExceptions != null) {
            String message = null;
            int count = unhandledExceptions.size();
            message = count > 1 ? String.format("Unhandled exception types %s and %s", IterableExtensions.join(unhandledExceptions.subList(0, count - 1), (CharSequence)", "), unhandledExceptions.get(count - 1)) : String.format("Unhandled exception type %s", ((LightweightTypeReference)unhandledExceptions.get(0)).getHumanReadableName());
            String[] data = new String[unhandledExceptions.size() + 1];
            for (int i = 0; i < data.length - 1; ++i) {
                LightweightTypeReference unhandled = (LightweightTypeReference)unhandledExceptions.get(i);
                data[i] = EcoreUtil.getURI((EObject)unhandled.getType()).toString();
            }
            data[data.length - 1] = EcoreUtil.getURI(this.getExpression()).toString();
            EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(this.getUnhandledExceptionSeverity(executable), "org.eclipse.xtext.xbase.validation.IssueCodes.unhandled_exception", message, this.getExpression(), (EStructuralFeature)this.getDefaultValidationFeature(), -1, data);
            result.accept((Object)diagnostic);
            return false;
        }
        return true;
    }

    protected Severity getUnhandledExceptionSeverity(JvmExecutable executable) {
        return this.getSeverity("org.eclipse.xtext.xbase.validation.IssueCodes.unhandled_exception");
    }

    protected Severity getSeverity(String issueCode) {
        return this.getState().getSeverity(issueCode);
    }

    protected boolean isDefiniteEarlyExit(XExpression expression) {
        CommonTypeComputationServices services = this.getState().getReferenceOwner().getServices();
        return services.getEarlyExitComputer().isDefiniteEarlyExit(expression);
    }

    protected List<XExpression> getSyntacticArguments() {
        return this.getArguments();
    }

    @Override
    public ILinkingCandidate getPreferredCandidate(ILinkingCandidate other) {
        if (other instanceof AbstractPendingLinkingCandidate) {
            AbstractPendingLinkingCandidate right = (AbstractPendingLinkingCandidate)other;
            CandidateCompareResult candidateCompareResult = this.compareTo(right);
            switch (candidateCompareResult) {
                case AMBIGUOUS: {
                    return this.createAmbiguousLinkingCandidate(right);
                }
                case SUSPICIOUS_OTHER: {
                    return this.createSuspiciousLinkingCandidate(right);
                }
                case EQUALLY_INVALID: 
                case THIS: {
                    return this;
                }
                case OTHER: {
                    return other;
                }
            }
        }
        throw new IllegalArgumentException("other was " + other);
    }

    protected abstract ILinkingCandidate createAmbiguousLinkingCandidate(AbstractPendingLinkingCandidate<?> var1);

    protected ILinkingCandidate createSuspiciousLinkingCandidate(AbstractPendingLinkingCandidate<?> chosenCandidate) {
        throw new UnsupportedOperationException();
    }

    protected final CandidateCompareResult compareTo(AbstractPendingLinkingCandidate<?> right) {
        return this.compareTo(right, false);
    }

    protected CandidateCompareResult compareTo(AbstractPendingLinkingCandidate<?> right, boolean invalid) {
        CandidateCompareResult arityCompareResult = this.compareByArityWith(right);
        switch (arityCompareResult) {
            case SUSPICIOUS_OTHER: {
                throw new IllegalStateException();
            }
            case EQUALLY_INVALID: {
                invalid = true;
                break;
            }
            case THIS: 
            case OTHER: {
                return arityCompareResult;
            }
        }
        boolean visible = this.isVisible();
        if (visible != right.isVisible()) {
            if (visible) {
                return CandidateCompareResult.THIS;
            }
            return CandidateCompareResult.OTHER;
        }
        if (!visible) {
            invalid = true;
        }
        CandidateCompareResult typeArityCompareResult = this.compareByArity(this.getTypeArityMismatch(), right.getTypeArityMismatch());
        switch (typeArityCompareResult) {
            case SUSPICIOUS_OTHER: {
                throw new IllegalStateException();
            }
            case EQUALLY_INVALID: {
                invalid = true;
                break;
            }
            case THIS: 
            case OTHER: {
                return typeArityCompareResult;
            }
        }
        CandidateCompareResult nameCompareResult = this.compareByName(right);
        switch (nameCompareResult) {
            case SUSPICIOUS_OTHER: {
                throw new IllegalStateException();
            }
            case EQUALLY_INVALID: {
                invalid = true;
                break;
            }
            case THIS: 
            case OTHER: {
                return nameCompareResult;
            }
        }
        CandidateCompareResult argumentTypeCompareResult = this.compareByArgumentTypes(right);
        switch (argumentTypeCompareResult) {
            case EQUALLY_INVALID: {
                invalid = true;
                break;
            }
            case SUSPICIOUS_OTHER: 
            case THIS: 
            case OTHER: {
                return argumentTypeCompareResult;
            }
        }
        CandidateCompareResult typeArgumentCompareResult = this.compareByTypeArguments(right);
        switch (typeArgumentCompareResult) {
            case SUSPICIOUS_OTHER: {
                throw new IllegalStateException();
            }
            case EQUALLY_INVALID: {
                invalid = true;
                break;
            }
            case THIS: 
            case OTHER: {
                return typeArgumentCompareResult;
            }
        }
        if (this.isVarArgs() != right.isVarArgs()) {
            if (this.isVarArgs()) {
                return CandidateCompareResult.OTHER;
            }
            return CandidateCompareResult.THIS;
        }
        if (this.getExpression() instanceof XMemberFeatureCall && !this.getFeature().getSimpleName().equals(right.getFeature().getSimpleName())) {
            if (this.isTypeLiteral() && !right.isTypeLiteral()) {
                return CandidateCompareResult.THIS;
            }
            if (right.isTypeLiteral() && !this.isTypeLiteral()) {
                return CandidateCompareResult.OTHER;
            }
        }
        if (this.isTypeLiteral() && !right.isTypeLiteral()) {
            return CandidateCompareResult.OTHER;
        }
        CandidateCompareResult bucketCompareResult = this.compareByBucket(right);
        switch (bucketCompareResult) {
            case SUSPICIOUS_OTHER: {
                throw new IllegalStateException();
            }
            case EQUALLY_INVALID: {
                invalid = true;
                break;
            }
            case THIS: 
            case OTHER: {
                return bucketCompareResult;
            }
        }
        if (invalid) {
            return CandidateCompareResult.EQUALLY_INVALID;
        }
        return CandidateCompareResult.AMBIGUOUS;
    }

    protected CandidateCompareResult compareByName(AbstractPendingLinkingCandidate<?> right) {
        return CandidateCompareResult.AMBIGUOUS;
    }

    protected CandidateCompareResult compareByBucket(AbstractPendingLinkingCandidate<?> right) {
        if (this.description.getBucketId() != right.description.getBucketId()) {
            return CandidateCompareResult.THIS;
        }
        return CandidateCompareResult.AMBIGUOUS;
    }

    protected boolean isVisible() {
        return this.description.isVisible();
    }

    protected boolean isVarArgs() {
        return this.getFeature() instanceof JvmExecutable && ((JvmExecutable)this.getFeature()).isVarArgs();
    }

    protected boolean isExtension() {
        return false;
    }

    protected CandidateCompareResult compareByArgumentTypes(AbstractPendingLinkingCandidate<?> right) {
        this.initializeArgumentTypeComputation();
        right.initializeArgumentTypeComputation();
        boolean hadIssues = false;
        CandidateCompareResult argumentTypeResult = this.compareByArgumentTypes(right, false);
        switch (argumentTypeResult) {
            case SUSPICIOUS_OTHER: {
                throw new IllegalStateException();
            }
            case EQUALLY_INVALID: {
                hadIssues = true;
                break;
            }
            case THIS: 
            case OTHER: {
                return argumentTypeResult;
            }
        }
        CandidateCompareResult parameterTypeResult = this.compareExpectedArgumentTypes(right);
        switch (parameterTypeResult) {
            case EQUALLY_INVALID: {
                throw new IllegalStateException();
            }
            case SUSPICIOUS_OTHER: {
                if (hadIssues) {
                    return CandidateCompareResult.OTHER;
                }
            }
            case THIS: 
            case OTHER: {
                return parameterTypeResult;
            }
        }
        CandidateCompareResult secondPassArgumentTypes = this.compareByArgumentTypes(right, true);
        if (secondPassArgumentTypes == CandidateCompareResult.SUSPICIOUS_OTHER) {
            throw new IllegalStateException();
        }
        return secondPassArgumentTypes;
    }

    protected CandidateCompareResult compareByTypeArguments(AbstractPendingLinkingCandidate<?> right) {
        this.initializeArgumentTypeComputation();
        right.initializeArgumentTypeComputation();
        int leftFailures = this.getTypeArgumentConformanceFailures(null);
        int rightFailures = right.getTypeArgumentConformanceFailures(null);
        if (leftFailures != rightFailures) {
            if (leftFailures < rightFailures) {
                return CandidateCompareResult.THIS;
            }
            return CandidateCompareResult.OTHER;
        }
        return leftFailures != 0 ? CandidateCompareResult.EQUALLY_INVALID : CandidateCompareResult.AMBIGUOUS;
    }

    protected int getTypeArgumentConformanceFailures(IAcceptor<? super AbstractDiagnostic> acceptor) {
        JvmTypeParameter declaration;
        LightweightTypeReference argument;
        int i;
        List<LightweightTypeReference> typeArguments = this.getTypeArguments();
        List<JvmTypeParameter> typeParameters = this.getDeclaredTypeParameters();
        int max = Math.min(typeArguments.size(), typeParameters.size());
        if (max == 0) {
            return 0;
        }
        int failures = 0;
        TypeParameterByConstraintSubstitutor substitutor = new TypeParameterByConstraintSubstitutor(this.getDeclaratorParameterMapping(), this.getState().getReferenceOwner());
        for (i = 0; i < max; ++i) {
            argument = typeArguments.get(i);
            declaration = typeParameters.get(i);
            substitutor.enhanceMapping(Collections.singletonMap(declaration, new LightweightMergedBoundTypeArgument(argument, VarianceInfo.INVARIANT)));
        }
        for (i = 0; i < max; ++i) {
            argument = typeArguments.get(i);
            declaration = typeParameters.get(i);
            TypeConformanceComputer conformanceComputer = argument.getOwner().getServices().getTypeConformanceComputer();
            if (argument.getType() == declaration) continue;
            ParameterizedTypeReference reference = argument.getOwner().newParameterizedTypeReference((JvmType)declaration);
            for (LightweightTypeReference superType : reference.getSuperTypes()) {
                LightweightTypeReference substitutedSuperType = substitutor.substitute(superType);
                if ((conformanceComputer.isConformant(substitutedSuperType, argument, 12) & 0x200) != 0) continue;
                ++failures;
            }
        }
        if (failures != 0 && acceptor != null) {
            String format = max > 1 ? "Bounds mismatch: The type arguments %1$s are not a valid substitute for the bounded type parameters %2$s of the %3$s %4$s%5$s" : "Bounds mismatch: The type argument %1$s is not a valid substitute for the bounded type parameter %2$s of the %3$s %4$s%5$s";
            String message = String.format(format, this.getTypeArgumentsAsString(typeArguments), this.getFeatureTypeParametersAsString(true), this.getFeatureTypeName(), this.getSimpleFeatureName(), this.getFeatureParameterTypesAsString());
            EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.type_bounds_missmatch", message, this.getExpression(), (EStructuralFeature)this.getDefaultValidationFeature(), -1, null);
            acceptor.accept((Object)diagnostic);
        }
        return failures;
    }

    protected CandidateCompareResult compareByArgumentTypes(AbstractPendingLinkingCandidate<?> right, boolean recompute) {
        int rightIdx;
        int leftBoxing = 0;
        int rightBoxing = 0;
        int leftVarArgs = 0;
        int rightVarArgs = 0;
        int leftDemand = 0;
        int rightDemand = 0;
        int leftUnknown = 0;
        int rightUnknown = 0;
        boolean invalid = false;
        int upTo = Math.max(this.arguments.getArgumentCount(), right.arguments.getArgumentCount());
        int n = rightIdx = right.hasReceiver() ? 0 : -1;
        for (int leftIdx = this.hasReceiver() ? 0 : -1; leftIdx < upTo || rightIdx < upTo; ++leftIdx, ++rightIdx) {
            boolean leftIsPossibleFunctionType = this.isPossibleFunctionType(leftIdx);
            if (leftIsPossibleFunctionType != right.isPossibleFunctionType(rightIdx)) {
                if (leftIsPossibleFunctionType) {
                    return CandidateCompareResult.THIS;
                }
                return CandidateCompareResult.OTHER;
            }
            int leftConformance = this.getConformanceFlags(leftIdx, recompute);
            int rightConformance = right.getConformanceFlags(rightIdx, recompute);
            CandidateCompareResult argumentCompareResult = this.compareByArgumentTypesFlags(right, leftIdx, rightIdx, leftConformance, rightConformance);
            switch (argumentCompareResult) {
                case SUSPICIOUS_OTHER: {
                    throw new IllegalStateException();
                }
                case EQUALLY_INVALID: {
                    invalid = true;
                    break;
                }
                case THIS: 
                case OTHER: {
                    return argumentCompareResult;
                }
            }
            if (leftConformance != rightConformance) {
                if ((leftConformance & 0x80000) != 0) {
                    ++leftVarArgs;
                }
                if ((rightConformance & 0x80000) != 0) {
                    ++rightVarArgs;
                }
                if ((leftConformance & 0x400) != 0) {
                    ++leftDemand;
                }
                if ((rightConformance & 0x400) != 0) {
                    ++rightDemand;
                }
                if ((leftConformance & 0x6000) != 0) {
                    ++leftBoxing;
                }
                if ((rightConformance & 0x6000) != 0) {
                    ++rightBoxing;
                }
                if ((leftConformance & 0x20000) != 0) {
                    ++leftUnknown;
                }
                if ((rightConformance & 0x20000) == 0) continue;
                ++rightUnknown;
                continue;
            }
            if ((leftConformance & 0x20000) == 0) continue;
            ++leftUnknown;
            ++rightUnknown;
        }
        if (this.isExtension() == right.isExtension()) {
            if (this.arguments.hasEmptyTrailingVarArg()) {
                ++leftVarArgs;
            }
            if (right.arguments.hasEmptyTrailingVarArg()) {
                ++rightVarArgs;
            }
        }
        if (leftVarArgs != rightVarArgs) {
            if (leftVarArgs < rightVarArgs) {
                return CandidateCompareResult.THIS;
            }
            return CandidateCompareResult.OTHER;
        }
        CandidateCompareResult result = this.compareByArgumentTypes(right, leftBoxing, rightBoxing, leftDemand, rightDemand);
        switch (result) {
            case AMBIGUOUS: {
                if (invalid) {
                    return CandidateCompareResult.EQUALLY_INVALID;
                }
                if (leftUnknown == 0 && rightUnknown == 0) break;
                if (leftUnknown <= rightUnknown) {
                    return CandidateCompareResult.THIS;
                }
                return CandidateCompareResult.OTHER;
            }
        }
        return result;
    }

    protected CandidateCompareResult compareByArgumentTypesFlags(AbstractPendingLinkingCandidate<?> other, int leftIdx, int rightIdx, int leftConformance, int rightConformance) {
        int flagCompareResult = ConformanceFlags.compareFlags(leftConformance, rightConformance);
        if (flagCompareResult == 0) {
            if ((leftConformance & 0x200) != 0) {
                if (((leftConformance ^ rightConformance) & 0xC0000000) != 0 && this.isLambdaExpression(leftIdx) && other.isLambdaExpression(rightIdx)) {
                    if ((leftConformance & 0x40000000) != 0) {
                        if ((rightConformance & 0x40000000) == 0) {
                            return CandidateCompareResult.THIS;
                        }
                    } else if ((rightConformance & 0x40000000) != 0) {
                        return CandidateCompareResult.OTHER;
                    }
                    if ((leftConformance & rightConformance & 2) != 0) {
                        if ((leftConformance & Integer.MIN_VALUE) != 0) {
                            if ((rightConformance & Integer.MIN_VALUE) == 0) {
                                return CandidateCompareResult.OTHER;
                            }
                        } else if ((rightConformance & Integer.MIN_VALUE) != 0) {
                            return CandidateCompareResult.THIS;
                        }
                    }
                }
                return CandidateCompareResult.AMBIGUOUS;
            }
            return CandidateCompareResult.EQUALLY_INVALID;
        }
        if (flagCompareResult < 0) {
            return CandidateCompareResult.THIS;
        }
        return CandidateCompareResult.OTHER;
    }

    protected CandidateCompareResult compareByArgumentTypes(AbstractPendingLinkingCandidate<?> other, int leftBoxing, int rightBoxing, int leftDemand, int rightDemand) {
        if (leftDemand != rightDemand) {
            if (leftDemand < rightDemand) {
                return CandidateCompareResult.THIS;
            }
            return CandidateCompareResult.OTHER;
        }
        return this.compareByBoxing(leftBoxing, rightBoxing);
    }

    protected CandidateCompareResult compareByBoxing(int leftBoxing, int rightBoxing) {
        if (leftBoxing != rightBoxing) {
            if (leftBoxing < rightBoxing) {
                return CandidateCompareResult.THIS;
            }
            return CandidateCompareResult.OTHER;
        }
        return CandidateCompareResult.AMBIGUOUS;
    }

    protected boolean isPossibleFunctionType(int idx) {
        XExpression argument;
        if (idx < this.arguments.getArgumentCount() && (argument = this.arguments.getArgument(idx)) instanceof XClosure) {
            XClosure closure = (XClosure)argument;
            LightweightTypeReference declaredType = this.arguments.getDeclaredTypeForLambda(idx);
            if (declaredType != null && !declaredType.isType(Object.class)) {
                CommonTypeComputationServices services = this.getState().getReferenceOwner().getServices();
                JvmOperation operation = services.getFunctionTypes().findImplementingOperation(declaredType);
                if (operation == null) {
                    return false;
                }
                if (closure.isExplicitSyntax() && closure.getDeclaredFormalParameters().size() != operation.getParameters().size()) {
                    return false;
                }
            }
        }
        return true;
    }

    protected int getConformanceFlags(int idx, boolean recompute) {
        while (!this.arguments.isProcessed(idx)) {
            this.computeArgumentType(this.arguments.getNextUnprocessedArgumentSlot());
        }
        if (idx >= this.arguments.getArgumentCount()) {
            return 0x100200;
        }
        XExpression argument = this.arguments.getArgument(idx);
        if (argument == null) {
            return 262144;
        }
        return this.getState().getStackedResolvedTypes().getConformanceFlags(argument, recompute);
    }

    protected boolean isLambdaExpression(int argumentIdx) {
        if (argumentIdx >= this.arguments.getArgumentCount()) {
            return false;
        }
        XExpression argument = this.arguments.getArgument(argumentIdx);
        return argument != null && argument instanceof XClosure;
    }

    protected CandidateCompareResult compareExpectedArgumentTypes(AbstractPendingLinkingCandidate<?> right) {
        int rightIdx;
        int result = 0;
        int upTo = Math.max(this.arguments.getArgumentCount(), right.arguments.getArgumentCount());
        int n = rightIdx = right.hasReceiver() ? 0 : -1;
        for (int leftIdx = this.hasReceiver() ? 0 : -1; leftIdx < upTo && rightIdx < upTo; ++leftIdx, ++rightIdx) {
            boolean rightResolved;
            LightweightTypeReference expectedArgumentType = this.getSubstitutedExpectedType(leftIdx);
            LightweightTypeReference rightExpectedArgumentType = right.getSubstitutedExpectedType(rightIdx);
            if (expectedArgumentType == null) {
                if (rightExpectedArgumentType == null) continue;
                return CandidateCompareResult.OTHER;
            }
            if (rightExpectedArgumentType == null) {
                return CandidateCompareResult.THIS;
            }
            boolean leftResolved = expectedArgumentType.isResolved();
            if (!leftResolved) {
                expectedArgumentType = expectedArgumentType.getRawTypeReference();
            }
            if (!(rightResolved = rightExpectedArgumentType.isResolved())) {
                rightExpectedArgumentType = rightExpectedArgumentType.getRawTypeReference();
            }
            result += this.compareDeclaredTypes(expectedArgumentType, rightExpectedArgumentType, leftResolved, rightResolved);
        }
        if (result == 0) {
            if (!this.getDeclaredTypeParameters().isEmpty() || !right.getDeclaredTypeParameters().isEmpty()) {
                return this.compareDeclaredParameterTypes(right);
            }
            return CandidateCompareResult.AMBIGUOUS;
        }
        if (result < 0) {
            return CandidateCompareResult.THIS;
        }
        return this.getExpectedTypeCompareResultOther(right);
    }

    protected int compareDeclaredTypes(LightweightTypeReference left, LightweightTypeReference right, boolean leftResolved, boolean rightResolved) {
        int rightToLeftConformance = left.internalIsAssignableFrom(right, new TypeConformanceComputationArgument());
        if ((rightToLeftConformance & 0x200) != 0) {
            if (!(right.isAssignableFrom(left) || leftResolved && rightResolved && (rightToLeftConformance & 0x8000) != 0)) {
                return 1;
            }
        } else {
            int leftToRightConformance = right.internalIsAssignableFrom(left, new TypeConformanceComputationArgument());
            if (!((leftToRightConformance & 0x200) == 0 || leftResolved && rightResolved && (leftToRightConformance & 0x8000) != 0)) {
                return -1;
            }
        }
        return 0;
    }

    private CandidateCompareResult compareDeclaredParameterTypes(AbstractPendingLinkingCandidate<?> right) {
        if (this.getFeature() instanceof JvmExecutable && right.getFeature() instanceof JvmExecutable) {
            EList parameters = ((JvmExecutable)this.getFeature()).getParameters();
            EList rightParameters = ((JvmExecutable)right.getFeature()).getParameters();
            if (parameters.size() == rightParameters.size()) {
                int result = 0;
                ITypeReferenceOwner leftReferenceOwner = this.getState().getReferenceOwner();
                ITypeReferenceOwner rightReferenceOwner = right.getState().getReferenceOwner();
                TypeParameterByConstraintSubstitutor substitutor = new TypeParameterByConstraintSubstitutor(this.getDeclaratorParameterMapping(), leftReferenceOwner);
                TypeParameterByConstraintSubstitutor rightSubstitutor = new TypeParameterByConstraintSubstitutor(right.getDeclaratorParameterMapping(), right.getState().getReferenceOwner());
                for (int i = 0; i < parameters.size(); ++i) {
                    LightweightTypeReference parameterType = leftReferenceOwner.toLightweightTypeReference(((JvmFormalParameter)parameters.get(i)).getParameterType());
                    LightweightTypeReference rightParameterType = rightReferenceOwner.toLightweightTypeReference(((JvmFormalParameter)rightParameters.get(i)).getParameterType());
                    if (parameterType.isResolved() && rightParameterType.isResolved()) continue;
                    result += this.compareDeclaredTypes(substitutor.substitute(parameterType), rightSubstitutor.substitute(rightParameterType), false, false);
                }
                if (result == 0) {
                    return CandidateCompareResult.AMBIGUOUS;
                }
                if (result < 0) {
                    return CandidateCompareResult.THIS;
                }
                return this.getExpectedTypeCompareResultOther(right);
            }
        }
        return CandidateCompareResult.AMBIGUOUS;
    }

    protected CandidateCompareResult getExpectedTypeCompareResultOther(AbstractPendingLinkingCandidate<?> other) {
        return CandidateCompareResult.OTHER;
    }

    protected CandidateCompareResult compareByArityWith(AbstractPendingLinkingCandidate<?> right) {
        CandidateCompareResult arityCompareResult = this.compareByArity(this.getArityMismatch(), right.getArityMismatch());
        return arityCompareResult;
    }

    protected CandidateCompareResult compareByArity(int leftArityMismatch, int rightArityMismatch) {
        if (leftArityMismatch != rightArityMismatch) {
            if (leftArityMismatch == 0) {
                return CandidateCompareResult.THIS;
            }
            if (rightArityMismatch == 0) {
                return CandidateCompareResult.OTHER;
            }
            if (Math.abs(leftArityMismatch) < Math.abs(rightArityMismatch)) {
                return CandidateCompareResult.THIS;
            }
            if (Math.abs(leftArityMismatch) > Math.abs(rightArityMismatch)) {
                return CandidateCompareResult.OTHER;
            }
            if (leftArityMismatch < 0) {
                return CandidateCompareResult.THIS;
            }
            if (rightArityMismatch < 0) {
                return CandidateCompareResult.OTHER;
            }
        }
        return leftArityMismatch == 0 ? CandidateCompareResult.AMBIGUOUS : CandidateCompareResult.EQUALLY_INVALID;
    }

    public int getArityMismatch() {
        JvmIdentifiableElement identifiable = this.getFeature();
        if (identifiable instanceof JvmExecutable) {
            return this.getArityMismatch((JvmExecutable)identifiable, this.getArguments());
        }
        if (this.getExpression() instanceof XAssignment) {
            return this.getArguments().size() - 1;
        }
        return this.getArguments().size();
    }

    public int getTypeArityMismatch() {
        List<LightweightTypeReference> syntacticTypeArguments = this.getSyntacticTypeArguments();
        if (syntacticTypeArguments.size() == 0) {
            return 0;
        }
        return this.getDeclaredTypeParameters().size() - syntacticTypeArguments.size();
    }

    protected void resolveLinkingProxy(EReference structuralFeature, int featureId) {
        InternalEObject internalView = (InternalEObject)this.getExpression();
        JvmIdentifiableElement newFeature = this.getFeature();
        if (newFeature.eIsProxy()) {
            newFeature = (JvmIdentifiableElement)internalView.eResolveProxy((InternalEObject)newFeature);
        }
        this.pendingLinkingCandidateResolver.resolveLinkingProxy(internalView, newFeature, structuralFeature, featureId);
    }

    protected int getArityMismatch(JvmExecutable executable, List<XExpression> arguments) {
        int fixedArityParamCount = executable.getParameters().size();
        if (executable.isVarArgs() && arguments.size() >= --fixedArityParamCount) {
            return 0;
        }
        return fixedArityParamCount - arguments.size();
    }

    @Override
    public JvmIdentifiableElement getFeature() {
        return this.description.getElementOrProxy();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.description.toString() + "]";
    }
}

