/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.theme.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Scene;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.fx.core.Util;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerFactory;
import org.eclipse.fx.ui.services.theme.Theme;
import org.eclipse.fx.ui.services.theme.ThemeManager;
import org.eclipse.fx.ui.theme.internal.Activator;
import org.eclipse.fx.ui.theme.internal.ReflectiveInvoke;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public class DefaultThemeManager
implements ThemeManager {
    static final String ATT_ID = "id";
    static final String ATT_NAME = "name";
    static final String ATT_THEME_ID = "themeId";
    static final String ATT_BASETYLESHEET = "basestylesheet";
    static final String ATT_RESOURCE = "resource";
    private final List<Theme> themes = new ArrayList<Theme>();
    private String currentThemeId;
    private List<Scene> managedScenes = new ArrayList<Scene>();
    private static Logger LOGGER;

    public DefaultThemeManager() {
        IConfigurationElement e;
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IConfigurationElement[] iConfigurationElementArray = registry.getConfigurationElementsFor("org.eclipse.fx.ui.theme");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            e = iConfigurationElementArray[n2];
            if (e.getName().equals("theme")) {
                this.themes.add(new ThemeImpl(e));
            }
            ++n2;
        }
        iConfigurationElementArray = registry.getConfigurationElementsFor("org.eclipse.fx.ui.theme");
        n = iConfigurationElementArray.length;
        n2 = 0;
        while (n2 < n) {
            e = iConfigurationElementArray[n2];
            if (e.getName().equals("stylesheet")) {
                String themeId = e.getAttribute(ATT_THEME_ID);
                for (Theme t : this.themes) {
                    if (!t.getId().equals(themeId) && themeId != null && !themeId.isEmpty()) continue;
                    ((ThemeImpl)t).addStylesheet(e);
                }
            }
            ++n2;
        }
    }

    public Theme getCurrentTheme() {
        if (this.themes.isEmpty()) {
            return null;
        }
        if (this.themes.size() == 1) {
            return this.themes.get(0);
        }
        String id = this.getCurrentThemeId();
        if (id != null) {
            for (Theme t : this.themes) {
                if (!t.getId().equals(id)) continue;
                return t;
            }
        }
        this.themes.get(0);
        return null;
    }

    public List<Theme> getAvailableThemes() {
        return this.themes;
    }

    public void setCurrentThemeId(String id) {
        for (Theme t : this.themes) {
            if (!t.getId().equals(id)) continue;
            this.currentThemeId = id;
            for (Scene scene : this.managedScenes) {
                List<Theme> availableThemes = this.getAvailableThemes();
                for (Theme theme : availableThemes) {
                    for (URL url : theme.getStylesheetURL()) {
                        scene.getStylesheets().remove((Object)url.toExternalForm());
                    }
                }
                for (Theme theme : availableThemes) {
                    for (URL url : theme.getStylesheetURL()) {
                        if (!theme.getId().equals(this.currentThemeId)) continue;
                        scene.getStylesheets().add((Object)url.toExternalForm());
                    }
                }
                if (!Util.isFX2()) continue;
                try {
                    ReflectiveInvoke.onStyleManagerClass(scene);
                }
                catch (Exception e) {
                    DefaultThemeManager.getLogger().error("Unable to reload styles", (Throwable)e);
                }
            }
            return;
        }
        throw new IllegalArgumentException("Theme with id '" + id + "' is not known.");
    }

    private String getCurrentThemeId() {
        return this.currentThemeId;
    }

    static Logger getLogger() {
        if (LOGGER == null) {
            ServiceReference ref = Activator.getContext().getServiceReference(LoggerFactory.class);
            LOGGER = ((LoggerFactory)Activator.getContext().getService(ref)).createLogger(DefaultThemeManager.class.getName());
        }
        return LOGGER;
    }

    public ThemeManager.Registration registerScene(final Scene scene) {
        this.managedScenes.add(scene);
        return new ThemeManager.Registration(){

            public void dispose() {
                DefaultThemeManager.this.managedScenes.remove(scene);
            }
        };
    }

    static class ThemeImpl
    implements Theme {
        private final IConfigurationElement element;
        private final List<IConfigurationElement> stylesheetElements = new ArrayList<IConfigurationElement>();
        private final List<URL> resolvedUrls = new ArrayList<URL>();

        public ThemeImpl(IConfigurationElement element) {
            this.element = element;
        }

        void addStylesheet(IConfigurationElement stylesheet) {
            this.resolvedUrls.clear();
            this.stylesheetElements.add(stylesheet);
        }

        public String getId() {
            return this.element.getAttribute(DefaultThemeManager.ATT_ID);
        }

        public String getName() {
            return this.element.getAttribute(DefaultThemeManager.ATT_NAME);
        }

        public List<URL> getStylesheetURL() {
            if (this.resolvedUrls.isEmpty()) {
                URL url = this.getUrl(this.element, DefaultThemeManager.ATT_BASETYLESHEET);
                if (url != null) {
                    this.resolvedUrls.add(url);
                } else {
                    DefaultThemeManager.getLogger().error("Unable to load base stylesheet '" + this.element.getAttribute(DefaultThemeManager.ATT_BASETYLESHEET) + "'");
                }
                for (IConfigurationElement e : this.stylesheetElements) {
                    url = this.getUrl(e, DefaultThemeManager.ATT_RESOURCE);
                    if (url != null) {
                        this.resolvedUrls.add(url);
                        continue;
                    }
                    DefaultThemeManager.getLogger().error("Unable to load stylesheet '" + e.getAttribute(DefaultThemeManager.ATT_RESOURCE) + "'");
                }
            }
            return this.resolvedUrls;
        }

        private URL getUrl(IConfigurationElement e, String attributeName) {
            String resource = e.getAttribute(attributeName);
            String contributer = e.getDeclaringExtension().getContributor().getName();
            if (resource.startsWith("platform:")) {
                try {
                    return FileLocator.find((URL)new URL(resource));
                }
                catch (MalformedURLException e1) {
                    DefaultThemeManager.getLogger().error("Unable to find css stylesheet file " + resource, (Throwable)e1);
                    return null;
                }
            }
            Bundle b = Platform.getBundle((String)contributer);
            return b.getResource(resource);
        }
    }
}

