/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.launch;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.codehaus.plexus.classworlds.launcher.ConfigurationHandler;
import org.codehaus.plexus.classworlds.launcher.ConfigurationParser;
import org.codehaus.plexus.util.DirectoryScanner;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.embedder.IMavenLauncherConfiguration;
import org.eclipse.m2e.core.internal.M2EUtils;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.launch.AbstractMavenRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenExternalRuntime
extends AbstractMavenRuntime {
    private static final Logger log = LoggerFactory.getLogger(MavenExternalRuntime.class);
    private static final String PROPERTY_MAVEN_HOME = "maven.home";
    private final String location;
    private transient String version;

    public MavenExternalRuntime(String location) {
        this.location = location;
    }

    public MavenExternalRuntime(String name, String location) {
        super(name);
        this.location = location;
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public boolean isAvailable() {
        return new File(this.location, "bin").exists() && this.getLauncherClasspath() != null && this.isSupportedVersion();
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    public String getMainTypeName() {
        return "org.codehaus.classworlds.Launcher";
    }

    private File getLauncherConfigurationFile() {
        return new File(this.location, "bin/m2.conf");
    }

    @Override
    public void createLauncherConfiguration(final IMavenLauncherConfiguration collector, final IProgressMonitor monitor) throws CoreException {
        collector.addRealm("]launcher");
        collector.addArchiveEntry(this.getLauncherClasspath());
        ConfigurationHandler handler = new ConfigurationHandler(){
            private String mainRealmName;

            public void addImportFrom(String relamName, String importSpec) {
                throw new UnsupportedOperationException(Messages.MavenExternalRuntime_exc_unsupported);
            }

            public void addLoadFile(File file) {
                try {
                    collector.addArchiveEntry(file.getAbsolutePath());
                }
                catch (CoreException ex) {
                    throw new ExceptionWrapper((Exception)((Object)ex));
                }
            }

            public void addLoadURL(URL url) {
                try {
                    collector.addArchiveEntry(url.toExternalForm());
                }
                catch (CoreException ex) {
                    throw new ExceptionWrapper((Exception)((Object)ex));
                }
            }

            public void addRealm(String realmName) {
                if (this.mainRealmName == null) {
                    throw new IllegalStateException();
                }
                collector.addRealm(realmName);
                if (this.mainRealmName.equals(realmName)) {
                    try {
                        MavenExternalRuntime.this.collectExtensions(collector, monitor);
                    }
                    catch (CoreException ex) {
                        throw new ExceptionWrapper((Exception)((Object)ex));
                    }
                }
            }

            public void setAppMain(String mainClassName, String mainRealmName) {
                this.mainRealmName = mainRealmName;
                collector.setMainType(mainClassName, mainRealmName);
            }
        };
        Properties properties = new Properties();
        M2EUtils.copyProperties(properties, System.getProperties());
        properties.put(PROPERTY_MAVEN_HOME, this.location);
        ConfigurationParser parser = new ConfigurationParser(handler, properties);
        try (FileInputStream is = new FileInputStream(this.getLauncherConfigurationFile());){
            parser.parse((InputStream)is);
        }
        catch (Exception e) {
            if (e instanceof ExceptionWrapper && e.getCause() instanceof CoreException) {
                throw (CoreException)e.getCause();
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.MavenExternalRuntime_error_cannot_parse, (Throwable)e));
        }
    }

    public String toString() {
        return String.valueOf(this.location) + ' ' + this.getVersion();
    }

    private String getLauncherClasspath() {
        File mavenHome = new File(this.location);
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(mavenHome);
        ds.setIncludes(new String[]{"core/boot/classworlds*.jar", "boot/classworlds*.jar", "boot/plexus-classworlds*.jar"});
        ds.scan();
        String[] includedFiles = ds.getIncludedFiles();
        if (includedFiles.length == 1) {
            return new File(mavenHome, includedFiles[0]).getAbsolutePath();
        }
        return null;
    }

    @Override
    public synchronized String getVersion() {
        if (this.version == null) {
            this.version = this.getVersion0();
        }
        return this.version;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getVersion0() {
        class VersionHandler
        implements ConfigurationHandler {
            File mavenCore;
            File uber;

            VersionHandler() {
            }

            public void addImportFrom(String relamName, String importSpec) {
            }

            public void addLoadFile(File file) {
                if (file.getName().contains("maven-core")) {
                    this.mavenCore = file;
                } else if (file.getName().endsWith("uber.jar")) {
                    this.uber = file;
                }
            }

            public void addLoadURL(URL url) {
            }

            public void addRealm(String realmName) {
            }

            public void setAppMain(String mainClassName, String mainRealmName) {
            }
        }
        VersionHandler handler = new VersionHandler();
        Properties properties = new Properties();
        M2EUtils.copyProperties(properties, System.getProperties());
        properties.put(PROPERTY_MAVEN_HOME, this.location);
        ConfigurationParser parser = new ConfigurationParser((ConfigurationHandler)handler, properties);
        try {
            try (FileInputStream is = new FileInputStream(this.getLauncherConfigurationFile());){
                parser.parse((InputStream)is);
            }
            ZipFile zip = null;
            if (handler.mavenCore != null) {
                zip = new ZipFile(handler.mavenCore);
            } else if (handler.uber != null) {
                zip = new ZipFile(handler.uber);
            }
            if (zip == null) return Messages.MavenExternalRuntime_unknown;
            try {
                String suffix = "";
                ZipEntry zipEntry = zip.getEntry("META-INF/maven/org.apache.maven/maven-core/pom.properties");
                if (zipEntry == null) return Messages.MavenExternalRuntime_unknown;
                Properties pomProperties = new Properties();
                pomProperties.load(zip.getInputStream(zipEntry));
                String version = pomProperties.getProperty("version");
                if (version == null) return Messages.MavenExternalRuntime_unknown;
                String string = String.valueOf(version) + suffix;
                return string;
            }
            finally {
                zip.close();
            }
        }
        catch (Exception e) {
            log.error("Could not parse classwords configuration file", (Throwable)e);
        }
        return Messages.MavenExternalRuntime_unknown;
    }

    private static class ExceptionWrapper
    extends RuntimeException {
        private static final long serialVersionUID = 8815818826909815028L;

        public ExceptionWrapper(Exception cause) {
            super(cause);
        }
    }
}

