/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace.node;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.InterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ResolvedMethod;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.node.CompositeGeneratorNode;
import org.eclipse.xtext.generator.trace.node.IGeneratorNode;
import org.eclipse.xtext.generator.trace.node.TracedAccessors;
import org.eclipse.xtext.generator.trace.node.TracingSugar;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class TracedAccessorsProcessor
extends AbstractClassProcessor {
    private static final Set<String> TYPES_WITH_GOOD_TO_STRING = Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new String[]{"string", "boolean", "int", "long", "integer"}));

    public void doTransform(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        TypeReference[] factories;
        annotatedClass.setExtendedClass(context.newTypeReference(TracingSugar.class, new TypeReference[0]));
        TypeReference iterableType = context.newTypeReference(Iterable.class, new TypeReference[]{context.newWildcardTypeReference()});
        TypeReference annotationType = context.newTypeReference(TracedAccessors.class, new TypeReference[0]);
        AnnotationReference _findAnnotation = annotatedClass.findAnnotation(annotationType.getType());
        TypeReference[] _classArrayValue = null;
        if (_findAnnotation != null) {
            _classArrayValue = _findAnnotation.getClassArrayValue("value");
        }
        if ((factories = _classArrayValue) == null) {
            return;
        }
        Functions.Function1 _function = it -> it.getType();
        Iterable _filter = Iterables.filter((Iterable)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)factories)), (Functions.Function1)_function), InterfaceDeclaration.class);
        for (InterfaceDeclaration f : _filter) {
            Functions.Function1 _function_1 = it -> it.getSimpleName().startsWith("create") && IterableExtensions.isEmpty((Iterable)it.getParameters());
            Functions.Function1 _function_2 = it -> it.getReturnType();
            Iterable _map = IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)f.getDeclaredMethods(), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
            for (TypeReference t : _map) {
                Functions.Function1 _function_3 = it -> this.isSupportedGetter((ResolvedMethod)it);
                Functions.Function1 _function_4 = it -> {
                    boolean _isAssignableFrom = iterableType.isAssignableFrom(it.getDeclaration().getReturnType());
                    return !_isAssignableFrom;
                };
                Iterable _filter_1 = IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)t.getAllResolvedMethods(), (Functions.Function1)_function_3), (Functions.Function1)_function_4);
                for (final ResolvedMethod getter : _filter_1) {
                    TypeReference rt = getter.getResolvedReturnType();
                    boolean _contains = TYPES_WITH_GOOD_TO_STRING.contains(rt.getType().getSimpleName().toLowerCase());
                    if (_contains) {
                        Procedures.Procedure1 _function_5 = it -> {
                            it.setReturnType(context.newTypeReference(IGeneratorNode.class, new TypeReference[0]));
                            it.addParameter("target", t);
                            StringConcatenationClient _client = new StringConcatenationClient(){

                                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                    _builder.append(EStructuralFeature.class);
                                    _builder.append((Object)" feature = target.eClass().getEStructuralFeature(\"");
                                    String _featureName = TracedAccessorsProcessor.this.featureName(getter);
                                    _builder.append((Object)_featureName);
                                    _builder.append((Object)"\");");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append(ILocationData.class);
                                    _builder.append((Object)" location = this.location(target, feature, -1);");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append(CompositeGeneratorNode.class);
                                    _builder.append((Object)" trace = this.trace(location);");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append((Object)"this.append(trace, target.");
                                    String _simpleName = getter.getDeclaration().getSimpleName();
                                    _builder.append((Object)_simpleName);
                                    _builder.append((Object)"());");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append((Object)"return trace;");
                                    _builder.newLine();
                                }
                            };
                            it.setBody(_client);
                        };
                        annotatedClass.addMethod(this.tracerName(getter), _function_5);
                        Procedures.Procedure1 _function_6 = it -> {
                            it.setReturnType(context.newTypeReference(IGeneratorNode.class, new TypeReference[0]));
                            it.addParameter("target", t);
                            it.addParameter("useForDebugging", context.newTypeReference(Boolean.TYPE, new TypeReference[0]));
                            StringConcatenationClient _client = new StringConcatenationClient(){

                                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                    _builder.append(EStructuralFeature.class);
                                    _builder.append((Object)" feature = target.eClass().getEStructuralFeature(\"");
                                    String _featureName = TracedAccessorsProcessor.this.featureName(getter);
                                    _builder.append((Object)_featureName);
                                    _builder.append((Object)"\");");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append(ILocationData.class);
                                    _builder.append((Object)" location = this.location(target, feature, -1);");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append(CompositeGeneratorNode.class);
                                    _builder.append((Object)" trace = this.trace(location, useForDebugging);");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append((Object)"this.append(trace, target.");
                                    String _simpleName = getter.getDeclaration().getSimpleName();
                                    _builder.append((Object)_simpleName);
                                    _builder.append((Object)"());");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append((Object)"return trace;");
                                    _builder.newLine();
                                }
                            };
                            it.setBody(_client);
                        };
                        annotatedClass.addMethod(this.tracerName(getter), _function_6);
                    }
                    Procedures.Procedure1 _function_7 = it -> {
                        it.setReturnType(context.newTypeReference(IGeneratorNode.class, new TypeReference[0]));
                        it.addParameter("target", t);
                        TypeReference stringProvider = context.newTypeReference(Function.class, new TypeReference[]{rt, context.getString()});
                        it.addParameter("stringProvider", stringProvider);
                        StringConcatenationClient _client = new StringConcatenationClient(){

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append(EStructuralFeature.class);
                                _builder.append((Object)" feature = target.eClass().getEStructuralFeature(\"");
                                String _featureName = TracedAccessorsProcessor.this.featureName(getter);
                                _builder.append((Object)_featureName);
                                _builder.append((Object)"\");");
                                _builder.newLineIfNotEmpty();
                                _builder.append(ILocationData.class);
                                _builder.append((Object)" location = this.location(target, feature, -1);");
                                _builder.newLineIfNotEmpty();
                                _builder.append(CompositeGeneratorNode.class);
                                _builder.append((Object)" trace = this.trace(location);");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"this.append(trace, stringProvider.apply(target.");
                                String _simpleName = getter.getDeclaration().getSimpleName();
                                _builder.append((Object)_simpleName);
                                _builder.append((Object)"()));");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"return trace;");
                                _builder.newLine();
                            }
                        };
                        it.setBody(_client);
                    };
                    annotatedClass.addMethod(this.tracerName(getter), _function_7);
                }
            }
        }
    }

    public String tracerName(ResolvedMethod m) {
        String _featureName = this.featureName(m);
        return "_" + _featureName;
    }

    public String featureName(ResolvedMethod m) {
        String _xblockexpression = null;
        String n = m.getDeclaration().getSimpleName();
        int _xifexpression = 0;
        boolean _startsWith = n.startsWith("get");
        _xifexpression = _startsWith ? 3 : 2;
        int skip = _xifexpression;
        _xblockexpression = StringExtensions.toFirstLower((String)m.getDeclaration().getSimpleName().substring(skip));
        return _xblockexpression;
    }

    public boolean isSupportedGetter(ResolvedMethod it) {
        String _name;
        boolean _not;
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)it.getDeclaration().getParameters());
        boolean bl = _not = !_isEmpty;
        if (_not) {
            return false;
        }
        boolean _isStatic = it.getDeclaration().isStatic();
        if (_isStatic) {
            return false;
        }
        String n = it.getDeclaration().getSimpleName();
        String _qualifiedName = it.getDeclaration().getDeclaringType().getQualifiedName();
        boolean _equals = Objects.equal((Object)_qualifiedName, (Object)(_name = Object.class.getName()));
        if (_equals) {
            return false;
        }
        return n.startsWith("get") || n.startsWith("is");
    }
}

