/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.CodeGenPlugin;
import org.eclipse.emf.codegen.jet.IJETNature;
import org.eclipse.emf.codegen.jet.JETBuilder;
import org.eclipse.emf.codegen.jet.JETCompileTemplateOperation;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JETNature
implements IJETNature {
    protected static final String BUILDER = "JETBuilder";
    protected static final String DEFAULT_TEMPLATE_CONTAINER_NAME = "templates";
    protected static final String JET_NATURE_PROPERTIES_FILE = ".jetproperties";
    protected static final String TEMPLATE_CONTAINER_NODE = "template-container";
    protected static final String SOURCE_CONTAINER_NODE = "source-container";
    protected static final String JET_SETTINGS_NODE = "jet-settings";
    private static final Map<JETNature, Void> JET_NATURES = new WeakHashMap<JETNature, Void>();
    private static final IWorkspace WORKSPACE;
    private static Map<String, URI> targetPlatformBundleRedirections;
    protected IProject jetProject;
    protected List<Object> jetTemplateContainers;
    protected List<Object> jetTemplateSourceContainers;
    protected IContainer jetJavaSourceContainer;

    static {
        IWorkspace workspace = null;
        try {
            workspace = ResourcesPlugin.getWorkspace();
            workspace.addResourceChangeListener(new IResourceChangeListener(){

                public void resourceChanged(IResourceChangeEvent event) {
                    targetPlatformBundleRedirections = null;
                    for (JETNature jetNature : JET_NATURES.keySet()) {
                        jetNature.jetJavaSourceContainer = null;
                        jetNature.jetTemplateContainers = null;
                        jetNature.jetTemplateSourceContainers = null;
                    }
                }
            }, 8);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        WORKSPACE = workspace;
    }

    public static JETNature getRuntime(IProject project) {
        try {
            JETNature a = (JETNature)project.getNature("org.eclipse.emf.codegen.jet.IJETNature");
            return a;
        }
        catch (CoreException e) {
            return null;
        }
    }

    public JETNature() {
        JET_NATURES.put(this, null);
    }

    @Override
    public List<Object> getTemplateContainers() {
        if (this.jetTemplateContainers == null) {
            this.jetTemplateContainers = this.getTemplateContainersFromFile();
        }
        return this.jetTemplateContainers;
    }

    @Override
    public List<Object> getTemplateSourceContainers() {
        if (this.jetTemplateSourceContainers == null) {
            this.jetTemplateSourceContainers = this.getTemplateSourceContainersFromFile();
        }
        return this.jetTemplateSourceContainers;
    }

    @Override
    public IContainer getJavaSourceContainer() {
        if (this.jetJavaSourceContainer == null) {
            this.jetJavaSourceContainer = this.getJavaSourceContainerFromFile();
        }
        return this.jetJavaSourceContainer;
    }

    @Override
    public void setTemplateContainers(List<Object> templateContainers) {
        this.setTemplateContainers(templateContainers, templateContainers);
    }

    @Override
    public void setTemplateContainers(List<Object> templateContainers, List<Object> templateSourceContainers) {
        this.jetTemplateContainers = templateContainers;
        this.jetTemplateSourceContainers = templateSourceContainers;
        try {
            this.setTemplateContainersToFile(templateContainers, templateSourceContainers);
        }
        catch (CoreException e) {
            CodeGenPlugin.write((Exception)((Object)e));
        }
    }

    @Override
    public void setJavaSourceContainer(IContainer javaSourceContainer) {
        this.jetJavaSourceContainer = javaSourceContainer;
        try {
            this.setJavaSourceContainerToFile(javaSourceContainer);
        }
        catch (CoreException e) {
            CodeGenPlugin.write((Exception)((Object)e));
        }
    }

    public void configure() throws CoreException {
        this.configure((IProgressMonitor)new NullProgressMonitor());
    }

    public void configure(IProgressMonitor monitor) throws CoreException {
        this.setDefaults(monitor);
        this.addToFrontOfBuildSpec(String.valueOf(CodeGenPlugin.INSTANCE.getSymbolicName()) + "." + BUILDER);
    }

    public void setDefaults(IProgressMonitor monitor) throws CoreException {
        this.initTemplateContainer(monitor);
        this.initJavaSourceContainer(monitor);
        try {
            this.createDefaultJETSettingsFile(this.getTemplateContainers(), this.getJavaSourceContainer());
        }
        catch (IOException e) {
            CodeGenPlugin.write(e);
        }
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return this.jetProject;
    }

    public void setProject(IProject project) {
        this.jetProject = project;
    }

    protected void initTemplateContainer(IProgressMonitor monitor) throws CoreException {
        IContainer templateFolder = JETNature.getContainer(this.getProject(), DEFAULT_TEMPLATE_CONTAINER_NAME);
        if (templateFolder instanceof IFolder && !templateFolder.exists()) {
            ((IFolder)templateFolder).create(true, true, monitor);
        }
        this.jetTemplateContainers = new ArrayList<Object>();
        this.jetTemplateContainers.add(templateFolder);
        this.jetTemplateSourceContainers = new ArrayList<Object>();
        this.jetTemplateSourceContainers.add(templateFolder);
    }

    protected void initJavaSourceContainer(IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        IContainer sourceFolder = JETNature.getContainer(project, this.getDefaultSourcePath(project));
        if (sourceFolder instanceof IFolder && !sourceFolder.exists()) {
            ((IFolder)sourceFolder).create(true, true, monitor);
        }
        this.jetJavaSourceContainer = sourceFolder;
    }

    protected IPath getDefaultSourcePath() {
        Path path = new Path("");
        return path;
    }

    protected IPath getDefaultSourcePath(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            try {
                IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
                int n = iPackageFragmentRootArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
                    if (packageFragmentRoot.getKind() == 1) {
                        IResource resource = packageFragmentRoot.getResource();
                        return resource.getProjectRelativePath();
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getDefaultSourcePath();
    }

    protected void addToFrontOfBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        boolean found = false;
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            ICommand command = description.newCommand();
            command.setBuilderName(builderID);
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 1, commands.length);
            newCommands[0] = command;
            description.setBuildSpec(newCommands);
            this.getProject().setDescription(description, null);
        }
    }

    public List<Object> getTemplateContainersFromFile() {
        List<Object> result = Collections.emptyList();
        try {
            Document document = this.parseJETSettings();
            if (document != null) {
                result = this.getContainerValues(document.getDocumentElement(), TEMPLATE_CONTAINER_NODE, false);
            } else {
                this.setDefaults((IProgressMonitor)new NullProgressMonitor());
                result = this.getTemplateContainers();
            }
        }
        catch (Exception e) {
            try {
                this.setDefaults((IProgressMonitor)new NullProgressMonitor());
                result = this.getTemplateContainers();
            }
            catch (Exception ex) {
                CodeGenPlugin.write(ex);
            }
        }
        return result;
    }

    protected List<Object> getTemplateSourceContainersFromFile() {
        List<Object> result = Collections.emptyList();
        try {
            Document document = this.parseJETSettings();
            if (document != null) {
                result = this.getContainerValues(document.getDocumentElement(), TEMPLATE_CONTAINER_NODE, true);
            } else {
                this.setDefaults((IProgressMonitor)new NullProgressMonitor());
                result = this.getTemplateContainers();
            }
        }
        catch (Exception e) {
            try {
                this.setDefaults((IProgressMonitor)new NullProgressMonitor());
                result = this.getTemplateContainers();
            }
            catch (Exception ex) {
                CodeGenPlugin.write(ex);
            }
        }
        return result;
    }

    public IContainer getJavaSourceContainerFromFile() {
        IContainer result = null;
        try {
            Document document = this.parseJETSettings();
            if (document != null) {
                result = this.getContainerValue(document.getDocumentElement(), SOURCE_CONTAINER_NODE);
            } else {
                this.setDefaults((IProgressMonitor)new NullProgressMonitor());
                result = this.getJavaSourceContainer();
            }
        }
        catch (Exception e) {
            try {
                this.setDefaults((IProgressMonitor)new NullProgressMonitor());
                result = this.getJavaSourceContainer();
            }
            catch (Exception ex) {
                CodeGenPlugin.write(ex);
            }
        }
        return result;
    }

    protected Document parseJETSettings() throws ParserConfigurationException, SAXException, IOException, CoreException {
        Document document = null;
        StringReader reader = this.readJETSettingFile();
        if (reader != null) {
            document = JETNature.fromInputSource(new InputSource(reader));
            if (!document.getDocumentElement().getNodeName().equalsIgnoreCase(JET_SETTINGS_NODE)) {
                CodeGenPlugin.write(new IOException(CodeGenPlugin.getPlugin().getString("_UI_MalformedJETPropertiesFile_exception")));
            }
            reader.close();
        }
        return document;
    }

    protected StringReader readJETSettingFile() throws CoreException, IOException {
        StringReader reader = null;
        IFile jetSettingsFile = this.getProject().getFile(JET_NATURE_PROPERTIES_FILE);
        if (jetSettingsFile.exists()) {
            InputStream input = jetSettingsFile.getContents(true);
            String jetSettings = new String(JETNature.readContentsAsBytes(input));
            reader = new StringReader(jetSettings);
        }
        return reader;
    }

    protected List<Object> getContainerValues(Element element, String localName) {
        return this.getContainerValues(element, localName, false);
    }

    protected List<Object> getContainerValues(Element element, String localName, boolean filter) {
        List<Object> result = new ArrayList<Object>();
        Element childElement = this.getChildWithLocalName(element, localName);
        Node node = childElement.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 3) {
                result = JETNature.getContainers(this.getProject(), node.getNodeValue(), filter);
                break;
            }
            node = node.getNextSibling();
        }
        if (result.isEmpty()) {
            result.add(this.getProject());
        }
        return result;
    }

    protected IContainer getContainerValue(Element element, String localName) {
        IProject result = null;
        Element childElement = this.getChildWithLocalName(element, localName);
        Node node = childElement.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 3) {
                result = JETNature.getContainer(this.getProject(), node.getNodeValue());
                break;
            }
            node = node.getNextSibling();
        }
        if (result == null) {
            result = this.getProject();
        }
        return result;
    }

    protected void setContainerValues(List<Object> containers, Element element, String localName) {
        this.setContainerValues(containers, containers, element, localName);
    }

    protected void setContainerValues(List<Object> containers, List<Object> sourceContainers, Element element, String localName) {
        Element childElement = this.getChildWithLocalName(element, localName);
        Text text = null;
        Node node = childElement.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 3) {
                text = (Text)node;
                break;
            }
            node = node.getNextSibling();
        }
        if (text == null) {
            text = element.getOwnerDocument().createTextNode(JETNature.getContainers(this.jetProject, containers, sourceContainers));
            childElement.appendChild(text);
        } else {
            text.setNodeValue(JETNature.getContainers(this.jetProject, containers, sourceContainers));
        }
    }

    protected void setContainerValue(IContainer container, Element element, String localName) {
        Element childElement = this.getChildWithLocalName(element, localName);
        Node text = null;
        Node node = childElement.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 3) {
                text = (Text)node;
                break;
            }
            node = node.getNextSibling();
        }
        if (text == null) {
            text = element.getOwnerDocument().createTextNode(container.getProjectRelativePath().toString());
            childElement.appendChild(text);
        } else {
            text.setNodeValue(container.getProjectRelativePath().toString());
        }
    }

    protected Element getChildWithLocalName(Element element, String localName) {
        Node child = element.getFirstChild();
        while (child != null) {
            Element childElement;
            if (child.getNodeType() == 1 && (childElement = (Element)child).getLocalName().equals(localName)) {
                return childElement;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public static byte[] readContentsAsBytes(InputStream input) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        try {
            int read;
            int BUF_SIZE = 8192;
            byte[] buf = new byte[8192];
            int totalRead = 0;
            bufferedInputStream = new BufferedInputStream(input);
            while (totalRead < 8192 && (read = bufferedInputStream.read(buf, totalRead, 8192 - totalRead)) != -1) {
                totalRead += read;
            }
            if (totalRead < 8192) {
                byte[] result = new byte[totalRead];
                System.arraycopy(buf, 0, result, 0, totalRead);
                byte[] byArray = result;
                return byArray;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream(16384);
            out.write(buf);
            while ((read = bufferedInputStream.read(buf, 0, 8192)) != -1) {
                out.write(buf, 0, read);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException e) {
                CodeGenPlugin.write(e);
            }
        }
    }

    public void setTemplateContainersToFile(List<Object> templateContainers) throws CoreException {
        this.setTemplateContainersToFile(templateContainers, templateContainers);
    }

    public void setTemplateContainersToFile(List<Object> templateContainers, List<Object> templateSourceContainers) throws CoreException {
        block5: {
            try {
                try {
                    Document document = this.parseJETSettings();
                    if (document != null) {
                        this.setContainerValues(templateContainers, templateSourceContainers, document.getDocumentElement(), TEMPLATE_CONTAINER_NODE);
                        this.commitXML(document);
                        break block5;
                    }
                    this.initJavaSourceContainer((IProgressMonitor)new NullProgressMonitor());
                    this.createDefaultJETSettingsFile(templateContainers, this.getJavaSourceContainer());
                }
                catch (Exception e) {
                    this.initJavaSourceContainer((IProgressMonitor)new NullProgressMonitor());
                    this.createDefaultJETSettingsFile(templateContainers, templateSourceContainers, this.getJavaSourceContainer());
                }
            }
            catch (Exception e) {
                CodeGenPlugin.write(e);
            }
        }
    }

    public void setJavaSourceContainerToFile(IContainer sourceContainer) throws CoreException {
        block5: {
            try {
                try {
                    Document document = this.parseJETSettings();
                    if (document != null) {
                        this.setContainerValue(sourceContainer, document.getDocumentElement(), SOURCE_CONTAINER_NODE);
                        this.commitXML(document);
                        break block5;
                    }
                    this.initTemplateContainer((IProgressMonitor)new NullProgressMonitor());
                    this.createDefaultJETSettingsFile(this.getTemplateContainers(), sourceContainer);
                }
                catch (Exception e) {
                    this.initTemplateContainer((IProgressMonitor)new NullProgressMonitor());
                    this.createDefaultJETSettingsFile(this.getTemplateContainers(), sourceContainer);
                }
            }
            catch (Exception e) {
                CodeGenPlugin.write(e);
            }
        }
    }

    protected void createDefaultJETSettingsFile(List<Object> templateContainers, IContainer sourceContainer) throws CoreException, IOException {
        this.createDefaultJETSettingsFile(templateContainers, templateContainers, sourceContainer);
    }

    protected void createDefaultJETSettingsFile(List<Object> templateContainers, List<Object> templateSourceContainers, IContainer sourceContainer) throws CoreException, IOException {
        StringWriter writer = new StringWriter();
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.write("\n");
        writer.write("<jet-settings>");
        writer.write("\n");
        writer.write("\t<template-container>" + JETNature.getContainers(this.jetProject, templateContainers, templateSourceContainers) + "</" + TEMPLATE_CONTAINER_NODE + ">");
        writer.write("\t<source-container>" + sourceContainer.getProjectRelativePath().toString() + "</" + SOURCE_CONTAINER_NODE + ">");
        writer.write("\n");
        writer.write("</jet-settings>");
        writer.write("\n");
        IFile jetSettingsFile = this.getProject().getFile(JET_NATURE_PROPERTIES_FILE);
        ByteArrayInputStream sourceStream = new ByteArrayInputStream(writer.toString().getBytes("UTF-8"));
        if (jetSettingsFile.exists()) {
            jetSettingsFile.setContents((InputStream)sourceStream, true, true, null);
        } else {
            jetSettingsFile.create((InputStream)sourceStream, true, null);
        }
        ((InputStream)sourceStream).close();
    }

    protected void commitXML(Document document) throws CoreException, ClassNotFoundException, IOException {
        String documentXML = JETNature.toString(document);
        IFile jetSettingsFile = this.getProject().getFile(JET_NATURE_PROPERTIES_FILE);
        ByteArrayInputStream sourceStream = new ByteArrayInputStream(documentXML.getBytes("UTF-8"));
        if (jetSettingsFile.exists()) {
            jetSettingsFile.setContents((InputStream)sourceStream, true, true, null);
        } else {
            jetSettingsFile.create((InputStream)sourceStream, true, null);
        }
        ((InputStream)sourceStream).close();
    }

    public static IContainer getContainer(IProject project, IPath path) {
        Object result = project;
        if (!path.isEmpty()) {
            if (path.getDevice() != null) {
                result = null;
            } else if (path.isAbsolute()) {
                IWorkspaceRoot root = project.getWorkspace().getRoot();
                result = path.segmentCount() == 1 ? root.getProject(path.segment(0)) : root.getFolder(path);
            } else {
                result = project.getFolder(path);
            }
        }
        return result;
    }

    public static IContainer getContainer(IProject project, String path) {
        return JETNature.getContainer(project, (IPath)new Path(path));
    }

    public static List<Object> getContainers(IProject project, String paths) {
        return JETNature.getContainers(project, paths, false);
    }

    public static List<Object> getContainers(IProject project, String paths, boolean filter) {
        ArrayList<Object> result = new ArrayList<Object>();
        StringTokenizer stringTokenizer = new StringTokenizer(paths, " ;");
        while (stringTokenizer.hasMoreTokens()) {
            IContainer container;
            String path = stringTokenizer.nextToken();
            if (path.startsWith("@")) {
                if (filter) continue;
                path = path.substring(1);
            }
            if ((container = JETNature.getContainer(project, (IPath)new Path(path))) == null) {
                URI uri = URI.createURI((String)path);
                if (uri.isRelative()) continue;
                result.add(uri);
                continue;
            }
            result.add(container);
        }
        return result;
    }

    public static String getContainers(IProject project, List<Object> containers) {
        return JETNature.getContainers(project, containers, containers);
    }

    public static String getContainers(IProject project, List<Object> containers, List<Object> sourceContainers) {
        StringBuilder result = new StringBuilder();
        for (Object container : containers) {
            if (result.length() != 0) {
                result.append(";");
            }
            if (!sourceContainers.contains(container)) {
                result.append("@");
            }
            if (container instanceof IContainer) {
                result.append(JETNature.getContainer(project, (IContainer)container));
                continue;
            }
            if (!(container instanceof URI)) continue;
            result.append(container);
        }
        return result.toString();
    }

    public static String getContainer(IProject project, IContainer container) {
        return (project == container.getProject() ? container.getProjectRelativePath() : container.getFullPath()).toString();
    }

    public static URI resolve(URI uri) {
        IResource member;
        if (WORKSPACE != null && uri.isPlatformResource() && uri.segmentCount() > 1 && ((member = WORKSPACE.getRoot().findMember((IPath)new Path(uri.toPlatformString(true)))) == null || !member.isAccessible())) {
            URI targetPlatformBundleLocation;
            if (targetPlatformBundleRedirections == null) {
                targetPlatformBundleRedirections = new HashMap<String, URI>();
                Map targetPlatformBundleMappings = CommonPlugin.getTargetPlatformBundleMappings();
                if (targetPlatformBundleMappings != null) {
                    for (Map.Entry entry : targetPlatformBundleMappings.entrySet()) {
                        String bundleName = (String)entry.getKey();
                        URI locationURI = (URI)entry.getValue();
                        if (locationURI.isPlatformResource()) continue;
                        if ("archive".equals(locationURI.scheme())) {
                            locationURI = URI.createURI((String)("jar" + locationURI.toString().substring(7)));
                        }
                        targetPlatformBundleRedirections.put(bundleName, locationURI);
                    }
                }
            }
            if ((targetPlatformBundleLocation = targetPlatformBundleRedirections.get(URI.decode((String)uri.segment(1)))) != null) {
                List segments = uri.segmentsList().subList(2, uri.segmentCount());
                URI result = targetPlatformBundleLocation.appendSegments(segments.toArray(new String[segments.size()]));
                return result;
            }
        }
        return CommonPlugin.resolve((URI)uri);
    }

    public static Set<URI> getIncludingTemplates(URI templateURI) {
        LinkedHashSet<URI> result = new LinkedHashSet<URI>();
        IProject[] iProjectArray = WORKSPACE.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            JETNature jetNature = JETNature.getRuntime(project);
            if (jetNature != null) {
                JETCompileTemplateOperation.State buildState = JETBuilder.getBuildState(project);
                block1: for (List<URI> list : buildState.getJavaFileToTemplateURIs().values()) {
                    int size = list.size();
                    int i = 1;
                    while (i < size) {
                        if (list.get(i).equals(templateURI)) {
                            result.add(list.get(0));
                            continue block1;
                        }
                        ++i;
                    }
                }
            }
            ++n2;
        }
        return result;
    }

    static String toString(Document document) throws IOException {
        StringWriter writer = new StringWriter();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.setOutputProperty("method", "xml");
            transformer.transform(new DOMSource(document), new StreamResult(writer));
        }
        catch (TransformerException exception) {
            IOException ioException = new IOException(exception.getLocalizedMessage());
            ioException.initCause(exception);
            throw ioException;
        }
        return writer.toString();
    }

    static Document fromInputSource(InputSource inputSource) throws IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        try {
            DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
            return parser.parse(inputSource);
        }
        catch (Exception exception) {
            IOException ioException = new IOException(exception.getLocalizedMessage());
            ioException.initCause(exception);
            throw ioException;
        }
    }
}

