/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.NamedArgument;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.analysis.Context2NameFunction;
import org.eclipse.xtext.serializer.analysis.GrammarElementDeclarationOrder;
import org.eclipse.xtext.xtext.ConditionEvaluator;

public abstract class SerializationContext
implements ISerializationContext {
    private final ISerializationContext parent;

    public static ISerializationContext forChild(ISerializationContext container, AbstractElement assignedElement, EObject sem) {
        if (assignedElement instanceof Action) {
            return SerializationContext.forChild(container, (Action)assignedElement, sem);
        }
        if (assignedElement instanceof RuleCall) {
            return SerializationContext.forChild(container, (RuleCall)assignedElement, sem);
        }
        throw new IllegalStateException("Invalid Element:" + assignedElement);
    }

    public static ISerializationContext forChild(ISerializationContext container, Action assignedAction, EObject sem) {
        Set<Parameter> params;
        EClass type = sem == null ? null : sem.eClass();
        SerializationContext context = new TypeContext(new ActionContext(null, assignedAction), type);
        if (container != null && !(params = container.getEnabledBooleanParameters()).isEmpty()) {
            context = new ParameterValueContext(context, params);
        }
        return context;
    }

    public static ISerializationContext forChild(ISerializationContext container, RuleCall ruleCall, EObject sem) {
        EClass type = sem == null ? null : sem.eClass();
        SerializationContext result = new TypeContext(new RuleContext(null, (ParserRule)ruleCall.getRule()), type);
        EList<NamedArgument> arguments = ruleCall.getArguments();
        if (!arguments.isEmpty() && container != null) {
            LinkedHashSet params = Sets.newLinkedHashSet();
            ConditionEvaluator evaluator = new ConditionEvaluator(container.getEnabledBooleanParameters());
            for (NamedArgument argument : arguments) {
                if (!evaluator.evaluate(argument.getValue())) continue;
                params.add(argument.getParameter());
            }
            result = new ParameterValueContext(result, params);
        }
        return result;
    }

    public static ISerializationContext fromEObject(EObject ctx, EObject sem) {
        EClass type;
        EClass eClass = type = sem == null ? null : sem.eClass();
        if (ctx instanceof ParserRule) {
            return new TypeContext(new RuleContext(null, (ParserRule)ctx), type);
        }
        if (ctx instanceof Action) {
            return new TypeContext(new ActionContext(null, (Action)ctx), type);
        }
        if (ctx == null) {
            throw new NullPointerException("context is null");
        }
        throw new IllegalStateException("Unknonwn context type:" + ctx.eClass().getName());
    }

    public static List<ISerializationContext> fromEObjects(Iterable<EObject> objects, EObject sem) {
        if (objects == null) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        for (EObject ctx : objects) {
            result.add(SerializationContext.fromEObject(ctx, sem));
        }
        return result;
    }

    public static List<EObject> fromIContexts(Iterable<ISerializationContext> ctxs) {
        if (ctxs == null) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        for (ISerializationContext ctx : ctxs) {
            result.add(((SerializationContext)ctx).getActionOrRule());
        }
        return result;
    }

    protected SerializationContext(ISerializationContext parent) {
        this.parent = parent;
    }

    @Override
    public int compareTo(ISerializationContext o) {
        ISerializationContext p2;
        ISerializationContext p1;
        List<Parameter> params;
        EClass t2;
        GrammarElementDeclarationOrder order;
        int compare;
        EObject o2;
        EObject o1 = this.getActionOrRule();
        if (o1 != (o2 = ((SerializationContext)o).getActionOrRule()) && (compare = (order = GrammarElementDeclarationOrder.get(GrammarUtil.getGrammar(o1))).compare(o1, o2)) != 0) {
            return compare;
        }
        EClass t1 = this.getType();
        if (t1 != (t2 = o.getType())) {
            int compare2;
            if (t1 != null && t2 != null && (compare2 = t1.getName().compareTo(t2.getName())) != 0) {
                return compare2;
            }
            if (t1 != null) {
                return -1;
            }
            if (t2 != null) {
                return 1;
            }
        }
        if ((params = this.getDeclaredParameters()).equals(((SerializationContext)o).getDeclaredParameters())) {
            Set<Parameter> v1 = this.getEnabledBooleanParameters();
            Set<Parameter> v2 = o.getEnabledBooleanParameters();
            if (v1 == null || v2 == null) {
                return v1 != null ? -1 : 1;
            }
            for (Parameter param : params) {
                boolean b2;
                boolean b1 = v1.contains(param);
                if (b1 == (b2 = v2.contains(param))) continue;
                return b1 ? -1 : 1;
            }
        }
        if ((p1 = this.getParent()) != (p2 = ((SerializationContext)o).getParent())) {
            if (p1 != null && p2 != null) {
                return p1.compareTo(p2);
            }
            if (p1 != null) {
                return -1;
            }
            if (p2 != null) {
                return 1;
            }
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ISerializationContext)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ISerializationContext other = (ISerializationContext)obj;
        boolean eq1 = this.equalsInternal(other);
        return eq1;
    }

    private boolean equalsInternal(ISerializationContext other) {
        if (!Objects.equal((Object)this.getParserRule(), (Object)other.getParserRule())) {
            return false;
        }
        if (!Objects.equal((Object)this.getAssignedAction(), (Object)other.getAssignedAction())) {
            return false;
        }
        if (!Objects.equal(this.getEnabledBooleanParameters(), other.getEnabledBooleanParameters())) {
            return false;
        }
        return Objects.equal((Object)this.getType(), (Object)other.getType());
    }

    public EObject getActionOrRule() {
        Action action = this.getAssignedAction();
        return action != null ? action : this.getParserRule();
    }

    @Override
    public Action getAssignedAction() {
        return this.parent != null ? this.parent.getAssignedAction() : null;
    }

    public List<Parameter> getDeclaredParameters() {
        ParserRule declarator = this.getParameterDeclarator();
        return declarator == null ? Collections.emptyList() : declarator.getParameters();
    }

    @Override
    public final Set<Parameter> getEnabledBooleanParameters() {
        Set<Parameter> parameters = this.getEnabledBooleanParametersInternal();
        return parameters != null ? parameters : Collections.emptySet();
    }

    protected Set<Parameter> getEnabledBooleanParametersInternal() {
        return this.parent != null ? ((SerializationContext)this.parent).getEnabledBooleanParametersInternal() : null;
    }

    public ParserRule getParameterDeclarator() {
        Action action = this.getAssignedAction();
        if (action != null) {
            return GrammarUtil.containingParserRule(action);
        }
        ParserRule rule = this.getParserRule();
        if (rule != null) {
            return rule;
        }
        return null;
    }

    public ISerializationContext getParent() {
        return this.parent;
    }

    @Override
    public ParserRule getParserRule() {
        return this.parent != null ? this.parent.getParserRule() : null;
    }

    @Override
    public EClass getType() {
        return this.parent != null ? this.parent.getType() : null;
    }

    protected String getTypeString() {
        return this.parent != null ? ((SerializationContext)this.parent).getTypeString() : null;
    }

    public int hashCode() {
        ParserRule rule = this.getParserRule();
        Action action = this.getAssignedAction();
        Set<Parameter> parameterValues = this.getEnabledBooleanParameters();
        EClass type = this.getType();
        int result = 1;
        if (rule != null) {
            result = 31 * result + rule.hashCode();
        }
        if (action != null) {
            result = 31 * result + action.hashCode();
        }
        if (type != null) {
            result = 31 * result + type.hashCode();
        }
        if (parameterValues != null) {
            result = 31 * result + parameterValues.hashCode();
        }
        return result;
    }

    public String toString() {
        ParserRule rule = this.getParserRule();
        Action action = this.getAssignedAction();
        Set<Parameter> parameterValues = this.getEnabledBooleanParameters();
        String type = this.getTypeString();
        StringBuilder builder = new StringBuilder();
        if (action != null) {
            builder.append(GrammarUtil.containingRule(action).getName());
            builder.append(".");
            builder.append(new Context2NameFunction().getUniqueActionName(action));
        } else if (rule != null) {
            builder.append(rule.getName());
        } else {
            builder.append("???");
        }
        if (parameterValues != null && !parameterValues.isEmpty()) {
            ArrayList names = Lists.newArrayList();
            List<Parameter> declared = this.getDeclaredParameters();
            for (Parameter p : parameterValues) {
                if (declared.contains(p)) {
                    names.add(p.getName());
                    continue;
                }
                names.add(((AbstractRule)p.eContainer()).getName() + "." + p.getName());
            }
            builder.append("<");
            builder.append(Joiner.on((String)",").join((Iterable)names));
            builder.append(">");
        }
        if (type != null) {
            builder.append(" returns ");
            builder.append(type);
        }
        return builder.toString();
    }

    public static class ActionContext
    extends SerializationContext {
        private final Action action;

        public ActionContext(ISerializationContext parent, Action action) {
            super(parent);
            this.action = action;
        }

        @Override
        public Action getAssignedAction() {
            return this.action;
        }
    }

    public static class ParameterValueContext
    extends SerializationContext {
        private final Set<Parameter> parameters;

        public ParameterValueContext(ISerializationContext parent, Set<Parameter> parameters) {
            super(parent);
            Preconditions.checkNotNull((Object)parent);
            ParserRule rule = parent.getParserRule();
            if (rule != null) {
                List<Parameter> supportedParameters = ((SerializationContext)parent).getDeclaredParameters();
                Preconditions.checkArgument((boolean)supportedParameters.containsAll(parameters));
            }
            this.parameters = ImmutableSet.copyOf(parameters);
        }

        @Override
        protected Set<Parameter> getEnabledBooleanParametersInternal() {
            return this.parameters;
        }
    }

    public static class RuleContext
    extends SerializationContext {
        private final ParserRule rule;

        public RuleContext(ISerializationContext parent, ParserRule rule) {
            super(parent);
            this.rule = rule;
        }

        @Override
        public ParserRule getParserRule() {
            return this.rule;
        }
    }

    public static class TypeContext
    extends SerializationContext {
        private final EClass type;

        protected TypeContext(ISerializationContext parent, EClass type) {
            super(parent);
            this.type = type;
        }

        @Override
        public EClass getType() {
            return this.type;
        }

        @Override
        protected String getTypeString() {
            return this.type != null ? this.type.getName() : "null";
        }
    }
}

