/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.Set;

@Singleton
public class FileExtensionProvider {
    private Set<String> fileExtensions;

    @Inject
    protected void setExtensions(@Named(value="file.extensions") String extensions) {
        String[] split = extensions.split(",");
        this.fileExtensions = Sets.newLinkedHashSet();
        for (String string : split) {
            this.fileExtensions.add(string);
        }
    }

    public Set<String> getFileExtensions() {
        return this.fileExtensions;
    }

    public String getPrimaryFileExtension() {
        return this.fileExtensions.iterator().next();
    }

    public boolean isValid(String fileExtension) {
        return this.fileExtensions.contains(fileExtension);
    }
}

