/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.updatesite;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.SecureXMLUtil;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.internal.p2.updatesite.Activator;
import org.eclipse.equinox.internal.p2.updatesite.Messages;
import org.eclipse.equinox.internal.p2.updatesite.SiteBundle;
import org.eclipse.equinox.internal.p2.updatesite.SiteCategory;
import org.eclipse.equinox.internal.p2.updatesite.SiteFeature;
import org.eclipse.equinox.internal.p2.updatesite.SiteModel;
import org.eclipse.equinox.p2.publisher.eclipse.URLEntry;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultSiteParser
extends DefaultHandler {
    private static final String ARCHIVE = "archive";
    private static final String CATEGORY = "category";
    private static final String CATEGORY_DEF = "category-def";
    private static final String ASSOCIATE_SITES_URL = "associateSitesURL";
    private static final String ASSOCIATE_SITE = "associateSite";
    private static final String DEFAULT_INFO_URL = "index.html";
    private static final String DESCRIPTION = "description";
    private static final String FEATURE = "feature";
    private static final String BUNDLE = "bundle";
    private static final String FEATURES = "features/";
    private static final String PLUGINS = "plugins/";
    private static final SAXParserFactory parserFactory = SecureXMLUtil.newSecureSAXParserFactory();
    private static final String PLUGIN_ID = Activator.ID;
    private static final String SITE = "site";
    private static final int STATE_ARCHIVE = 3;
    private static final int STATE_CATEGORY = 4;
    private static final int STATE_CATEGORY_DEF = 5;
    private static final int STATE_DESCRIPTION_CATEGORY_DEF = 7;
    private static final int STATE_DESCRIPTION_SITE = 6;
    private static final int STATE_FEATURE = 2;
    private static final int STATE_BUNDLE = 8;
    private static final int STATE_IGNORED_ELEMENT = -1;
    private static final int STATE_INITIAL = 0;
    private static final int STATE_SITE = 1;
    private int currentState;
    private boolean DESCRIPTION_SITE_ALREADY_SEEN = false;
    Stack<Object> objectStack = new Stack();
    private SAXParser parser;
    Stack<Integer> stateStack = new Stack();
    private final List<String> messageKeys = new ArrayList<String>(4);
    private MultiStatus status;
    private final URI siteLocation;

    private static void debug(String s) {
        Tracing.debug((String)("DefaultSiteParser: " + s));
    }

    private static URLEntry[] getAssociateSites(String associateSitesURL) {
        Document document;
        block6: {
            DocumentBuilderFactory domFactory = SecureXMLUtil.newSecureDocumentBuilderFactory();
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            document = builder.parse(associateSitesURL);
            if (document != null) break block6;
            return null;
        }
        try {
            NodeList mirrorNodes = document.getElementsByTagName(ASSOCIATE_SITE);
            URLEntry[] mirrors = new URLEntry[mirrorNodes.getLength()];
            int i = 0;
            while (i < mirrorNodes.getLength()) {
                Element mirrorNode = (Element)mirrorNodes.item(i);
                mirrors[i] = new URLEntry();
                String infoURL = mirrorNode.getAttribute("url");
                String label = mirrorNode.getAttribute("label");
                mirrors[i].setURL(infoURL);
                mirrors[i].setAnnotation(label);
                if (Tracing.DEBUG_GENERATOR_PARSING) {
                    DefaultSiteParser.debug("Processed mirror: url:" + infoURL + " label:" + label);
                }
                ++i;
            }
            return mirrors;
        }
        catch (Exception e) {
            if (associateSitesURL != null && (associateSitesURL.startsWith("http://") || associateSitesURL.startsWith("https://") || associateSitesURL.startsWith("file://") || associateSitesURL.startsWith("ftp://") || associateSitesURL.startsWith("jar://"))) {
                DefaultSiteParser.log(Messages.DefaultSiteParser_mirrors, e);
            }
            return null;
        }
    }

    static void log(Exception e) {
        LogHelper.log((IStatus)new Status(4, Activator.ID, "Internal Error", (Throwable)e));
    }

    static void log(String message) {
        LogHelper.log((IStatus)new Status(2, Activator.ID, message, null));
    }

    static void log(String message, Exception e) {
        LogHelper.log((IStatus)new Status(2, Activator.ID, message, (Throwable)e));
    }

    public DefaultSiteParser(URI siteLocation) {
        this.siteLocation = siteLocation;
        this.stateStack = new Stack();
        this.objectStack = new Stack();
        this.status = null;
        this.DESCRIPTION_SITE_ALREADY_SEEN = false;
        try {
            parserFactory.setNamespaceAware(true);
            this.parser = parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            DefaultSiteParser.log(e);
        }
        catch (SAXException e) {
            DefaultSiteParser.log(e);
        }
        if (Tracing.DEBUG_GENERATOR_PARSING) {
            DefaultSiteParser.debug("Created");
        }
    }

    public void characters(char[] ch, int start, int length) {
        String text = new String(ch, start, length);
        int state = this.stateStack.peek();
        if (state == 6 || state == 7) {
            this.objectStack.push(text);
        }
    }

    public void endElement(String uri, String localName, String qName) {
        String text = null;
        URLEntry info = null;
        int state = this.stateStack.peek();
        switch (state) {
            case -1: 
            case 3: 
            case 4: {
                this.stateStack.pop();
                break;
            }
            case 0: {
                this.internalError(Messages.DefaultSiteParser_ParsingStackBackToInitialState);
                break;
            }
            case 1: {
                this.stateStack.pop();
                if (!(this.objectStack.peek() instanceof String)) break;
                text = (String)this.objectStack.pop();
                SiteModel site = (SiteModel)this.objectStack.peek();
                site.getDescription().setAnnotation(text);
                break;
            }
            case 2: {
                this.stateStack.pop();
                this.objectStack.pop();
                break;
            }
            case 8: {
                this.stateStack.pop();
                this.objectStack.pop();
                break;
            }
            case 5: {
                this.stateStack.pop();
                if (this.objectStack.peek() instanceof String) {
                    text = (String)this.objectStack.pop();
                    SiteCategory category = (SiteCategory)this.objectStack.peek();
                    category.setDescription(text);
                }
                this.objectStack.pop();
                break;
            }
            case 6: {
                this.stateStack.pop();
                text = "";
                while (this.objectStack.peek() instanceof String) {
                    String newText = (String)this.objectStack.pop();
                    if (this.trailingSpace(newText) && !this.leadingSpace(text)) {
                        text = " " + text;
                    }
                    text = String.valueOf(newText.trim()) + text;
                    if (!this.leadingSpace(newText) || this.leadingSpace(text)) continue;
                    text = " " + text;
                }
                text = text.trim();
                info = (URLEntry)this.objectStack.pop();
                if (text != null) {
                    info.setAnnotation(text);
                }
                SiteModel siteModel = (SiteModel)this.objectStack.peek();
                if (this.DESCRIPTION_SITE_ALREADY_SEEN) {
                    DefaultSiteParser.debug(NLS.bind((String)Messages.DefaultSiteParser_ElementAlreadySet, (Object[])new String[]{this.getState(state)}));
                }
                siteModel.setDescription(info);
                this.DESCRIPTION_SITE_ALREADY_SEEN = true;
                break;
            }
            case 7: {
                SiteCategory category;
                this.stateStack.pop();
                text = "";
                while (this.objectStack.peek() instanceof String) {
                    String newText = (String)this.objectStack.pop();
                    if (this.trailingSpace(newText) && !this.leadingSpace(text)) {
                        text = " " + text;
                    }
                    text = String.valueOf(newText.trim()) + text;
                    if (!this.leadingSpace(newText) || this.leadingSpace(text)) continue;
                    text = " " + text;
                }
                text = text.trim();
                info = (URLEntry)this.objectStack.pop();
                if (text != null) {
                    info.setAnnotation(text);
                }
                if ((category = (SiteCategory)this.objectStack.peek()).getDescription() != null) {
                    this.internalError(NLS.bind((String)Messages.DefaultSiteParser_ElementAlreadySet, (Object[])new String[]{this.getState(state), category.getLabel()}));
                    break;
                }
                this.checkTranslated(info.getAnnotation());
                category.setDescription(info.getAnnotation());
                break;
            }
            default: {
                this.internalError(NLS.bind((String)Messages.DefaultSiteParser_UnknownEndState, (Object[])new String[]{this.getState(state)}));
            }
        }
        if (Tracing.DEBUG_GENERATOR_PARSING) {
            DefaultSiteParser.debug("End Element:" + uri + ":" + localName + ":" + qName);
        }
    }

    private void error(IStatus error) {
        if (this.status == null) {
            this.status = new MultiStatus(PLUGIN_ID, 0, Messages.DefaultSiteParser_ErrorParsingSite, null);
        }
        this.status.add(error);
        if (Tracing.DEBUG_GENERATOR_PARSING) {
            LogHelper.log((IStatus)error);
        }
    }

    public void error(SAXParseException ex) {
        this.logStatus(ex);
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        this.logStatus(ex);
        throw ex;
    }

    private String getState(int state) {
        switch (state) {
            case -1: {
                return "Ignored";
            }
            case 0: {
                return "Initial";
            }
            case 1: {
                return "Site";
            }
            case 2: {
                return "Feature";
            }
            case 8: {
                return "Bundle";
            }
            case 3: {
                return "Archive";
            }
            case 4: {
                return "Category";
            }
            case 5: {
                return "Category Def";
            }
            case 7: {
                return "Description / Category Def";
            }
            case 6: {
                return "Description / Site";
            }
        }
        return Messages.DefaultSiteParser_UnknownState;
    }

    public MultiStatus getStatus() {
        return this.status;
    }

    private void handleCategoryDefState(String elementName, Attributes attributes) {
        if (elementName.equals(FEATURE)) {
            this.stateStack.push(2);
            this.processFeature(attributes);
        } else if (elementName.equals(BUNDLE)) {
            this.stateStack.push(8);
            this.processBundle(attributes);
        } else if (elementName.equals(ARCHIVE)) {
            this.stateStack.push(3);
            this.processArchive(attributes);
        } else if (elementName.equals(CATEGORY_DEF)) {
            this.stateStack.push(5);
            this.processCategoryDef(attributes);
        } else if (elementName.equals(DESCRIPTION)) {
            this.stateStack.push(7);
            this.processInfo(attributes);
        } else {
            this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownElement, (Object[])new String[]{elementName, this.getState(this.currentState)}));
        }
    }

    private void handleCategoryState(String elementName, Attributes attributes) {
        if (elementName.equals(DESCRIPTION)) {
            this.stateStack.push(6);
            this.processInfo(attributes);
        } else if (elementName.equals(FEATURE)) {
            this.stateStack.push(2);
            this.processFeature(attributes);
        } else if (elementName.equals(BUNDLE)) {
            this.stateStack.push(8);
            this.processBundle(attributes);
        } else if (elementName.equals(ARCHIVE)) {
            this.stateStack.push(3);
            this.processArchive(attributes);
        } else if (elementName.equals(CATEGORY_DEF)) {
            this.stateStack.push(5);
            this.processCategoryDef(attributes);
        } else if (elementName.equals(CATEGORY)) {
            this.stateStack.push(4);
            this.processCategory(attributes);
        } else {
            this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownElement, (Object[])new String[]{elementName, this.getState(this.currentState)}));
        }
    }

    private void handleFeatureState(String elementName, Attributes attributes) {
        if (elementName.equals(DESCRIPTION)) {
            this.stateStack.push(6);
            this.processInfo(attributes);
        } else if (elementName.equals(FEATURE)) {
            this.stateStack.push(2);
            this.processFeature(attributes);
        } else if (elementName.equals(ARCHIVE)) {
            this.stateStack.push(3);
            this.processArchive(attributes);
        } else if (elementName.equals(CATEGORY_DEF)) {
            this.stateStack.push(5);
            this.processCategoryDef(attributes);
        } else if (elementName.equals(CATEGORY)) {
            this.stateStack.push(4);
            this.processCategory(attributes);
        } else {
            this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownElement, (Object[])new String[]{elementName, this.getState(this.currentState)}));
        }
    }

    private void handleBundleState(String elementName, Attributes attributes) {
        if (elementName.equals(DESCRIPTION)) {
            this.stateStack.push(6);
            this.processInfo(attributes);
        } else if (elementName.equals(ARCHIVE)) {
            this.stateStack.push(3);
            this.processArchive(attributes);
        } else if (elementName.equals(CATEGORY_DEF)) {
            this.stateStack.push(5);
            this.processCategoryDef(attributes);
        } else if (elementName.equals(CATEGORY)) {
            this.stateStack.push(4);
            this.processCategory(attributes);
        } else {
            this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownElement, (Object[])new String[]{elementName, this.getState(this.currentState)}));
        }
    }

    private void handleInitialState(String elementName, Attributes attributes) throws SAXException {
        if (!elementName.equals(SITE)) {
            this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownElement, (Object[])new String[]{elementName, this.getState(this.currentState)}));
            throw new SAXException(Messages.DefaultSiteParser_InvalidXMLStream);
        }
        this.stateStack.push(1);
        this.processSite(attributes);
    }

    private void handleSiteState(String elementName, Attributes attributes) {
        if (elementName.equals(DESCRIPTION)) {
            this.stateStack.push(6);
            this.processInfo(attributes);
        } else if (elementName.equals(FEATURE)) {
            this.stateStack.push(2);
            this.processFeature(attributes);
        } else if (elementName.equals(BUNDLE)) {
            this.stateStack.push(8);
            this.processBundle(attributes);
        } else if (elementName.equals(ARCHIVE)) {
            this.stateStack.push(3);
            this.processArchive(attributes);
        } else if (elementName.equals(CATEGORY_DEF)) {
            this.stateStack.push(5);
            this.processCategoryDef(attributes);
        } else {
            this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownElement, (Object[])new String[]{elementName, this.getState(this.currentState)}));
        }
    }

    private void internalError(String message) {
        this.error((IStatus)new Status(4, PLUGIN_ID, 0, message, null));
    }

    private void internalErrorUnknownTag(String msg) {
        this.stateStack.push(-1);
        this.internalError(msg);
    }

    private boolean leadingSpace(String str) {
        if (str.length() <= 0) {
            return false;
        }
        return Character.isWhitespace(str.charAt(0));
    }

    private void logStatus(SAXParseException ex) {
        String name = ex.getSystemId();
        name = name == null ? "" : name.substring(1 + name.lastIndexOf("/"));
        if (name.equals("")) {
            name = this.siteLocation.toString();
        }
        Object[] values = new String[]{name, Integer.toString(ex.getLineNumber()), Integer.toString(ex.getColumnNumber()), ex.getMessage()};
        String msg = NLS.bind((String)Messages.DefaultSiteParser_ErrorlineColumnMessage, (Object[])values);
        this.error((IStatus)new Status(4, PLUGIN_ID, msg, (Throwable)ex));
    }

    public SiteModel parse(InputStream in) throws SAXException, IOException {
        this.stateStack.push(0);
        this.currentState = this.stateStack.peek();
        this.parser.parse(new InputSource(in), (DefaultHandler)this);
        if (this.objectStack.isEmpty()) {
            throw new SAXException(Messages.DefaultSiteParser_NoSiteTag);
        }
        if (this.objectStack.peek() instanceof SiteModel) {
            SiteModel site = (SiteModel)this.objectStack.pop();
            site.setMessageKeys(this.messageKeys);
            return site;
        }
        String stack = "";
        Iterator iter = this.objectStack.iterator();
        while (iter.hasNext()) {
            stack = String.valueOf(stack) + iter.next().toString() + "\r\n";
        }
        throw new SAXException(NLS.bind((String)Messages.DefaultSiteParser_WrongParsingStack, (Object[])new String[]{stack}));
    }

    private void processArchive(Attributes attributes) {
        URLEntry archive = new URLEntry();
        String id = attributes.getValue("path");
        if (id == null || id.trim().equals("")) {
            this.internalError(NLS.bind((String)Messages.DefaultSiteParser_Missing, (Object[])new String[]{"path", this.getState(this.currentState)}));
        }
        archive.setAnnotation(id);
        String url = attributes.getValue("url");
        if (url == null || url.trim().equals("")) {
            this.internalError(NLS.bind((String)Messages.DefaultSiteParser_Missing, (Object[])new String[]{ARCHIVE, this.getState(this.currentState)}));
        } else {
            archive.setURL(url);
            SiteModel site = (SiteModel)this.objectStack.peek();
            site.addArchive(archive);
        }
        if (Tracing.DEBUG_GENERATOR_PARSING) {
            DefaultSiteParser.debug("End processing Archive: path:" + id + " url:" + url);
        }
    }

    private void processCategory(Attributes attributes) {
        String category = attributes.getValue("name");
        Object item = this.objectStack.peek();
        if (item instanceof SiteFeature) {
            SiteFeature feature = (SiteFeature)item;
            feature.addCategoryName(category);
        } else if (item instanceof SiteBundle) {
            SiteBundle bundle = (SiteBundle)item;
            bundle.addCategoryName(category);
        }
        if (Tracing.DEBUG_GENERATOR_PARSING) {
            DefaultSiteParser.debug("End processing Category: name:" + category);
        }
    }

    private void processCategoryDef(Attributes attributes) {
        SiteCategory category = new SiteCategory();
        String name = attributes.getValue("name");
        String label = attributes.getValue("label");
        this.checkTranslated(label);
        category.setName(name);
        category.setLabel(label);
        SiteModel site = (SiteModel)this.objectStack.peek();
        site.addCategory(category);
        this.objectStack.push(category);
        if (Tracing.DEBUG_GENERATOR_PARSING) {
            DefaultSiteParser.debug("End processing CategoryDef: name:" + name + " label:" + label);
        }
    }

    private void processFeature(Attributes attributes) {
        boolean noVersion;
        SiteFeature feature = new SiteFeature();
        String urlInfo = attributes.getValue("url");
        String id = attributes.getValue("id");
        String ver = attributes.getValue("version");
        boolean noURL = urlInfo == null || urlInfo.trim().equals("");
        boolean noId = id == null || id.trim().equals("");
        boolean bl = noVersion = ver == null || ver.trim().equals("");
        if (noURL) {
            if (noId || noVersion) {
                this.internalError(NLS.bind((String)Messages.DefaultSiteParser_Missing, (Object[])new String[]{"url", this.getState(this.currentState)}));
            } else {
                urlInfo = FEATURES + id + '_' + ver;
            }
        }
        feature.setURLString(urlInfo);
        String type = attributes.getValue("type");
        feature.setType(type);
        if (noId ^ noVersion) {
            Object[] values = new String[]{id, ver, this.getState(this.currentState)};
            DefaultSiteParser.log(NLS.bind((String)Messages.DefaultFeatureParser_IdOrVersionInvalid, (Object[])values));
        } else {
            feature.setFeatureIdentifier(id);
            feature.setFeatureVersion(ver);
        }
        String label = attributes.getValue("label");
        if (label != null) {
            if ("".equals(label.trim())) {
                label = null;
            }
            this.checkTranslated(label);
        }
        feature.setLabel(label);
        String os = attributes.getValue("os");
        feature.setOS(os);
        String ws = attributes.getValue("ws");
        feature.setWS(ws);
        String nl = attributes.getValue("nl");
        feature.setNL(nl);
        String arch = attributes.getValue("arch");
        feature.setArch(arch);
        String patch = attributes.getValue("patch");
        feature.setPatch(patch);
        SiteModel site = (SiteModel)this.objectStack.peek();
        site.addFeature(feature);
        feature.setSiteModel(site);
        this.objectStack.push(feature);
        if (Tracing.DEBUG_GENERATOR_PARSING) {
            DefaultSiteParser.debug("End Processing DefaultFeature Tag: url:" + urlInfo + " type:" + type);
        }
    }

    private void processBundle(Attributes attributes) {
        boolean noVersion;
        SiteBundle bundle = new SiteBundle();
        String urlInfo = attributes.getValue("url");
        String id = attributes.getValue("id");
        String ver = attributes.getValue("version");
        boolean noURL = urlInfo == null || urlInfo.trim().equals("");
        boolean noId = id == null || id.trim().equals("");
        boolean bl = noVersion = ver == null || ver.trim().equals("");
        if (noURL) {
            if (noId || noVersion) {
                this.internalError(NLS.bind((String)Messages.DefaultSiteParser_Missing, (Object[])new String[]{"url", this.getState(this.currentState)}));
            } else {
                urlInfo = PLUGINS + id + '_' + ver;
            }
        }
        bundle.setURLString(urlInfo);
        String type = attributes.getValue("type");
        bundle.setType(type);
        if (noId ^ noVersion) {
            Object[] values = new String[]{id, ver, this.getState(this.currentState)};
            DefaultSiteParser.log(NLS.bind((String)Messages.DefaultFeatureParser_IdOrVersionInvalid, (Object[])values));
        } else {
            bundle.setBundleIdentifier(id);
            bundle.setBundleVersion(ver);
        }
        String label = attributes.getValue("label");
        if (label != null) {
            if ("".equals(label.trim())) {
                label = null;
            }
            this.checkTranslated(label);
        }
        bundle.setLabel(label);
        String os = attributes.getValue("os");
        bundle.setOS(os);
        String ws = attributes.getValue("ws");
        bundle.setWS(ws);
        String nl = attributes.getValue("nl");
        bundle.setNL(nl);
        String arch = attributes.getValue("arch");
        bundle.setArch(arch);
        String patch = attributes.getValue("patch");
        bundle.setPatch(patch);
        SiteModel site = (SiteModel)this.objectStack.peek();
        site.addBundle(bundle);
        bundle.setSiteModel(site);
        this.objectStack.push(bundle);
        if (Tracing.DEBUG_GENERATOR_PARSING) {
            DefaultSiteParser.debug("End Processing DefaultFeature Tag: url:" + urlInfo + " type:" + type);
        }
    }

    private void processInfo(Attributes attributes) {
        URLEntry inf = new URLEntry();
        String infoURL = attributes.getValue("url");
        inf.setURL(infoURL);
        if (Tracing.DEBUG_GENERATOR_PARSING) {
            DefaultSiteParser.debug("Processed Info: url:" + infoURL);
        }
        this.objectStack.push(inf);
    }

    private void processSite(Attributes attributes) {
        String associateURL;
        String digestURL;
        String pack200;
        SiteModel site = new SiteModel();
        String siteURL = attributes.getValue("url");
        if (siteURL != null && !"".equals(siteURL.trim())) {
            if (!siteURL.endsWith("/") && !siteURL.endsWith(File.separator)) {
                siteURL = String.valueOf(siteURL) + "/";
            }
            site.setLocationURIString(siteURL);
        }
        URLEntry description = new URLEntry();
        description.setURL(DEFAULT_INFO_URL);
        site.setDescription(description);
        String type = attributes.getValue("type");
        site.setType(type);
        String mirrorsURL = attributes.getValue("mirrorsURL");
        if (mirrorsURL != null && mirrorsURL.trim().length() > 0) {
            site.setMirrorsURIString(mirrorsURL);
        }
        if ((pack200 = attributes.getValue("pack200")) != null && Boolean.parseBoolean(pack200)) {
            site.setSupportsPack200(true);
        }
        if ((digestURL = attributes.getValue("digestURL")) != null) {
            site.setDigestURIString(digestURL);
        }
        if ((associateURL = attributes.getValue(ASSOCIATE_SITES_URL)) != null) {
            URI resolvedLocation = this.siteLocation.resolve(associateURL);
            site.setAssociateSites(DefaultSiteParser.getAssociateSites(resolvedLocation.toString()));
        }
        this.objectStack.push(site);
        if (Tracing.DEBUG_GENERATOR_PARSING) {
            DefaultSiteParser.debug("End process Site tag: siteURL:" + siteURL + " type:" + type);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (Tracing.DEBUG_GENERATOR_PARSING) {
            DefaultSiteParser.debug("State: " + this.currentState);
            DefaultSiteParser.debug("Start Element: uri:" + uri + " local Name:" + localName + " qName:" + qName);
        }
        switch (this.currentState) {
            case -1: {
                this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownElement, (Object[])new String[]{localName, this.getState(this.currentState)}));
                break;
            }
            case 0: {
                this.handleInitialState(localName, attributes);
                break;
            }
            case 1: {
                this.handleSiteState(localName, attributes);
                break;
            }
            case 2: {
                this.handleFeatureState(localName, attributes);
                break;
            }
            case 8: {
                this.handleBundleState(localName, attributes);
                break;
            }
            case 3: {
                this.handleSiteState(localName, attributes);
                break;
            }
            case 4: {
                this.handleCategoryState(localName, attributes);
                break;
            }
            case 5: {
                this.handleCategoryDefState(localName, attributes);
                break;
            }
            case 6: {
                this.handleSiteState(localName, attributes);
                break;
            }
            case 7: {
                this.handleSiteState(localName, attributes);
                break;
            }
            default: {
                this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownStartState, (Object[])new String[]{this.getState(this.currentState)}));
            }
        }
        int newState = this.stateStack.peek();
        if (newState != -1) {
            this.currentState = newState;
        }
    }

    private boolean trailingSpace(String str) {
        if (str.length() <= 0) {
            return false;
        }
        return Character.isWhitespace(str.charAt(str.length() - 1));
    }

    private void checkTranslated(String value) {
        if (value != null && value.length() > 1 && value.startsWith("%")) {
            this.messageKeys.add(value.substring(1));
        }
    }
}

