/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.fx.ui.workbench.base.rendering.RendererFactory;
import org.eclipse.fx.ui.workbench.renderers.base.BaseRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.EventProcessor;
import org.eclipse.fx.ui.workbench.renderers.base.Util;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WArea;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WLayoutedWidget;
import org.eclipse.jdt.annotation.NonNull;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class BaseAreaRenderer<N>
extends BaseRenderer<MArea, WArea<N>> {
    @Inject
    RendererFactory factory;

    @PostConstruct
    void init(IEventBroker eventBroker) {
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", new EventHandler(){

            public void handleEvent(Event event) {
                MArea parent;
                Object changedObj = event.getProperty("ChangedElement");
                if (changedObj instanceof MArea && BaseAreaRenderer.this == (parent = (MArea)changedObj).getRenderer()) {
                    if (UIEvents.isADD((Event)event)) {
                        BaseAreaRenderer.this.handleChildrenAddition(parent, Util.asCollection(event, "NewValue"));
                    } else if (UIEvents.isREMOVE((Event)event)) {
                        BaseAreaRenderer.this.handleChildrenRemove(parent, Util.asCollection(event, "OldValue"));
                    }
                }
            }
        });
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*", new EventHandler(){

            public void handleEvent(Event event) {
                String eventType;
                MArea parent;
                Object changedObj = event.getProperty("ChangedElement");
                if (changedObj instanceof MArea && BaseAreaRenderer.this == (parent = (MArea)changedObj).getRenderer() && "SET".equals(eventType = (String)event.getProperty("EventType"))) {
                    MUIElement newValue = (MUIElement)event.getProperty("NewValue");
                    MUIElement oldValue = (MUIElement)event.getProperty("OldValue");
                    BaseAreaRenderer.this.handleSelectedElement(parent, (MPartSashContainerElement)oldValue, (MPartSashContainerElement)newValue);
                }
            }
        });
        EventProcessor.attachVisibleProcessor(eventBroker, this);
    }

    @Override
    public void doProcessContent(MArea element) {
        WArea sash = (WArea)this.getWidget((MUIElement)element);
        if (sash == null) {
            this.getLogger().error("No widget found for '" + element + "'");
            return;
        }
        ArrayList<WLayoutedWidget<MPartSashContainerElement>> list = new ArrayList<WLayoutedWidget<MPartSashContainerElement>>();
        for (MPartSashContainerElement e : element.getChildren()) {
            WLayoutedWidget widget = (WLayoutedWidget)this.engineCreateWidget(e);
            if (widget == null) continue;
            list.add(widget);
        }
        sash.addItems(list);
    }

    public void childRendered(MArea parentElement, MUIElement element) {
        if (this.inContentProcessing((MUIElement)parentElement) || !this.isChildRenderedAndVisible(element)) {
            return;
        }
        int idx = this.getRenderedIndex((MUIElement)parentElement, element);
        WArea sash = (WArea)this.getWidget((MUIElement)parentElement);
        if (sash == null) {
            this.getLogger().error("No widget found for '" + parentElement + "'");
            return;
        }
        List<WLayoutedWidget<MPartSashContainerElement>> l = Collections.singletonList((WLayoutedWidget)element.getWidget());
        sash.addItems(idx, l);
    }

    public void hideChild(MArea container, MUIElement changedObj) {
        WArea sash = (WArea)this.getWidget((MUIElement)container);
        if (sash == null) {
            return;
        }
        WLayoutedWidget widget = (WLayoutedWidget)changedObj.getWidget();
        if (widget != null) {
            sash.removeItem(widget);
        }
    }

    void handleChildrenAddition(@NonNull MArea parent, @NonNull Collection<@NonNull MUIElement> elements) {
        for (MUIElement element : elements) {
            if (!element.isToBeRendered()) continue;
            if (element.getWidget() == null) {
                this.engineCreateWidget(element);
                continue;
            }
            this.childRendered(parent, element);
        }
    }

    void handleChildrenRemove(@NonNull MArea parent, @NonNull Collection<@NonNull MUIElement> elements) {
        for (MUIElement element : elements) {
            if (!element.isToBeRendered() || element.getWidget() == null) continue;
            this.hideChild(parent, element);
        }
    }

    void handleSelectedElement(MArea parent, MPartSashContainerElement oldElement, MPartSashContainerElement newElement) {
    }
}

