/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core.groups;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.core.DebugCoreMessages;

public class GroupLaunch
extends Launch
implements ILaunchesListener2 {
    private boolean fTerminated;
    private boolean fLaunched = false;
    private Map<ILaunch, IProcess[]> subLaunches = new HashMap<ILaunch, IProcess[]>();

    public GroupLaunch(ILaunchConfiguration launchConfiguration, String mode) {
        super(launchConfiguration, mode, null);
        this.getLaunchManager().addLaunchListener(this);
    }

    public void markLaunched() {
        this.fLaunched = true;
    }

    public void addSubLaunch(ILaunch subLaunch) {
        this.subLaunches.put(subLaunch, new IProcess[0]);
    }

    private boolean isChild(ILaunch launch) {
        for (ILaunch subLaunch : this.subLaunches.keySet()) {
            if (subLaunch != launch) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTerminated() {
        if (this.fTerminated) {
            return true;
        }
        if (this.subLaunches.size() == 0) {
            return this.fLaunched;
        }
        for (ILaunch launch : this.subLaunches.keySet()) {
            if (launch.isTerminated()) continue;
            return false;
        }
        return this.fLaunched;
    }

    @Override
    public boolean canTerminate() {
        if (this.subLaunches.size() == 0) {
            return false;
        }
        for (ILaunch launch : this.subLaunches.keySet()) {
            if (!launch.canTerminate()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void terminate() throws DebugException {
        MultiStatus status = new MultiStatus(DebugPlugin.getUniqueIdentifier(), 5012, DebugCoreMessages.Launch_terminate_failed, null);
        this.markLaunched();
        for (ILaunch launch : this.subLaunches.keySet()) {
            if (!launch.canTerminate()) continue;
            try {
                launch.terminate();
            }
            catch (DebugException e) {
                status.merge(e.getStatus());
            }
        }
        if (status.isOK()) {
            return;
        }
        IStatus[] children = status.getChildren();
        if (children.length == 1) {
            throw new DebugException(children[0]);
        }
        throw new DebugException((IStatus)status);
    }

    private void launchTerminated(ILaunch launch) {
        if (this == launch) {
            return;
        }
        if (this.subLaunches.remove(launch) != null && this.subLaunches.size() == 0 && this.fLaunched) {
            this.fTerminated = true;
            this.fireTerminate();
        }
    }

    @Override
    public void launchChanged(ILaunch launch) {
        Object[] newProcesses;
        Object[] oldProcesses;
        if (this == launch) {
            return;
        }
        if (this.isChild(launch) && !Arrays.equals(oldProcesses = this.subLaunches.get(launch), newProcesses = launch.getProcesses())) {
            Object[] objectArray = oldProcesses;
            int n = oldProcesses.length;
            int n2 = 0;
            while (n2 < n) {
                Object oldProcess = objectArray[n2];
                this.removeProcess((IProcess)oldProcess);
                ++n2;
            }
            objectArray = newProcesses;
            n = newProcesses.length;
            n2 = 0;
            while (n2 < n) {
                Object newProcess = objectArray[n2];
                this.addProcess((IProcess)newProcess);
                ++n2;
            }
            this.subLaunches.put(launch, (IProcess[])newProcesses);
        }
    }

    @Override
    public void launchRemoved(ILaunch launch) {
        if (this == launch) {
            IProcess[] processes;
            super.launchRemoved(launch);
            IProcess[] iProcessArray = processes = this.getProcesses();
            int n = processes.length;
            int n2 = 0;
            while (n2 < n) {
                IProcess process = iProcessArray[n2];
                this.removeProcess(process);
                ++n2;
            }
            this.getLaunchManager().removeLaunchListener(this);
        }
    }

    @Override
    public void launchesTerminated(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            this.launchTerminated(launch);
            ++n2;
        }
    }

    @Override
    public void launchesAdded(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            this.launchAdded(launch);
            ++n2;
        }
    }

    @Override
    public void launchesChanged(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            this.launchChanged(launch);
            ++n2;
        }
    }

    @Override
    public void launchesRemoved(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            this.launchRemoved(launch);
            ++n2;
        }
    }
}

