/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.text.ui.internal;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.text.TextUtil;
import org.eclipse.fx.text.ui.IFeature;
import org.eclipse.fx.text.ui.internal.InvisibleCharNode;
import org.eclipse.fx.ui.controls.styledtext.StyledTextArea;
import org.eclipse.fx.ui.controls.styledtext.StyledTextContent;
import org.eclipse.fx.ui.controls.styledtext.model.Annotation;
import org.eclipse.fx.ui.controls.styledtext.model.AnnotationProvider;
import org.eclipse.fx.ui.controls.styledtext.model.TextAnnotation;
import org.eclipse.fx.ui.controls.styledtext.model.TextAnnotationPresenter;
import org.eclipse.jdt.annotation.NonNull;

public class InvisibleCharSupport
implements IFeature {
    @Override
    public Subscription install(final StyledTextArea control) {
        final InvisibleCharAnnotationProvider provider = new InvisibleCharAnnotationProvider(control);
        final InvisibleCharAnnotationPresenter presenter = new InvisibleCharAnnotationPresenter();
        final ChangeListener onTabAdvanceChange = (x, o, n) -> {
            RangeSet rs = TreeRangeSet.create().complement();
            provider.notify((RangeSet<Integer>)rs);
        };
        control.getAnnotationProvider().add((Object)provider);
        control.getAnnotationPresenter().add((Object)presenter);
        control.tabAvanceProperty().addListener(onTabAdvanceChange);
        return new Subscription(){

            public void dispose() {
                control.getAnnotationProvider().remove((Object)provider);
                control.getAnnotationPresenter().remove((Object)presenter);
                control.tabAvanceProperty().removeListener(onTabAdvanceChange);
            }
        };
    }

    public class InvisibleCharAnnotation
    implements TextAnnotation {
        private final String styleClass;
        private final Range range;
        private final String symbol;
        private int tabWidth;

        public Range getRange() {
            return this.range;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public Object getModel() {
            return this.symbol;
        }

        public InvisibleCharAnnotation(String styleClass, String symbol, Range range, int tabWidth) {
            this.styleClass = styleClass;
            this.symbol = symbol;
            this.range = range;
            this.tabWidth = tabWidth;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.range == null ? 0 : this.range.hashCode());
            result = 31 * result + (this.symbol == null ? 0 : this.symbol.hashCode());
            result = 31 * result + this.tabWidth;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InvisibleCharAnnotation other = (InvisibleCharAnnotation)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.range == null ? other.range != null : !this.range.equals((Object)other.range)) {
                return false;
            }
            if (this.symbol == null ? other.symbol != null : !this.symbol.equals(other.symbol)) {
                return false;
            }
            return this.tabWidth == other.tabWidth;
        }

        private InvisibleCharSupport getOuterType() {
            return InvisibleCharSupport.this;
        }
    }

    public class InvisibleCharAnnotationPresenter
    implements TextAnnotationPresenter {
        public boolean isApplicable(Annotation annotation) {
            return annotation instanceof InvisibleCharAnnotation;
        }

        public Node createNode() {
            InvisibleCharNode node = new InvisibleCharNode();
            return node;
        }

        public boolean isVisible(Annotation annotation) {
            return true;
        }

        public void updateNode(Node node, Annotation annotation) {
            InvisibleCharNode n = (InvisibleCharNode)node;
            InvisibleCharAnnotation a = (InvisibleCharAnnotation)annotation;
            n.getStyleClass().setAll((Object[])new String[]{"invisible-char", a.styleClass});
        }

        public String toString() {
            return "InvisibleCharAP@" + this.hashCode();
        }
    }

    public class InvisibleCharAnnotationProvider
    implements AnnotationProvider {
        private StyledTextArea control;
        private List<Consumer<RangeSet<Integer>>> listeners = new ArrayList<Consumer<RangeSet<Integer>>>();

        public InvisibleCharAnnotationProvider(StyledTextArea control) {
            this.control = control;
        }

        public Set<? extends Annotation> computeAnnotations(int index) {
            @NonNull StyledTextContent content = this.control.getContent();
            HashSet<InvisibleCharAnnotation> annotations = new HashSet<InvisibleCharAnnotation>();
            int lineBegin = content.getOffsetAtLine(index);
            int lineLength = content.getLine(index).length();
            String line = content.getTextRange(lineBegin, lineLength);
            int numOfLines = content.getLineCount();
            TextUtil.foreachCharPosition((String)line, (char)'\t', pos -> annotations.add(new InvisibleCharAnnotation("tab", "", Range.closed((Comparable)Integer.valueOf(pos), (Comparable)Integer.valueOf(pos + 1)), this.control.getTabAdvance())));
            TextUtil.foreachCharPosition((String)line, (char)' ', pos -> annotations.add(new InvisibleCharAnnotation("space", "", Range.closed((Comparable)Integer.valueOf(pos), (Comparable)Integer.valueOf(pos + 1)), this.control.getTabAdvance())));
            if (index < numOfLines - 1) {
                if (this.control.getContent().getCharCount() >= this.control.getOffsetAtLine(index) + lineLength + 2 && "\r\n".equals(this.control.getContent().getTextRange(this.control.getOffsetAtLine(index) + lineLength, 2))) {
                    annotations.add(new InvisibleCharAnnotation("winenter", "", Range.closed((Comparable)Integer.valueOf(lineLength), (Comparable)Integer.valueOf(lineLength + 2)), this.control.getTabAdvance()));
                } else {
                    annotations.add(new InvisibleCharAnnotation("enter", "", Range.closed((Comparable)Integer.valueOf(lineLength), (Comparable)Integer.valueOf(lineLength + 1)), this.control.getTabAdvance()));
                }
            }
            return annotations;
        }

        public void notify(RangeSet<Integer> c) {
            this.listeners.stream().forEach(x -> x.accept(c));
        }

        public Subscription registerChangeListener(final Consumer<RangeSet<Integer>> onChange) {
            this.listeners.add(onChange);
            return new Subscription(){

                public void dispose() {
                    InvisibleCharAnnotationProvider.this.listeners.remove(onChange);
                }
            };
        }
    }
}

