/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.dom.rewrite.imports;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.dom.rewrite.imports.ConflictIdentifier;
import org.eclipse.jdt.internal.core.dom.rewrite.imports.ImportAdder;
import org.eclipse.jdt.internal.core.dom.rewrite.imports.ImportComment;
import org.eclipse.jdt.internal.core.dom.rewrite.imports.ImportComparator;
import org.eclipse.jdt.internal.core.dom.rewrite.imports.ImportDeclarationWriter;
import org.eclipse.jdt.internal.core.dom.rewrite.imports.ImportEditor;
import org.eclipse.jdt.internal.core.dom.rewrite.imports.ImportEntry;
import org.eclipse.jdt.internal.core.dom.rewrite.imports.ImportGroupComparator;
import org.eclipse.jdt.internal.core.dom.rewrite.imports.ImportName;
import org.eclipse.jdt.internal.core.dom.rewrite.imports.ImportRewriteConfiguration;
import org.eclipse.jdt.internal.core.dom.rewrite.imports.ImportsDelta;
import org.eclipse.jdt.internal.core.dom.rewrite.imports.NewImportEntry;
import org.eclipse.jdt.internal.core.dom.rewrite.imports.OnDemandComputer;
import org.eclipse.jdt.internal.core.dom.rewrite.imports.OnDemandReduction;
import org.eclipse.jdt.internal.core.dom.rewrite.imports.OriginalImportEntry;
import org.eclipse.jdt.internal.core.dom.rewrite.imports.RewriteSite;
import org.eclipse.jdt.internal.core.dom.rewrite.imports.StaticConflictingSimpleNameFinder;
import org.eclipse.jdt.internal.core.dom.rewrite.imports.TypeConflictingSimpleNameFinder;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.text.edits.TextEdit;

public final class ImportRewriteAnalyzer {
    private final List<OriginalImportEntry> originalImportEntries;
    private final List<ImportName> originalImportsList;
    private final Set<ImportName> originalImportsSet;
    private final ImportDeclarationWriter importDeclarationWriter;
    private final ImportAdder importAdder;
    private final Set<ImportName> importsToAdd;
    private final Set<ImportName> importsToRemove;
    private final boolean reportAllResultantImportsAsCreated;
    private final Set<String> typeExplicitSimpleNames;
    private final Set<String> staticExplicitSimpleNames;
    private final Set<String> implicitImportContainerNames;
    private final ConflictIdentifier conflictIdentifier;
    private final OnDemandComputer onDemandComputer;
    private final Map<ImportName, OriginalImportEntry> importsByNameIdentity;
    private final String lineDelimiter;
    private final ImportEditor importEditor;

    private static int getBlankLinesBetweenImportGroups(IJavaProject javaProject) {
        int num = -1;
        String blankLinesOptionValue = javaProject.getOption("org.eclipse.jdt.core.formatter.blank_lines_between_import_groups", true);
        try {
            num = Integer.parseInt(blankLinesOptionValue);
        }
        catch (NumberFormatException e) {
            String message = String.format("Could not parse the value of %s as an integer: %s", "org.eclipse.jdt.core.formatter.blank_lines_between_import_groups", blankLinesOptionValue);
            Util.log((IStatus)new Status(2, "org.eclipse.jdt.core", message, (Throwable)e));
        }
        return num >= 0 ? num : 1;
    }

    private static boolean shouldInsertSpaceBeforeSemicolon(IJavaProject javaProject) {
        return "insert".equals(javaProject.getOption("org.eclipse.jdt.core.formatter.insert_space_before_semicolon", true));
    }

    private static List<OriginalImportEntry> readOriginalImports(CompilationUnit compilationUnit) {
        List importDeclarations = compilationUnit.imports();
        if (importDeclarations.isEmpty()) {
            return Collections.emptyList();
        }
        List comments = compilationUnit.getCommentList();
        int currentCommentIndex = 0;
        ImportDeclaration firstImport = (ImportDeclaration)importDeclarations.get(0);
        PackageDeclaration packageDeclaration = compilationUnit.getPackage();
        int firstImportStartPosition = packageDeclaration == null ? firstImport.getStartPosition() : compilationUnit.getExtendedStartPosition(packageDeclaration) + compilationUnit.getExtendedLength(packageDeclaration);
        while (currentCommentIndex < comments.size() && ((Comment)comments.get(currentCommentIndex)).getStartPosition() < firstImportStartPosition) {
            ++currentCommentIndex;
        }
        ArrayList<OriginalImportEntry> imports = new ArrayList<OriginalImportEntry>(importDeclarations.size());
        int previousExtendedEndPosition = -1;
        for (ImportDeclaration currentImport : importDeclarations) {
            int precedingLineDelimiters;
            Region leadingWhitespaceRegion;
            int importAndCommentsStartPosition;
            int extendedEndPosition = compilationUnit.getExtendedStartPosition(currentImport) + compilationUnit.getExtendedLength(currentImport);
            int commentAfterImportIndex = currentCommentIndex;
            while (commentAfterImportIndex < comments.size() && ((Comment)comments.get(commentAfterImportIndex)).getStartPosition() < extendedEndPosition) {
                ++commentAfterImportIndex;
            }
            List<Object> importComments = commentAfterImportIndex == currentCommentIndex ? Collections.emptyList() : ImportRewriteAnalyzer.selectImportComments(compilationUnit, comments, currentImport.getStartPosition(), currentCommentIndex, commentAfterImportIndex);
            int n = importAndCommentsStartPosition = importComments.isEmpty() ? currentImport.getStartPosition() : Math.min(currentImport.getStartPosition(), ((ImportComment)importComments.get((int)0)).region.getOffset());
            if (previousExtendedEndPosition == -1) {
                leadingWhitespaceRegion = new Region(importAndCommentsStartPosition, 0);
                precedingLineDelimiters = 0;
            } else {
                leadingWhitespaceRegion = new Region(previousExtendedEndPosition, importAndCommentsStartPosition - previousExtendedEndPosition);
                int importAndCommentsFirstLine = compilationUnit.getLineNumber(importAndCommentsStartPosition);
                int lastLineOfPrevious = compilationUnit.getLineNumber(previousExtendedEndPosition - 1);
                precedingLineDelimiters = importAndCommentsFirstLine - lastLineOfPrevious;
            }
            Region importAndCommentsRegion = new Region(importAndCommentsStartPosition, extendedEndPosition - importAndCommentsStartPosition);
            imports.add(new OriginalImportEntry(ImportName.createFor(currentImport), importComments, precedingLineDelimiters, (IRegion)leadingWhitespaceRegion, (IRegion)importAndCommentsRegion));
            currentCommentIndex = commentAfterImportIndex;
            previousExtendedEndPosition = extendedEndPosition;
        }
        return imports;
    }

    private static List<ImportComment> selectImportComments(CompilationUnit compilationUnit, List<Comment> comments, int importDeclarationStartPosition, int commentStartIndex, int commentEndIndex) {
        ArrayList<ImportComment> importComments = new ArrayList<ImportComment>(comments.size());
        Iterator<Comment> commentIterator = comments.subList(commentStartIndex, commentEndIndex).iterator();
        Comment currentComment = commentIterator.hasNext() ? commentIterator.next() : null;
        while (currentComment != null) {
            int succeedingLineDelims;
            int currentCommentStartPosition = currentComment.getStartPosition();
            int currentCommentLength = currentComment.getLength();
            Comment nextComment = commentIterator.hasNext() ? commentIterator.next() : null;
            int nextCommentStartPosition = nextComment == null ? Integer.MAX_VALUE : nextComment.getStartPosition();
            int nextStartPosition = Math.min(importDeclarationStartPosition, nextCommentStartPosition);
            if (nextStartPosition == Integer.MAX_VALUE) {
                succeedingLineDelims = 0;
            } else {
                int currentCommentEndLine = compilationUnit.getLineNumber(currentCommentStartPosition + currentCommentLength);
                int nextStartLine = compilationUnit.getLineNumber(nextStartPosition);
                succeedingLineDelims = nextStartLine - currentCommentEndLine;
            }
            importComments.add(new ImportComment((IRegion)new Region(currentCommentStartPosition, currentCommentLength), succeedingLineDelims));
            currentComment = nextComment;
        }
        return importComments;
    }

    private static RewriteSite determineRewriteSite(CompilationUnit compilationUnit, List<OriginalImportEntry> originalImports) {
        IRegion importsRegion = ImportRewriteAnalyzer.determineImportsRegion(originalImports);
        IRegion surroundingRegion = ImportRewriteAnalyzer.determineSurroundingRegion(compilationUnit, importsRegion);
        boolean hasPrecedingElements = surroundingRegion.getOffset() != 0;
        boolean hasSucceedingElements = surroundingRegion.getOffset() + surroundingRegion.getLength() != compilationUnit.getLength();
        return new RewriteSite(surroundingRegion, importsRegion, hasPrecedingElements, hasSucceedingElements);
    }

    private static IRegion determineImportsRegion(List<OriginalImportEntry> originalImports) {
        if (originalImports == null || originalImports.isEmpty()) {
            return null;
        }
        OriginalImportEntry firstImport = originalImports.get(0);
        int start = firstImport.declarationAndComments.getOffset();
        OriginalImportEntry lastImport = originalImports.get(originalImports.size() - 1);
        int end = lastImport.declarationAndComments.getOffset() + lastImport.declarationAndComments.getLength();
        return new Region(start, end - start);
    }

    private static IRegion determineSurroundingRegion(CompilationUnit compilationUnit, IRegion importsRegion) {
        int positionAfterImports;
        int surroundingStart;
        NavigableMap<Integer, ASTNode> nodesTreeMap = ImportRewriteAnalyzer.mapTopLevelNodes(compilationUnit);
        if (importsRegion == null) {
            PackageDeclaration packageDeclaration = compilationUnit.getPackage();
            surroundingStart = packageDeclaration != null ? compilationUnit.getExtendedStartPosition(packageDeclaration) + compilationUnit.getExtendedLength(packageDeclaration) : 0;
            positionAfterImports = surroundingStart;
        } else {
            Map.Entry<Integer, ASTNode> lowerEntry = nodesTreeMap.lowerEntry(importsRegion.getOffset());
            if (lowerEntry != null) {
                ASTNode precedingNode = lowerEntry.getValue();
                surroundingStart = precedingNode.getStartPosition() + precedingNode.getLength();
            } else {
                surroundingStart = 0;
            }
            positionAfterImports = importsRegion.getOffset() + importsRegion.getLength();
        }
        Integer ceilingKey = nodesTreeMap.ceilingKey(positionAfterImports);
        int surroundingEnd = ceilingKey != null ? ceilingKey.intValue() : compilationUnit.getLength();
        return new Region(surroundingStart, surroundingEnd - surroundingStart);
    }

    private static NavigableMap<Integer, ASTNode> mapTopLevelNodes(CompilationUnit compilationUnit) {
        TreeMap<Integer, ASTNode> map = new TreeMap<Integer, ASTNode>();
        ArrayList<ASTNode> nodes = new ArrayList<ASTNode>();
        if (compilationUnit.getPackage() != null) {
            nodes.add(compilationUnit.getPackage());
        }
        nodes.addAll(compilationUnit.imports());
        nodes.addAll(compilationUnit.types());
        for (Comment comment : compilationUnit.getCommentList()) {
            if (comment.getParent() != null) continue;
            nodes.add(comment);
        }
        for (ASTNode node : nodes) {
            map.put(node.getStartPosition(), node);
        }
        return map;
    }

    private static Map<ImportName, OriginalImportEntry> mapImportsByNameIdentity(List<OriginalImportEntry> imports) {
        IdentityHashMap<ImportName, OriginalImportEntry> importsByName = new IdentityHashMap<ImportName, OriginalImportEntry>();
        for (OriginalImportEntry currentImport : imports) {
            importsByName.put(currentImport.importName, currentImport);
        }
        return Collections.unmodifiableMap(importsByName);
    }

    private static List<ImportName> subtractImports(Collection<ImportName> existingImports, Set<ImportName> importsToSubtract) {
        ArrayList<ImportName> remainingImports = new ArrayList<ImportName>(existingImports.size());
        for (ImportName existingImport : existingImports) {
            if (importsToSubtract.contains(existingImport)) continue;
            remainingImports.add(existingImport);
        }
        return remainingImports;
    }

    public ImportRewriteAnalyzer(ICompilationUnit cu, CompilationUnit astRoot, ImportRewriteConfiguration configuration) throws JavaModelException {
        this.originalImportEntries = Collections.unmodifiableList(ImportRewriteAnalyzer.readOriginalImports(astRoot));
        ArrayList<ImportName> importsList = new ArrayList<ImportName>(this.originalImportEntries.size());
        HashSet<ImportName> importsSet = new HashSet<ImportName>();
        for (ImportEntry importEntry : this.originalImportEntries) {
            ImportName importName = importEntry.importName;
            importsList.add(importName);
            importsSet.add(importName);
        }
        this.originalImportsList = Collections.unmodifiableList(importsList);
        this.originalImportsSet = Collections.unmodifiableSet(importsSet);
        this.importsToAdd = new LinkedHashSet<ImportName>();
        this.importsToRemove = new LinkedHashSet<ImportName>();
        if (configuration.originalImportHandling.shouldRemoveOriginalImports()) {
            this.importsToRemove.addAll(importsSet);
            this.reportAllResultantImportsAsCreated = true;
        } else {
            this.reportAllResultantImportsAsCreated = false;
        }
        this.typeExplicitSimpleNames = new HashSet<String>();
        this.staticExplicitSimpleNames = new HashSet<String>();
        ImportGroupComparator importGroupComparator = new ImportGroupComparator(configuration.importOrder);
        JavaProject javaProject = (JavaProject)cu.getJavaProject();
        this.importAdder = configuration.originalImportHandling.createImportAdder(new ImportComparator(importGroupComparator, configuration.typeContainerSorting.createContainerComparator(javaProject), configuration.staticContainerSorting.createContainerComparator(javaProject)));
        this.implicitImportContainerNames = configuration.implicitImportIdentification.determineImplicitImportContainers(cu);
        this.onDemandComputer = new OnDemandComputer(configuration.typeOnDemandThreshold, configuration.staticOnDemandThreshold);
        this.conflictIdentifier = new ConflictIdentifier(this.onDemandComputer, new TypeConflictingSimpleNameFinder(javaProject, new SearchEngine()), new StaticConflictingSimpleNameFinder(javaProject), this.implicitImportContainerNames);
        this.importsByNameIdentity = ImportRewriteAnalyzer.mapImportsByNameIdentity(this.originalImportEntries);
        this.importDeclarationWriter = new ImportDeclarationWriter(ImportRewriteAnalyzer.shouldInsertSpaceBeforeSemicolon(javaProject));
        this.lineDelimiter = cu.findRecommendedLineSeparator();
        this.importEditor = new ImportEditor(this.lineDelimiter, configuration.originalImportHandling.shouldFixAllLineDelimiters(), ImportRewriteAnalyzer.getBlankLinesBetweenImportGroups(javaProject) + 1, importGroupComparator, this.originalImportEntries, ImportRewriteAnalyzer.determineRewriteSite(astRoot, this.originalImportEntries), this.importDeclarationWriter);
    }

    public void addImport(boolean isStatic, String qualifiedName) {
        ImportName importToAdd = ImportName.createFor(isStatic, qualifiedName);
        this.importsToAdd.add(importToAdd);
        this.importsToRemove.remove(importToAdd);
    }

    public void removeImport(boolean isStatic, String qualifiedName) {
        ImportName importToRemove = ImportName.createFor(isStatic, qualifiedName);
        this.importsToAdd.remove(importToRemove);
        this.importsToRemove.add(importToRemove);
    }

    public void requireExplicitImport(boolean isStatic, String simpleName) {
        if (isStatic) {
            this.staticExplicitSimpleNames.add(simpleName);
        } else {
            this.typeExplicitSimpleNames.add(simpleName);
        }
    }

    public RewriteResult analyzeRewrite(IProgressMonitor monitor) throws JavaModelException {
        List<ImportName> computedImportOrder = this.computeImportOrder(monitor);
        List<ImportEntry> resultingImportEntries = this.matchExistingOrCreateNew(computedImportOrder);
        TextEdit edit = this.importEditor.createTextEdit(resultingImportEntries);
        HashSet<ImportName> createdImports = new HashSet<ImportName>(computedImportOrder);
        if (!this.reportAllResultantImportsAsCreated) {
            createdImports.removeAll(this.originalImportsSet);
        }
        return new RewriteResult(edit, createdImports);
    }

    private List<ImportName> computeImportOrder(IProgressMonitor progressMonitor) throws JavaModelException {
        HashSet<ImportName> importsWithAdditionsAndRemovals = new HashSet<ImportName>(this.originalImportsSet);
        importsWithAdditionsAndRemovals.addAll(this.importsToAdd);
        importsWithAdditionsAndRemovals.removeAll(this.importsToRemove);
        Set<ImportName> touchedContainers = this.determineTouchedContainers();
        ConflictIdentifier.Conflicts conflicts = this.conflictIdentifier.identifyConflicts(importsWithAdditionsAndRemovals, touchedContainers, this.typeExplicitSimpleNames, this.staticExplicitSimpleNames, progressMonitor);
        HashSet<String> allTypeExplicitSimpleNames = new HashSet<String>(this.typeExplicitSimpleNames);
        allTypeExplicitSimpleNames.addAll(conflicts.typeConflicts);
        HashSet<String> allStaticExplicitSimpleNames = new HashSet<String>(this.staticExplicitSimpleNames);
        allStaticExplicitSimpleNames.addAll(conflicts.staticConflicts);
        Set<ImportName> implicitImports = this.identifyImplicitImports(this.importsToAdd, allTypeExplicitSimpleNames);
        List<ImportName> importsWithoutImplicits = ImportRewriteAnalyzer.subtractImports(importsWithAdditionsAndRemovals, implicitImports);
        Collection<OnDemandReduction> onDemandReductions = this.onDemandComputer.identifyPossibleReductions(new HashSet<ImportName>(importsWithoutImplicits), touchedContainers, allTypeExplicitSimpleNames, allStaticExplicitSimpleNames);
        ImportsDelta delta = this.computeDelta(implicitImports, onDemandReductions);
        List<ImportName> importsWithRemovals = ImportRewriteAnalyzer.subtractImports(this.originalImportsList, delta.importsToRemove);
        List<ImportName> importsWithAdditions = this.importAdder.addImports(importsWithRemovals, delta.importsToAdd);
        return importsWithAdditions;
    }

    private Set<ImportName> determineTouchedContainers() {
        ArrayList<ImportName> touchedContainers = new ArrayList<ImportName>(this.importsToAdd.size() + this.importsToRemove.size());
        for (ImportName addedImport : this.importsToAdd) {
            touchedContainers.add(addedImport.getContainerOnDemand());
        }
        for (ImportName removedImport : this.importsToRemove) {
            touchedContainers.add(removedImport.getContainerOnDemand());
        }
        return Collections.unmodifiableSet(new HashSet(touchedContainers));
    }

    private Set<ImportName> identifyImplicitImports(Collection<ImportName> addedImports, Set<String> allTypeExplicitSimpleNames) {
        if (this.implicitImportContainerNames.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<ImportName> implicits = new ArrayList<ImportName>(addedImports.size());
        for (ImportName addedImport : addedImports) {
            boolean isImplicit;
            boolean bl = isImplicit = this.implicitImportContainerNames.contains(addedImport.containerName) && !allTypeExplicitSimpleNames.contains(addedImport.simpleName);
            if (!isImplicit) continue;
            implicits.add(addedImport);
        }
        if (implicits.isEmpty()) {
            return Collections.emptySet();
        }
        return new HashSet<ImportName>(implicits);
    }

    private List<ImportEntry> matchExistingOrCreateNew(Collection<ImportName> importNames) {
        ArrayList<ImportEntry> importEntries = new ArrayList<ImportEntry>(importNames.size());
        for (ImportName importName : importNames) {
            ImportEntry importEntry = this.importsByNameIdentity.get(importName);
            if (importEntry == null) {
                importEntry = new NewImportEntry(importName);
            }
            importEntries.add(importEntry);
        }
        return importEntries;
    }

    private ImportsDelta computeDelta(Collection<ImportName> implicitImports, Collection<OnDemandReduction> onDemandReductions) {
        ArrayList<ImportName> additions = new ArrayList<ImportName>(this.originalImportsList.size());
        additions.addAll(this.importsToAdd);
        ArrayList<ImportName> removals = new ArrayList<ImportName>(this.originalImportsList.size());
        removals.addAll(this.importsToRemove);
        removals.addAll(implicitImports);
        additions.removeAll(removals);
        for (OnDemandReduction onDemandReduction : onDemandReductions) {
            additions.removeAll(onDemandReduction.reducibleImports);
            removals.addAll(onDemandReduction.reducibleImports);
            additions.add(onDemandReduction.containerOnDemand);
            removals.remove(onDemandReduction.containerOnDemand);
        }
        return new ImportsDelta(additions, removals);
    }

    public static final class RewriteResult {
        private final TextEdit textEdit;
        private final Set<ImportName> createdImports;

        RewriteResult(TextEdit textEdit, Set<ImportName> createdImports) {
            this.textEdit = textEdit;
            this.createdImports = Collections.unmodifiableSet(createdImports);
        }

        public TextEdit getTextEdit() {
            return this.textEdit;
        }

        public String[] getCreatedImports() {
            return this.extractQualifiedNames(false, this.createdImports);
        }

        public String[] getCreatedStaticImports() {
            return this.extractQualifiedNames(true, this.createdImports);
        }

        private String[] extractQualifiedNames(boolean b, Collection<ImportName> imports) {
            ArrayList<String> names = new ArrayList<String>(imports.size());
            for (ImportName importName : imports) {
                if (importName.isStatic != b) continue;
                names.add(importName.qualifiedName);
            }
            return names.toArray(new String[names.size()]);
        }
    }
}

