/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.text.ui;

import java.util.Collection;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.stage.PopupWindow;
import org.eclipse.fx.text.ui.ITextHover;
import org.eclipse.fx.text.ui.TextViewer;
import org.eclipse.fx.ui.controls.styledtext.StyledTextArea;
import org.eclipse.fx.ui.controls.styledtext.events.TextHoverEvent;

public class TextViewerHoverManager {
    private final TextViewer textViewer;
    private final PopupWindow popup;
    private final BorderPane root;

    public TextViewerHoverManager(TextViewer textViewer) {
        this.textViewer = textViewer;
        this.popup = new PopupWindow(){};
        this.popup.setAutoFix(false);
        this.popup.setAutoHide(false);
        this.textViewer.getTextWidget().sceneProperty().addListener(e -> {
            if (textViewer.getTextWidget().getScene() != null) {
                this.popup.getScene().getStylesheets().setAll((Collection)textViewer.getTextWidget().getScene().getStylesheets());
            }
        });
        this.root = new BorderPane();
        this.root.getStyleClass().add((Object)"styled-text-hover");
        this.popup.getScene().setRoot((Parent)this.root);
    }

    public TextViewer getTextViewer() {
        return this.textViewer;
    }

    public PopupWindow getPopup() {
        return this.popup;
    }

    public BorderPane getRoot() {
        return this.root;
    }

    public void install(StyledTextArea styledTextArea) {
        styledTextArea.addEventHandler(TextHoverEvent.HOVER, e -> {
            if (e.getOffset() > 0) {
                ITextHover hover = this.getTextViewer().getTextHover(e.getOffset(), 255);
                if (hover != null) {
                    String text = hover.getHoverInfo(this.getTextViewer(), hover.getHoverRegion(this.getTextViewer(), e.getOffset()));
                    if (text != null && !text.isEmpty()) {
                        Label value = new Label(text);
                        value.getStyleClass().add((Object)"styled-text-hover-text");
                        this.getRoot().setCenter((Node)value);
                        Point2D locationAtOffset = this.getTextViewer().getTextWidget().getLocationAtOffset(e.getOffsetTokenStart());
                        double x = e.getScreenX();
                        if (locationAtOffset != null) {
                            x = this.getTextViewer().getTextWidget().localToScreen(locationAtOffset.getX(), 0.0).getX();
                        }
                        this.getPopup().show(this.getTextViewer().getTextWidget().getScene().getWindow(), x, e.getScreenY() + 5.0);
                    } else {
                        this.getPopup().hide();
                    }
                } else {
                    this.getPopup().hide();
                }
            } else {
                this.getPopup().hide();
            }
        });
    }
}

