/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.fx.services.internal;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javafx.beans.property.SetProperty;
import javafx.beans.property.SimpleSetProperty;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.fx.code.editor.Input;
import org.eclipse.fx.code.editor.fx.services.CompletionProposalPresenter;
import org.eclipse.fx.code.editor.services.CompletionProposal;
import org.eclipse.fx.code.editor.services.HoverInformationProvider;
import org.eclipse.fx.code.editor.services.ProposalComputer;
import org.eclipse.fx.core.preferences.Preference;
import org.eclipse.fx.text.ui.Feature;
import org.eclipse.fx.text.ui.ITextHover;
import org.eclipse.fx.text.ui.ITextViewer;
import org.eclipse.fx.text.ui.contentassist.ContentAssistContextData;
import org.eclipse.fx.text.ui.contentassist.ContentAssistant;
import org.eclipse.fx.text.ui.contentassist.ICompletionProposal;
import org.eclipse.fx.text.ui.contentassist.IContentAssistant;
import org.eclipse.fx.text.ui.contentassist.IContextInformation;
import org.eclipse.fx.text.ui.presentation.IPresentationReconciler;
import org.eclipse.fx.text.ui.presentation.PresentationReconciler;
import org.eclipse.fx.text.ui.source.AnnotationPresenter;
import org.eclipse.fx.text.ui.source.ISourceViewer;
import org.eclipse.fx.text.ui.source.SourceViewerConfiguration;
import org.eclipse.fx.ui.controls.styledtext.TextSelection;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.IAnnotationModel;

public class DefaultSourceViewerConfiguration
extends SourceViewerConfiguration {
    private final Input<?> input;
    private final PresentationReconciler reconciler;
    private final ProposalComputer proposalComputer;
    private final IAnnotationModel annotationModel;
    private final AnnotationPresenter annotationPresenter;
    private final HoverInformationProvider hoverInformationProvider;
    private final CompletionProposalPresenter proposalPresenter;
    private ContentAssistant contentAssistant;
    private SetProperty<Feature> featureSet = new SimpleSetProperty((Object)this, "featureSet", FXCollections.observableSet((Object[])new Feature[0]));

    @Inject
    public DefaultSourceViewerConfiguration(Input<?> input, PresentationReconciler reconciler, @Optional ProposalComputer proposalComputer, @Optional IAnnotationModel annotationModel, @Optional AnnotationPresenter annotationPresenter, @Optional HoverInformationProvider hoverInformationProvider, @Optional CompletionProposalPresenter proposalPresenter) {
        this.input = input;
        this.hoverInformationProvider = hoverInformationProvider;
        this.reconciler = reconciler;
        this.proposalComputer = proposalComputer;
        this.annotationModel = annotationModel;
        this.proposalPresenter = proposalPresenter == null ? DefaultProposal::new : proposalPresenter;
        this.annotationPresenter = annotationPresenter;
    }

    @Inject
    public void setFeatureSet(@Preference(key="editorFeatures", nodePath="org.eclipse.fx.code.editor") Set<Feature> featureSet) {
        this.featureSet.clear();
        if (featureSet != null) {
            this.featureSet.addAll(featureSet);
        } else {
            this.featureSet.add((Object)Feature.SHOW_LINE_NUMBERS);
        }
    }

    public SetProperty<Feature> getFeatures() {
        return this.featureSet;
    }

    public String getStyleclassName() {
        return "source-viewer";
    }

    public final IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        return this.reconciler;
    }

    public IContentAssistant getContentAssist() {
        if (this.proposalComputer != null) {
            if (this.contentAssistant == null) {
                this.contentAssistant = new ContentAssistant(this::computeProposals);
            }
            return this.contentAssistant;
        }
        return super.getContentAssist();
    }

    List<ICompletionProposal> computeProposals(ContentAssistContextData data) {
        try {
            return ((List)this.proposalComputer.compute(new ProposalComputer.ProposalContext(this.input, data.document, data.offset)).get()).stream().map(this.proposalPresenter::createProposal).collect(Collectors.toList());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return Collections.emptyList();
    }

    public IAnnotationModel getAnnotationModel() {
        return this.annotationModel;
    }

    public AnnotationPresenter getAnnotationPresenter() {
        return this.annotationPresenter;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, final String contentType) {
        if (this.hoverInformationProvider != null) {
            return new ITextHover(){

                public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
                    return DefaultSourceViewerConfiguration.this.hoverInformationProvider.getHoverRegion(contentType, offset);
                }

                public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
                    CharSequence information = DefaultSourceViewerConfiguration.this.hoverInformationProvider.getHoverInformation(contentType, hoverRegion);
                    return information == null ? null : information.toString();
                }
            };
        }
        return super.getTextHover(sourceViewer, contentType);
    }

    static class DefaultProposal
    implements ICompletionProposal {
        private final CompletionProposal proposal;

        public DefaultProposal(CompletionProposal proposal) {
            this.proposal = proposal;
        }

        public CharSequence getLabel() {
            return this.proposal.getLabel();
        }

        public Node getGraphic() {
            return null;
        }

        public void apply(IDocument document) {
            this.proposal.apply(document);
        }

        public TextSelection getSelection(IDocument document) {
            CompletionProposal.TextSelection selection = this.proposal.getSelection(document);
            return selection == null ? TextSelection.EMPTY : new TextSelection(selection.offset, selection.length);
        }

        public IContextInformation getContextInformation() {
            return new IContextInformation(){

                public String getInformationDisplayString() {
                    return null;
                }

                public Node getGraphic() {
                    return null;
                }

                public int getContextInformationPosition() {
                    return 0;
                }

                public String getContextDisplayString() {
                    return null;
                }
            };
        }

        public String getHoverInfo() {
            return null;
        }
    }
}

