/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parser.packrat.matching;

import org.eclipse.xtext.parser.packrat.matching.CharacterAlternatives;
import org.eclipse.xtext.parser.packrat.matching.CharacterArray;
import org.eclipse.xtext.parser.packrat.matching.CharacterRange;
import org.eclipse.xtext.parser.packrat.matching.SingleCharacter;

public interface ICharacterClass {
    public boolean matches(char var1);

    public static class Factory {
        public static ICharacterClass nullClass() {
            return NullCharacterClass.INSTANCE;
        }

        public static ICharacterClass create(char ... characters) {
            if (characters.length == 1) {
                return new SingleCharacter(characters[0]);
            }
            return new CharacterArray(characters);
        }

        public static ICharacterClass createRange(char min, char max) {
            return new CharacterRange(min, max);
        }

        public static ICharacterClass join(ICharacterClass ... classes) {
            return new CharacterAlternatives(classes);
        }

        public static ICharacterClass invert(ICharacterClass clazz) {
            return new ICharacterClass(){

                @Override
                public boolean matches(char candidate) {
                    return !ICharacterClass.this.matches(candidate);
                }
            };
        }

        private static class NullCharacterClass
        implements ICharacterClass {
            private static ICharacterClass INSTANCE = new NullCharacterClass();

            private NullCharacterClass() {
            }

            @Override
            public boolean matches(char candidate) {
                return false;
            }
        }
    }
}

