/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.linking.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.diagnostics.DiagnosticMessage;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.linking.ILinkingDiagnosticMessageProvider;
import org.eclipse.xtext.linking.impl.IllegalNodeException;

public class LinkingDiagnosticMessageProvider
implements ILinkingDiagnosticMessageProvider.Extended {
    @Override
    public DiagnosticMessage getUnresolvedProxyMessage(ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context) {
        EClass referenceType = context.getReference().getEReferenceType();
        String linkText = "";
        try {
            linkText = context.getLinkText();
        }
        catch (IllegalNodeException e) {
            linkText = e.getNode().getText();
        }
        String msg = "Couldn't resolve reference to " + referenceType.getName() + " '" + linkText + "'.";
        return new DiagnosticMessage(msg, Severity.ERROR, "org.eclipse.xtext.diagnostics.Diagnostic.Linking", new String[0]);
    }

    @Override
    public DiagnosticMessage getIllegalNodeMessage(ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context, IllegalNodeException ex) {
        String message = ex.getMessage();
        return new DiagnosticMessage(message, Severity.ERROR, "org.eclipse.xtext.diagnostics.Diagnostic.Linking", new String[0]);
    }

    @Override
    public DiagnosticMessage getIllegalCrossReferenceMessage(ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context, CrossReference reference) {
        String message = "Cannot find reference " + reference;
        return new DiagnosticMessage(message, Severity.ERROR, "org.eclipse.xtext.diagnostics.Diagnostic.Linking", new String[0]);
    }

    @Override
    public DiagnosticMessage getViolatedBoundsConstraintMessage(ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context, int size) {
        String message = "Too many matches for reference to '" + context.getLinkText() + "'. " + "Feature " + context.getReference().getName() + " can only hold " + context.getReference().getUpperBound() + " reference" + (context.getReference().getUpperBound() != 1 ? "s" : "") + " but found " + size + " candidate" + (size != 1 ? "s" : "");
        return new DiagnosticMessage(message, Severity.ERROR, "org.eclipse.xtext.diagnostics.Diagnostic.Linking", new String[0]);
    }

    @Override
    public DiagnosticMessage getViolatedUniqueConstraintMessage(ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context) {
        String message = "Cannot refer to '" + context.getLinkText() + "' more than once.";
        return new DiagnosticMessage(message, Severity.ERROR, "org.eclipse.xtext.diagnostics.Diagnostic.Linking", new String[0]);
    }
}

