/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.regionaccess.internal;

import java.util.LinkedList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.formatting2.regionaccess.internal.AbstractEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.internal.StringBasedRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.internal.StringComment;
import org.eclipse.xtext.formatting2.regionaccess.internal.StringEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.internal.StringHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.internal.StringSemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.internal.StringWhitespace;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.ISequenceAcceptor;
import org.eclipse.xtext.serializer.analysis.SerializationContext;
import org.eclipse.xtext.util.Strings;

public class TextRegionAccessBuildingSequencer
implements ISequenceAcceptor {
    private StringHiddenRegion last;
    private StringBasedRegionAccess regionAccess;
    private final LinkedList<AbstractEObjectRegion> stack = new LinkedList();

    @Override
    public void acceptAssignedCrossRefDatatype(RuleCall rc, String token, EObject value, int index, ICompositeNode node) {
        this.appendSemantic(rc, token);
    }

    @Override
    public void acceptAssignedCrossRefEnum(RuleCall enumRC, String token, EObject value, int index, ICompositeNode node) {
        this.appendSemantic(enumRC, token);
    }

    @Override
    public void acceptAssignedCrossRefKeyword(Keyword kw, String token, EObject value, int index, ILeafNode node) {
        this.appendSemantic(kw, token);
    }

    @Override
    public void acceptAssignedCrossRefTerminal(RuleCall rc, String token, EObject value, int index, ILeafNode node) {
        this.appendSemantic(rc, token);
    }

    @Override
    public void acceptAssignedDatatype(RuleCall datatypeRC, String token, Object value, int index, ICompositeNode node) {
        this.appendSemantic(datatypeRC, token);
    }

    @Override
    public void acceptAssignedEnum(RuleCall enumRC, String token, Object value, int index, ICompositeNode node) {
        this.appendSemantic(enumRC, token);
    }

    @Override
    public void acceptAssignedKeyword(Keyword keyword, String token, Object value, int index, ILeafNode node) {
        this.appendSemantic(keyword, token);
    }

    @Override
    public void acceptAssignedTerminal(RuleCall terminalRC, String token, Object value, int index, ILeafNode node) {
        this.appendSemantic(terminalRC, token);
    }

    @Override
    public void acceptComment(AbstractRule rule, String token, ILeafNode node) {
        int offset = this.regionAccess.append(token);
        this.last.setUndefined(false);
        this.last.addPart(this.createComment(rule, token, offset));
    }

    @Override
    public void acceptUnassignedAction(Action action) {
    }

    @Override
    public void acceptUnassignedDatatype(RuleCall datatypeRC, String token, ICompositeNode node) {
        this.appendSemantic(datatypeRC, token);
    }

    @Override
    public void acceptUnassignedEnum(RuleCall enumRC, String token, ICompositeNode node) {
        this.appendSemantic(enumRC, token);
    }

    @Override
    public void acceptUnassignedKeyword(Keyword keyword, String token, ILeafNode node) {
        this.appendSemantic(keyword, token);
    }

    @Override
    public void acceptUnassignedTerminal(RuleCall terminalRC, String token, ILeafNode node) {
        this.appendSemantic(terminalRC, token);
    }

    @Override
    public void acceptWhitespace(AbstractRule rule, String token, ILeafNode node) {
        this.last.setUndefined(false);
        if (!Strings.isEmpty((String)token)) {
            int offset = this.regionAccess.append(token);
            this.last.addPart(this.createWhitespace(rule, token, offset));
        }
    }

    private void appendSemantic(AbstractElement element, String token) {
        if (token == null || token.length() == 0) {
            return;
        }
        AbstractEObjectRegion tokens = this.stack.peek();
        EObject obj = tokens == null ? null : tokens.getSemanticElement();
        int offset = this.regionAccess.append(token);
        StringSemanticRegion semantic = this.createSemanticRegion(element, token, obj, offset);
        this.last.setNext(semantic);
        semantic.setLeadingHiddenRegion(this.last);
        this.last = this.createHiddenRegion();
        this.last.setPrevious(semantic);
        semantic.setTrailingHiddenRegion(this.last);
        if (tokens != null) {
            tokens.getSemanticRegions().add(semantic);
            tokens.setTrailingHiddenRegion(this.last);
        }
    }

    protected StringComment createComment(AbstractRule rule, String token, int offset) {
        return new StringComment(this.last, rule, offset, token.length());
    }

    protected StringHiddenRegion createHiddenRegion() {
        return new StringHiddenRegion(this.regionAccess);
    }

    protected StringSemanticRegion createSemanticRegion(AbstractElement element, String token, EObject obj, int offset) {
        return new StringSemanticRegion(this.regionAccess, obj, element, offset, token.length());
    }

    protected StringWhitespace createWhitespace(AbstractRule rule, String token, int offset) {
        return new StringWhitespace(this.last, rule, offset, token.length());
    }

    @Override
    public boolean enterAssignedAction(Action action, EObject semanticChild, ICompositeNode node) {
        this.enterEObject(action, semanticChild);
        return true;
    }

    @Override
    public boolean enterAssignedParserRuleCall(RuleCall rc, EObject semanticChild, ICompositeNode node) {
        this.enterEObject(rc, semanticChild);
        return true;
    }

    protected StringEObjectRegion enterEObject(EObject ele, EObject semanticChild) {
        StringEObjectRegion tokens = new StringEObjectRegion(this.regionAccess, ele, semanticChild);
        this.regionAccess.add(tokens);
        tokens.setLeadingHiddenRegion(this.last);
        tokens.setTrailingHiddenRegion(this.last);
        this.stack.push(tokens);
        return tokens;
    }

    @Override
    public void enterUnassignedParserRuleCall(RuleCall rc) {
    }

    @Override
    public void finish() {
    }

    public StringBasedRegionAccess getRegionAccess() {
        return this.regionAccess;
    }

    @Override
    public void leaveAssignedAction(Action action, EObject semanticChild) {
        this.leaveEObject();
    }

    @Override
    public void leaveAssignedParserRuleCall(RuleCall rc, EObject semanticChild) {
        this.leaveEObject();
    }

    private void leaveEObject() {
        AbstractEObjectRegion popped = this.stack.pop();
        AbstractEObjectRegion peek = this.stack.peek();
        if (peek != null) {
            peek.setTrailingHiddenRegion(popped.getTrailingHiddenRegion());
        }
    }

    @Override
    public void leaveUnssignedParserRuleCall(RuleCall rc) {
    }

    public TextRegionAccessBuildingSequencer withRoot(ISerializationContext ctx, EObject root) {
        this.regionAccess = new StringBasedRegionAccess((XtextResource)root.eResource());
        this.last = this.createHiddenRegion();
        this.regionAccess.setRootEObject(this.enterEObject(((SerializationContext)ctx).getActionOrRule(), root));
        return this;
    }
}

