/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.build;

import com.google.common.base.Objects;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.build.ClusteringStorageAwareResourceLoader;
import org.eclipse.xtext.build.IndexState;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.clustering.IResourceClusteringPolicy;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

@FinalFieldsConstructor
public class BuildContext {
    private final Functions.Function1<? super URI, ? extends IResourceServiceProvider> resourceServiceProviderProvider;
    @Accessors
    private final XtextResourceSet resourceSet;
    @Accessors
    private final IndexState oldState;
    @Accessors
    private final IResourceClusteringPolicy clusteringPolicy;
    @Accessors
    private final CancelIndicator cancelIndicator;
    private ClusteringStorageAwareResourceLoader loader;

    public <T> Iterable<T> executeClustered(Iterable<URI> uri, Functions.Function1<? super Resource, ? extends T> operation) {
        boolean _equals = Objects.equal((Object)this.loader, null);
        if (_equals) {
            ClusteringStorageAwareResourceLoader _clusteringStorageAwareResourceLoader;
            this.loader = _clusteringStorageAwareResourceLoader = new ClusteringStorageAwareResourceLoader(this);
        }
        Functions.Function1<URI, Boolean> _function = new Functions.Function1<URI, Boolean>(){

            public Boolean apply(URI it) {
                IResourceServiceProvider _resourceServiceProvider = BuildContext.this.getResourceServiceProvider(it);
                return !Objects.equal((Object)_resourceServiceProvider, null);
            }
        };
        Iterable _filter = IterableExtensions.filter(uri, (Functions.Function1)_function);
        return this.loader.executeClustered(_filter, operation);
    }

    public IResourceServiceProvider getResourceServiceProvider(URI uri) {
        IResourceServiceProvider resourceServiceProvider = (IResourceServiceProvider)this.resourceServiceProviderProvider.apply((Object)uri);
        return resourceServiceProvider;
    }

    public BuildContext(Functions.Function1<? super URI, ? extends IResourceServiceProvider> resourceServiceProviderProvider, XtextResourceSet resourceSet, IndexState oldState, IResourceClusteringPolicy clusteringPolicy, CancelIndicator cancelIndicator) {
        this.resourceServiceProviderProvider = resourceServiceProviderProvider;
        this.resourceSet = resourceSet;
        this.oldState = oldState;
        this.clusteringPolicy = clusteringPolicy;
        this.cancelIndicator = cancelIndicator;
    }

    @Pure
    public XtextResourceSet getResourceSet() {
        return this.resourceSet;
    }

    @Pure
    public IndexState getOldState() {
        return this.oldState;
    }

    @Pure
    public IResourceClusteringPolicy getClusteringPolicy() {
        return this.clusteringPolicy;
    }

    @Pure
    public CancelIndicator getCancelIndicator() {
        return this.cancelIndicator;
    }
}

