/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.formatting2.FormatterRequest;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IFormattableSubDocument;
import org.eclipse.xtext.formatting2.IFormatter2;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatting;
import org.eclipse.xtext.formatting2.IMerger;
import org.eclipse.xtext.formatting2.ITextReplacement;
import org.eclipse.xtext.formatting2.ITextReplacer;
import org.eclipse.xtext.formatting2.ITextReplacerContext;
import org.eclipse.xtext.formatting2.ITextSegment;
import org.eclipse.xtext.formatting2.internal.HiddenRegionFormatting;
import org.eclipse.xtext.formatting2.internal.HiddenRegionFormattingMerger;
import org.eclipse.xtext.formatting2.internal.HiddenRegionReplacer;
import org.eclipse.xtext.formatting2.internal.MultilineCommentReplacer;
import org.eclipse.xtext.formatting2.internal.RootDocument;
import org.eclipse.xtext.formatting2.internal.SinglelineCodeCommentReplacer;
import org.eclipse.xtext.formatting2.internal.SinglelineDocCommentReplacer;
import org.eclipse.xtext.formatting2.internal.SubDocument;
import org.eclipse.xtext.formatting2.internal.TextReplacement;
import org.eclipse.xtext.formatting2.internal.TextReplacerContext;
import org.eclipse.xtext.formatting2.internal.TextReplacerMerger;
import org.eclipse.xtext.formatting2.internal.WhitespaceReplacer;
import org.eclipse.xtext.formatting2.regionaccess.IComment;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.grammaranalysis.impl.GrammarElementTitleSwitch;
import org.eclipse.xtext.preferences.ITypedPreferenceValues;
import org.eclipse.xtext.preferences.TypedPreferenceKey;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;

public abstract class AbstractFormatter2
implements IFormatter2 {
    @Extension
    protected ITextRegionAccess regionAccess;
    private FormatterRequest request = null;

    protected void _format(Object obj, IFormattableDocument document) {
    }

    protected void _format(Void obj, IFormattableDocument document) {
    }

    protected void _format(XtextResource resource, IFormattableDocument document) {
        EList contents = resource.getContents();
        if (!contents.isEmpty()) {
            EObject model = (EObject)contents.get(0);
            this.format(model, document);
        }
    }

    public ITextReplacer createCommentReplacer(IComment comment) {
        EObject grammarElement = comment.getGrammarElement();
        if (grammarElement instanceof AbstractRule) {
            String ruleName = ((AbstractRule)grammarElement).getName();
            if (ruleName.startsWith("ML")) {
                return new MultilineCommentReplacer(comment, '*');
            }
            if (ruleName.startsWith("SL")) {
                if (comment.getIndentation().getLength() > 0) {
                    return new SinglelineDocCommentReplacer(comment, "//");
                }
                return new SinglelineCodeCommentReplacer(comment, "//");
            }
        }
        String elementName = new GrammarElementTitleSwitch().showQualified().showRule().doSwitch(grammarElement);
        throw new IllegalStateException("No " + ITextReplacer.class.getSimpleName() + " configured for " + elementName);
    }

    public IFormattableSubDocument createFormattableSubDocument(ITextSegment region, IFormattableDocument parent) {
        return new SubDocument(region, parent);
    }

    public IHiddenRegionFormatting createHiddenRegionFormatting() {
        return new HiddenRegionFormatting(this);
    }

    public IMerger<IHiddenRegionFormatting> createHiddenRegionFormattingMerger() {
        return new HiddenRegionFormattingMerger(this);
    }

    public ITextReplacer createHiddenRegionReplacer(IHiddenRegion region, IHiddenRegionFormatting formatting) {
        return new HiddenRegionReplacer(region, formatting);
    }

    public ITextReplacement createTextReplacement(int offset, int length, String text) {
        return new TextReplacement(this.getRequest().getTextRegionAccess(), offset, length, text);
    }

    public ITextReplacerContext createTextReplacerContext(IFormattableDocument document) {
        return new TextReplacerContext(document);
    }

    public IMerger<ITextReplacer> createTextReplacerMerger() {
        return new TextReplacerMerger(this);
    }

    public ITextReplacer createWhitespaceReplacer(ITextSegment hiddens, IHiddenRegionFormatting formatting) {
        return new WhitespaceReplacer(hiddens, formatting);
    }

    public IFormattableDocument createFormattableRootDocument() {
        return new RootDocument(this);
    }

    @Override
    public final List<ITextReplacement> format(FormatterRequest request) {
        try {
            List<ITextReplacement> replacements;
            this.initalize(request);
            IFormattableDocument document = this.createFormattableRootDocument();
            XtextResource xtextResource = request.getTextRegionAccess().getResource();
            this.format((Object)xtextResource, document);
            List<ITextReplacement> list = replacements = document.renderToTextReplacements();
            return list;
        }
        finally {
            this.reset();
        }
    }

    public abstract void format(Object var1, IFormattableDocument var2);

    public <T> T getPreference(TypedPreferenceKey<T> key) {
        return this.request.getPreferences().getPreference(key);
    }

    public ITypedPreferenceValues getPreferences() {
        return this.request.getPreferences();
    }

    public FormatterRequest getRequest() {
        return this.request;
    }

    protected void initalize(FormatterRequest request) {
        this.request = request;
        this.regionAccess = request.getTextRegionAccess();
    }

    protected void reset() {
        this.request = null;
        this.regionAccess = null;
    }
}

