/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.AbstractTypeReferencePairWalker;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.DeclaratorTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.Maps2;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterByConstraintSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

public class ActualTypeArgumentCollector
extends AbstractTypeReferencePairWalker {
    private final Map<JvmTypeParameter, List<LightweightBoundTypeArgument>> typeParameterMapping;
    private final Collection<JvmTypeParameter> parametersToBeMapped;
    private final BoundTypeArgumentSource defaultSource;

    public ActualTypeArgumentCollector(Collection<JvmTypeParameter> parametersToBeMapped, BoundTypeArgumentSource defaultSource, ITypeReferenceOwner owner) {
        super(owner);
        this.parametersToBeMapped = parametersToBeMapped;
        this.defaultSource = defaultSource;
        this.typeParameterMapping = Maps2.newLinkedHashMapWithExpectedSize(parametersToBeMapped.size());
    }

    public void populateTypeParameterMapping(LightweightTypeReference declaredType, LightweightTypeReference actualType) {
        this.processPairedReferences(declaredType, actualType);
    }

    protected LightweightBoundTypeArgument boundByConstraint(LightweightTypeReference reference, Object origin) {
        return new LightweightBoundTypeArgument(reference.getWrapperTypeIfPrimitive(), BoundTypeArgumentSource.CONSTRAINT, origin, VarianceInfo.OUT, VarianceInfo.OUT);
    }

    protected BoundTypeArgumentSource getDefaultSource() {
        return this.defaultSource;
    }

    protected LightweightBoundTypeArgument boundByDefaultSource(LightweightTypeReference reference) {
        return new LightweightBoundTypeArgument(reference.getWrapperTypeIfPrimitive(), this.defaultSource, this.getOrigin(), this.getExpectedVariance(), this.getActualVariance());
    }

    @Override
    protected AbstractTypeReferencePairWalker.ParameterizedTypeReferenceTraverser createParameterizedTypeReferenceTraverser() {
        return new ActualParameterizedTypeReferenceTraverser();
    }

    @Override
    protected void processTypeParameter(JvmTypeParameter typeParameter, LightweightTypeReference reference) {
        Maps2.putIntoListMap(typeParameter, this.boundByDefaultSource(reference), this.typeParameterMapping);
    }

    public Map<JvmTypeParameter, List<LightweightBoundTypeArgument>> rawGetTypeParameterMapping() {
        return this.typeParameterMapping;
    }

    protected Collection<JvmTypeParameter> getParametersToProcess() {
        return this.parametersToBeMapped;
    }

    @Override
    protected boolean shouldProcess(JvmTypeParameter type) {
        return this.parametersToBeMapped.contains(type);
    }

    @Override
    public void processPairedReferences(LightweightTypeReference declaredType, LightweightTypeReference actualType) {
        if (this.parametersToBeMapped.isEmpty()) {
            return;
        }
        super.processPairedReferences(declaredType, actualType);
    }

    public Map<JvmTypeParameter, List<LightweightBoundTypeArgument>> getTypeParameterMapping() {
        if (this.typeParameterMapping.keySet().containsAll(this.getParametersToProcess())) {
            return this.typeParameterMapping;
        }
        LinkedHashMap result = Maps.newLinkedHashMap(this.typeParameterMapping);
        for (JvmTypeParameter pendingParameter : this.getParametersToProcess()) {
            if (result.containsKey(pendingParameter)) continue;
            for (JvmTypeConstraint constraint : pendingParameter.getConstraints()) {
                if (!(constraint instanceof JvmUpperBound)) {
                    throw new IllegalStateException("Type parameters may not be declared with a lower bound");
                }
                JvmTypeReference constraintReference = constraint.getTypeReference();
                if (constraintReference == null) continue;
                JvmType constraintType = constraintReference.getType();
                if (!result.containsKey(constraintType)) {
                    if (!this.getParametersToProcess().contains(constraintType)) {
                        LightweightTypeReference lightweightReference = this.getOwner().toLightweightTypeReference(constraintReference);
                        Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> constraintParameterMapping = new DeclaratorTypeArgumentCollector().getTypeParameterMapping(lightweightReference);
                        TypeParameterByConstraintSubstitutor substitutor = new TypeParameterByConstraintSubstitutor(constraintParameterMapping, this.getOwner());
                        LightweightTypeReference resolvedConstraint = lightweightReference.accept(substitutor, substitutor.createVisiting(pendingParameter));
                        Maps2.putIntoListMap(pendingParameter, this.boundByConstraint(resolvedConstraint, pendingParameter), result);
                        continue;
                    }
                    JvmType objectType = this.getOwner().getServices().getTypeReferences().findDeclaredType(Object.class, (Notifier)constraintType);
                    LightweightTypeReference lightweightReference = objectType != null ? this.getOwner().newParameterizedTypeReference(objectType) : this.getOwner().newUnknownTypeReference(Object.class.getName());
                    Maps2.putIntoListMap(pendingParameter, this.boundByConstraint(lightweightReference, pendingParameter), result);
                    continue;
                }
                Maps2.putAllIntoListMap(pendingParameter, (Collection)result.get(constraintType), result);
            }
        }
        return result;
    }

    protected class ActualParameterizedTypeReferenceTraverser
    extends AbstractTypeReferencePairWalker.ParameterizedTypeReferenceTraverser {
        protected ActualParameterizedTypeReferenceTraverser() {
        }

        @Override
        protected boolean shouldProcessInContextOf(JvmTypeParameter declaredTypeParameter, Set<JvmTypeParameter> boundParameters, Set<JvmTypeParameter> visited) {
            return ActualTypeArgumentCollector.this.shouldProcess(declaredTypeParameter) || !boundParameters.contains(declaredTypeParameter) || visited.add(declaredTypeParameter);
        }
    }
}

