/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.di.context.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.fx.core.Callback;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.adapter.AdapterService;
import org.eclipse.fx.core.di.context.internal.PreferenceValueSupplier;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.preferences.Value;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.service.prefs.BackingStoreException;

public class PreferenceValue<T>
implements Value<T> {
    private @Nullable IEclipsePreferences preference;
    private @Nullable String contextKey;
    @Nullable List<Callback<T>> callbacks;
    @Nullable List<Callback<Void>> disposalCallbacks;
    private @Nullable T value;
    @Inject
    @Optional
    @Nullable IEventBroker eventBroker;
    @Inject
    @Log
    private Logger logger;
    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable IEclipsePreferences.IPreferenceChangeListener listener;
    private @NonNull AdapterService adapterService;
    private @NonNull IEclipseContext context;

    @Inject
    public PreferenceValue(@NonNull IEclipseContext context, @NonNull AdapterService adapterService) {
        this.context = context;
        this.adapterService = adapterService;
    }

    public void init(@NonNull String contextKey, @NonNull IEclipsePreferences preference, Class<?> cl) {
        this.contextKey = contextKey;
        this.preference = preference;
        this.contextKey = contextKey;
        IEclipsePreferences.IPreferenceChangeListener listener = event -> {
            if (contextKey.equals(event.getKey())) {
                this.setCurrentValue(PreferenceValueSupplier.getValue(preference, contextKey, cl));
            }
        };
        preference.addPreferenceChangeListener(listener);
        this.listener = listener;
        this.setCurrentValue(PreferenceValueSupplier.getValue(preference, contextKey, cl));
    }

    void setCurrentValue(@Nullable T o) {
        this.value = o;
        if (this.callbacks != null) {
            Callback[] callbackArray = this.callbacks.toArray(new Callback[0]);
            int n = callbackArray.length;
            int n2 = 0;
            while (n2 < n) {
                Callback c = callbackArray[n2];
                try {
                    c.call(o);
                }
                catch (Throwable t) {
                    this.logger.error("Failed while executing callback", t);
                }
                ++n2;
            }
        }
    }

    public @Nullable T getValue() {
        return this.value;
    }

    public void publish(@Nullable T value) {
        IEclipsePreferences preference = this.preference;
        if (preference == null) {
            throw new IllegalStateException("The backing IEclipsePreference is null");
        }
        if (value == null) {
            preference.remove(this.contextKey);
        } else {
            preference.put(this.contextKey, value.toString());
            try {
                preference.flush();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
        if (this.eventBroker != null) {
            this.eventBroker.send("org/eclipse/fx/context/key", Collections.singletonMap(this.contextKey, value));
        }
    }

    public Subscription subscribeOnValueChange(final Callback<T> callback) {
        if (this.callbacks == null) {
            this.callbacks = new ArrayList<Callback<T>>();
        }
        if (this.callbacks != null) {
            this.callbacks.add(callback);
        }
        return new Subscription(){

            public void dispose() {
                List callbacks = PreferenceValue.this.callbacks;
                if (callbacks != null) {
                    callbacks.remove(callback);
                }
            }
        };
    }

    public Subscription subscribeOnDispose(final Callback<Void> callback) {
        if (this.disposalCallbacks == null) {
            this.disposalCallbacks = new ArrayList<Callback<Void>>();
        }
        if (this.disposalCallbacks != null) {
            this.disposalCallbacks.add(callback);
        }
        return new Subscription(){

            public void dispose() {
                List<Callback<Void>> disposalCallbacks = PreferenceValue.this.disposalCallbacks;
                if (disposalCallbacks != null) {
                    disposalCallbacks.remove(callback);
                }
            }
        };
    }

    public <A> A adaptTo(@NonNull Class<A> adapt) {
        return (A)this.adapterService.adapt((Object)this, adapt, new AdapterService.ValueAccess[]{new ValueAccessImpl(this.context)});
    }

    public boolean canAdaptTo(Class<?> adapt) {
        return this.adapterService.canAdapt((Object)this, adapt);
    }

    @PreDestroy
    void dispose() {
        List<Callback<Void>> disposalCallbacks = this.disposalCallbacks;
        if (disposalCallbacks != null) {
            Callback[] callbackArray = disposalCallbacks.toArray(new Callback[0]);
            int n = callbackArray.length;
            int n2 = 0;
            while (n2 < n) {
                Callback callback = callbackArray[n2];
                try {
                    callback.call(null);
                }
                catch (Throwable t) {
                    this.logger.error("Failure while executing clean up callback", t);
                }
                ++n2;
            }
            disposalCallbacks.clear();
        }
        if (this.callbacks != null) {
            this.callbacks.clear();
        }
        this.value = null;
        IEclipsePreferences preference = this.preference;
        IEclipsePreferences.IPreferenceChangeListener listener = this.listener;
        if (preference != null && listener != null) {
            preference.removePreferenceChangeListener(listener);
        }
        this.preference = null;
        this.listener = null;
    }

    static class ValueAccessImpl
    implements AdapterService.ValueAccess {
        private final IEclipseContext context;

        public ValueAccessImpl(IEclipseContext context) {
            this.context = context;
        }

        public <O> O getValue(String key) {
            return (O)this.context.get(key);
        }

        public <O> O getValue(@NonNull Class<O> key) {
            return (O)this.context.get(key);
        }
    }
}

