/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.adapter.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.fx.core.adapter.AdapterProvider;
import org.eclipse.fx.core.adapter.AdapterService;
import org.eclipse.jdt.annotation.NonNull;

public class AdapterServiceImpl
implements AdapterService {
    private @NonNull Map<Class<Object>, Map<Class<Object>, List<AdapterProvider<Object, Object>>>> adapterMap = new HashMap<Class<Object>, Map<Class<Object>, List<AdapterProvider<Object, Object>>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAdapterProviderService(AdapterProvider<?, ?> service) {
        Map<Class<Object>, Map<Class<Object>, List<AdapterProvider<Object, Object>>>> map = this.adapterMap;
        synchronized (map) {
            List<AdapterProvider<Object, Object>> list;
            Map<Class<Object>, List<AdapterProvider<Object, Object>>> map2 = this.adapterMap.get(service.getSourceType());
            if (map2 == null) {
                map2 = new HashMap<Class<Object>, List<AdapterProvider<Object, Object>>>();
                this.adapterMap.put(service.getSourceType(), map2);
            }
            if ((list = map2.get(service.getTargetType())) == null) {
                list = new ArrayList<AdapterProvider<Object, Object>>();
                map2.put(service.getTargetType(), list);
            }
            list.add(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAdapterProviderService(AdapterProvider<?, ?> service) {
        Map<Class<Object>, Map<Class<Object>, List<AdapterProvider<Object, Object>>>> map = this.adapterMap;
        synchronized (map) {
            List<AdapterProvider<Object, Object>> list;
            Map<Class<Object>, List<AdapterProvider<Object, Object>>> map2 = this.adapterMap.get(service.getSourceType());
            if (map2 != null && (list = map2.get(service.getTargetType())) != null) {
                list.remove(service);
            }
        }
    }

    @Override
    public boolean canAdapt(Object sourceObject, Class<?> targetType) {
        if (sourceObject == null) {
            return true;
        }
        return this.canAdaptRec(sourceObject, sourceObject.getClass(), targetType);
    }

    private boolean canAdaptRec(@NonNull Object sourceObject, Class<?> sourceType, @NonNull Class<?> targetType) {
        boolean adapt = AdapterServiceImpl.canAdapt(this.adapterMap, sourceObject, sourceType, targetType);
        if (adapt) {
            return true;
        }
        Class<?>[] classArray = sourceType.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<Object> i = classArray[n2];
            if (AdapterServiceImpl.canAdapt(this.adapterMap, sourceObject, i, targetType)) {
                return true;
            }
            ++n2;
        }
        if (sourceType.getSuperclass() != Object.class) {
            return this.canAdaptRec(sourceObject, sourceType.getSuperclass(), targetType);
        }
        return false;
    }

    private static boolean canAdapt(Map<Class<Object>, Map<Class<Object>, List<AdapterProvider<Object, Object>>>> adapterMap, @NonNull Object sourceObject, Class<Object> source, @NonNull Class<Object> target) {
        List<AdapterProvider<Object, Object>> aList;
        Map<Class<Object>, List<AdapterProvider<Object, Object>>> map = adapterMap.get(source);
        if (map != null && (aList = map.get(target)) != null) {
            for (AdapterProvider<Object, Object> a : aList) {
                if (!a.canAdapt(sourceObject, target)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public <A> A adapt(Object sourceObject, Class<A> targetType, AdapterService.ValueAccess ... valueAccess) {
        if (sourceObject == null) {
            return null;
        }
        return (A)this.adaptRec(sourceObject, sourceObject.getClass(), targetType, valueAccess);
    }

    private Object adaptRec(@NonNull Object sourceObject, Class<?> sourceType, @NonNull Class<?> targetType, AdapterService.ValueAccess[] valueAccess) {
        Object adapt = AdapterServiceImpl.adapt(this.adapterMap, sourceObject, sourceType, targetType, valueAccess);
        if (adapt != null) {
            return adapt;
        }
        Class<?>[] classArray = sourceType.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<Object> i = classArray[n2];
            adapt = AdapterServiceImpl.adapt(this.adapterMap, sourceObject, i, targetType, valueAccess);
            if (adapt != null) {
                return adapt;
            }
            ++n2;
        }
        if (sourceType.getSuperclass() != Object.class) {
            return this.adaptRec(sourceObject, sourceType.getSuperclass(), targetType, valueAccess);
        }
        return null;
    }

    private static Object adapt(Map<Class<Object>, Map<Class<Object>, List<AdapterProvider<Object, Object>>>> adapterMap, @NonNull Object sourceObject, Class<Object> source, @NonNull Class<Object> target, AdapterService.ValueAccess[] valueAccess) {
        List<AdapterProvider<Object, Object>> aList;
        Map<Class<Object>, List<AdapterProvider<Object, Object>>> map = adapterMap.get(source);
        if (map != null && (aList = map.get(target)) != null) {
            for (AdapterProvider<Object, Object> a : aList) {
                Object adapt = a.adapt(sourceObject, target, valueAccess);
                if (adapt == null) continue;
                return adapt;
            }
        }
        return null;
    }
}

