/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.operations;

import java.net.URI;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.operations.IFailedStatusEvaluator;
import org.eclipse.equinox.internal.p2.operations.Messages;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UninstallOperation
extends ProfileChangeOperation {
    private Collection<IInstallableUnit> toUninstall;

    public UninstallOperation(ProvisioningSession session, Collection<IInstallableUnit> toUninstall) {
        super(session);
        this.toUninstall = toUninstall;
    }

    @Override
    protected void computeProfileChangeRequest(MultiStatus status, IProgressMonitor monitor) {
        this.request = ProfileChangeRequest.createByProfileId((IProvisioningAgent)this.session.getProvisioningAgent(), (String)this.profileId);
        this.request.removeAll(this.toUninstall);
        for (IInstallableUnit iuToUninstall : this.toUninstall) {
            this.request.removeInstallableUnitProfileProperty(iuToUninstall, "org.eclipse.equinox.p2.type.root");
        }
    }

    @Override
    protected String getProvisioningJobName() {
        return Messages.UninstallOperation_ProvisioningJobName;
    }

    @Override
    protected String getResolveJobName() {
        return Messages.UninstallOperation_ResolveJobName;
    }

    @Override
    ProvisioningContext getFirstPassProvisioningContext() {
        ProvisioningContext pc = new ProvisioningContext(this.session.getProvisioningAgent());
        pc.setMetadataRepositories(new URI[0]);
        pc.setArtifactRepositories(new URI[0]);
        return pc;
    }

    @Override
    IFailedStatusEvaluator getSecondPassEvaluator() {
        return new IFailedStatusEvaluator(){

            public ProvisioningContext getSecondPassProvisioningContext(IProvisioningPlan failedPlan) {
                return UninstallOperation.this.context;
            }
        };
    }
}

