/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.dialogs;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import org.eclipse.fx.ui.dialogs.Dialog;
import org.eclipse.fx.ui.dialogs.MessageDialog;

public abstract class TitleAreaDialog
extends Dialog {
    private String title;
    private String message;
    private URL imageURI;
    private String iconClass;

    public TitleAreaDialog(Window parent, String windowTitle, String title, String message, URL imageURI) {
        super(parent, windowTitle);
        this.title = title;
        this.message = message;
        this.imageURI = imageURI;
    }

    public TitleAreaDialog(Window parent, String windowTitle, String title, String message, String iconClass) {
        super(parent, windowTitle);
        this.title = title;
        this.message = message;
        this.iconClass = iconClass;
    }

    @Override
    protected List<String> getStylesheets() {
        ArrayList<String> list = new ArrayList<String>(super.getStylesheets());
        list.add(0, MessageDialog.class.getResource("titlearea_dialog.css").toExternalForm());
        return list;
    }

    @Override
    protected final Node createDialogArea() {
        VBox pane = new VBox();
        BorderPane titleArea = new BorderPane();
        titleArea.getStyleClass().add((Object)"titleDialog_TitleArea");
        titleArea.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
        VBox messageArea = new VBox();
        messageArea.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
        messageArea.getStyleClass().add((Object)"titleDialog_MessageArea");
        Label l = new Label(this.title);
        l.getStyleClass().add((Object)"titleDialog_Title");
        messageArea.getChildren().add((Object)l);
        l = new Label(this.message);
        l.getStyleClass().add((Object)"titleDialog_Message");
        messageArea.getChildren().add((Object)l);
        titleArea.setCenter((Node)messageArea);
        if (this.imageURI != null) {
            try {
                InputStream in = this.imageURI.openStream();
                titleArea.setRight((Node)new ImageView(new Image(in)));
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (this.iconClass != null) {
            ImageView image = new ImageView();
            image.getStyleClass().addAll((Object[])new String[]{"titleDialog_Icon-" + this.iconClass});
            titleArea.setRight((Node)image);
        }
        pane.getChildren().add((Object)titleArea);
        BorderPane dialogContent = new BorderPane();
        dialogContent.getStyleClass().add((Object)"titleDialog_ContentArea");
        dialogContent.setLeft(this.createDialogContent());
        dialogContent.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        pane.getChildren().add((Object)dialogContent);
        return pane;
    }

    @Override
    protected Insets getContentInset() {
        return new Insets(0.0, 0.0, 0.0, 0.0);
    }

    protected abstract Node createDialogContent();
}

