/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.ecore.formalml.statement;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ActivityStatementKind implements Enumerator
{
    INIT(0, "init", "init"),
    FINAL(1, "final", "final"),
    DESTROY(2, "destroy", "destroy"),
    START(3, "start", "start"),
    STOP(4, "stop", "stop"),
    RESTART(5, "restart", "restart"),
    SUSPEND(6, "suspend", "suspend"),
    RESUME(7, "resume", "resume"),
    WAIT(8, "wait", "wait"),
    ABORT(9, "abort", "abort"),
    DISABLE(10, "disable", "disable"),
    ENABLE(11, "enable", "enable"),
    IRUN(12, "irun", "irun"),
    RUN(13, "run", "run"),
    RTC(14, "rtc", "rtc"),
    SCHEDULE(15, "schedule", "schedule");

    public static final int INIT_VALUE = 0;
    public static final int FINAL_VALUE = 1;
    public static final int DESTROY_VALUE = 2;
    public static final int START_VALUE = 3;
    public static final int STOP_VALUE = 4;
    public static final int RESTART_VALUE = 5;
    public static final int SUSPEND_VALUE = 6;
    public static final int RESUME_VALUE = 7;
    public static final int WAIT_VALUE = 8;
    public static final int ABORT_VALUE = 9;
    public static final int DISABLE_VALUE = 10;
    public static final int ENABLE_VALUE = 11;
    public static final int IRUN_VALUE = 12;
    public static final int RUN_VALUE = 13;
    public static final int RTC_VALUE = 14;
    public static final int SCHEDULE_VALUE = 15;
    private static final ActivityStatementKind[] VALUES_ARRAY;
    public static final List<ActivityStatementKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ActivityStatementKind[]{INIT, FINAL, DESTROY, START, STOP, RESTART, SUSPEND, RESUME, WAIT, ABORT, DISABLE, ENABLE, IRUN, RUN, RTC, SCHEDULE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ActivityStatementKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ActivityStatementKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ActivityStatementKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ActivityStatementKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ActivityStatementKind get(int value) {
        switch (value) {
            case 0: {
                return INIT;
            }
            case 1: {
                return FINAL;
            }
            case 2: {
                return DESTROY;
            }
            case 3: {
                return START;
            }
            case 4: {
                return STOP;
            }
            case 5: {
                return RESTART;
            }
            case 6: {
                return SUSPEND;
            }
            case 7: {
                return RESUME;
            }
            case 8: {
                return WAIT;
            }
            case 9: {
                return ABORT;
            }
            case 10: {
                return DISABLE;
            }
            case 11: {
                return ENABLE;
            }
            case 12: {
                return IRUN;
            }
            case 13: {
                return RUN;
            }
            case 14: {
                return RTC;
            }
            case 15: {
                return SCHEDULE;
            }
        }
        return null;
    }

    private ActivityStatementKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

