/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.svg;

import fr.inria.zvtm.animation.Animation;
import fr.inria.zvtm.animation.interpolation.SlowInSlowOutInterpolator;
import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.View;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.engine.portals.OverviewPortal;
import fr.inria.zvtm.engine.portals.Portal;
import fr.inria.zvtm.event.PortalListener;
import fr.inria.zvtm.svg.Config;
import fr.inria.zvtm.svg.Viewer;
import java.awt.Color;
import java.awt.geom.Point2D;

class Navigation {
    static final short MOVE_UP = 0;
    static final short MOVE_DOWN = 1;
    static final short MOVE_LEFT = 2;
    static final short MOVE_RIGHT = 3;
    Viewer application;
    VirtualSpaceManager vsm;
    Camera mCamera;
    Camera ovCamera;
    OverviewPortal ovPortal;

    Navigation(Viewer app) {
        this.application = app;
        this.vsm = VirtualSpaceManager.INSTANCE;
    }

    void setCamera(Camera c) {
        this.mCamera = c;
    }

    void getGlobalView() {
        this.application.mView.getGlobalView(this.mCamera, 300, 1.05f);
    }

    void getHigherView() {
        Float alt = new Float(this.mCamera.getAltitude() + this.mCamera.getFocal());
        Animation a = this.vsm.getAnimationManager().getAnimationFactory().createCameraAltAnim(300, this.mCamera, (double)alt.floatValue(), true, SlowInSlowOutInterpolator.getInstance(), null);
        this.vsm.getAnimationManager().startAnimation(a, false);
    }

    void getLowerView() {
        Float alt = new Float(-(this.mCamera.getAltitude() + this.mCamera.getFocal()) / 2.0);
        Animation a = this.vsm.getAnimationManager().getAnimationFactory().createCameraAltAnim(300, this.mCamera, (double)alt.floatValue(), true, SlowInSlowOutInterpolator.getInstance(), null);
        this.vsm.getAnimationManager().startAnimation(a, false);
    }

    void translateView(short direction) {
        Point2D.Double trans;
        double qt;
        double[] rb = this.application.mView.getVisibleRegion(this.mCamera);
        if (direction == 0) {
            qt = (rb[1] - rb[3]) / 4.0;
            trans = new Point2D.Double(0.0, qt);
        } else if (direction == 1) {
            qt = (rb[3] - rb[1]) / 4.0;
            trans = new Point2D.Double(0.0, qt);
        } else if (direction == 3) {
            qt = (rb[2] - rb[0]) / 4.0;
            trans = new Point2D.Double(qt, 0.0);
        } else {
            qt = (rb[0] - rb[2]) / 4.0;
            trans = new Point2D.Double(qt, 0.0);
        }
        Animation a = this.vsm.getAnimationManager().getAnimationFactory().createCameraTranslation(300, this.mCamera, trans, true, SlowInSlowOutInterpolator.getInstance(), null);
        this.vsm.getAnimationManager().startAnimation(a, false);
    }

    void createOverview() {
        this.ovPortal = new OverviewPortal(this.application.panelWidth - 200 - 1, this.application.panelHeight - 200 - 1, 200, 200, this.ovCamera, this.mCamera);
        this.ovPortal.setPortalListener((PortalListener)this.application.eh);
        this.ovPortal.setBackgroundColor(Config.BACKGROUND_COLOR);
        this.ovPortal.setObservedRegionColor(Config.OBSERVED_REGION_COLOR);
        this.ovPortal.setObservedRegionTranslucency(0.5f);
        VirtualSpaceManager.INSTANCE.addPortal((Portal)this.ovPortal, (View)this.application.mView);
        this.ovPortal.setBorder(Color.GREEN);
        this.updateOverview();
    }

    void updateOverview() {
        if (this.ovPortal != null) {
            this.ovCamera.setLocation(this.ovPortal.getGlobalView());
        }
    }

    void updateOverviewLocation() {
        if (this.ovPortal != null) {
            this.ovPortal.moveTo(this.application.panelWidth - 200 - 1, this.application.panelHeight - 200 - 1);
        }
    }

    void toggleOverview() {
        this.ovPortal.setVisible(!this.ovPortal.isVisible());
        this.vsm.repaint((View)this.application.mView);
    }
}

