/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.parsers;

import java.util.ArrayList;
import java.util.List;

public class Interval {
    private int startOffset;
    private int startLine;
    private int endOffset;
    private int endLine;
    private final interval_type type;
    private int depth;
    private boolean erroneous;
    private List<Interval> subIntervals;
    private final Interval parent;

    public Interval(Interval parent, interval_type type) {
        this.parent = parent;
        if (parent != null) {
            parent.addSubIntervall(this);
            this.depth = parent.getDepth() + 1;
        } else {
            this.depth = 0;
        }
        this.startOffset = -1;
        this.startLine = -1;
        this.endOffset = -1;
        this.endLine = -1;
        this.type = type;
        this.erroneous = false;
        this.subIntervals = null;
    }

    public final interval_type getType() {
        return this.type;
    }

    public final boolean isComment() {
        return interval_type.MULTILINE_COMMENT.equals((Object)this.type) || interval_type.SINGLELINE_COMMENT.equals((Object)this.type);
    }

    public final boolean getErroneous() {
        return this.erroneous;
    }

    public final void setErroneous() {
        this.erroneous = true;
    }

    public final Interval getParent() {
        return this.parent;
    }

    private void addSubIntervall(Interval child) {
        if (this.subIntervals == null) {
            this.subIntervals = new ArrayList<Interval>();
        }
        this.subIntervals.add(child);
    }

    public final List<Interval> getSubIntervals() {
        if (this.subIntervals == null) {
            return new ArrayList<Interval>();
        }
        return this.subIntervals;
    }

    public final int getStartOffset() {
        return this.startOffset;
    }

    public final void setStartOffset(int offset) {
        this.startOffset = offset;
    }

    public final int getStartLine() {
        return this.startLine;
    }

    public final void setStartLine(int line) {
        this.startLine = line;
    }

    public final int getEndOffset() {
        return this.endOffset;
    }

    public final void setEndOffset(int offset) {
        this.endOffset = offset;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public final void setEndLine(int line) {
        this.endLine = line;
    }

    public final int getDepth() {
        return this.depth;
    }

    public final Interval getSmallestEnclosingInterval(int offset) {
        return this.getSmallestEnclosingInterval(offset, offset);
    }

    public final Interval getSmallestEnclosingInterval(int startOffset, int endOffset) {
        if (this.subIntervals == null) {
            return this;
        }
        if (!this.subIntervals.isEmpty() && this.subIntervals.get(0).getStartOffset() <= startOffset && endOffset <= this.subIntervals.get(this.subIntervals.size() - 1).getEndOffset()) {
            int middle;
            int lowLimit = 0;
            int highLimit = this.subIntervals.size();
            do {
                middle = (lowLimit + highLimit) / 2;
                Interval testedIntervall = this.subIntervals.get(middle);
                if (endOffset < testedIntervall.startOffset) {
                    highLimit = middle;
                    continue;
                }
                if (startOffset > testedIntervall.endOffset) {
                    lowLimit = middle;
                    continue;
                }
                return testedIntervall.getSmallestEnclosingInterval(startOffset, endOffset);
            } while (middle != (lowLimit + highLimit) / 2);
            return this;
        }
        return this;
    }

    public final int getPairLocation(int offset) {
        if (this.startOffset == offset) {
            return this.endOffset;
        }
        if (this.endOffset == offset) {
            return this.startOffset;
        }
        if (this.subIntervals != null && !this.subIntervals.isEmpty()) {
            return this.findPairInSubIntervals(offset);
        }
        return -1;
    }

    private int findPairInSubIntervals(int offset) {
        int middle;
        int lowLimit = 0;
        int highLimit = this.subIntervals.size();
        do {
            middle = (lowLimit + highLimit) / 2;
            Interval testedInterval = this.subIntervals.get(middle);
            if (offset < testedInterval.startOffset) {
                highLimit = middle;
                continue;
            }
            if (offset > testedInterval.endOffset) {
                lowLimit = middle;
                continue;
            }
            return testedInterval.getPairLocation(offset);
        } while (middle != (lowLimit + highLimit) / 2);
        return -1;
    }

    public static enum interval_type {
        MULTILINE_COMMENT,
        SINGLELINE_COMMENT,
        NORMAL,
        INDEX,
        PARAMETER;

    }
}

