/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.widgets;

import fr.inria.zvtm.widgets.TranslucentWidget;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;

public class TranslucentButton
extends JButton
implements TranslucentWidget {
    AlphaComposite bgAC = AB_08;
    AlphaComposite bgACro = AlphaComposite.getInstance(3, 0.8f);
    AlphaComposite fgAC = AB_10;
    Color bgColro = Color.GRAY;
    Color fgColsel = Color.LIGHT_GRAY;
    Color fgCol = Color.WHITE;
    Color bgCol = Color.BLACK;
    boolean cursorInside = false;
    boolean buttonPressed = false;

    public TranslucentButton() {
        this.init();
    }

    public TranslucentButton(Action a) {
        super(a);
        this.init();
    }

    public TranslucentButton(Icon icon) {
        super(icon);
        this.init();
    }

    public TranslucentButton(String text) {
        super(text);
        this.init();
    }

    public TranslucentButton(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    void init() {
        this.setOpaque(false);
        this.setContentAreaFilled(false);
        this.setBorderPainted(false);
        this.initColors();
        this.initListeners();
    }

    void initColors() {
        this.setForeground(this.fgCol);
        this.setBackground(this.bgCol);
    }

    void initListeners() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                TranslucentButton.this.cursorInside = true;
                TranslucentButton.this.setBackground(TranslucentButton.this.bgColro);
                TranslucentButton.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TranslucentButton.this.cursorInside = false;
                TranslucentButton.this.setBackground(TranslucentButton.this.bgCol);
                TranslucentButton.this.repaint();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                TranslucentButton.this.buttonPressed = true;
                TranslucentButton.this.setForeground(TranslucentButton.this.fgColsel);
                TranslucentButton.this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TranslucentButton.this.buttonPressed = false;
                TranslucentButton.this.setForeground(TranslucentButton.this.fgCol);
                TranslucentButton.this.repaint();
            }
        });
    }

    public void setRolloverBackgroundColor(Color c) {
        this.bgColro = c;
    }

    public void setSelectedForegroundColor(Color c) {
        this.fgColsel = c;
    }

    public void setBackgroundColor(Color c) {
        this.bgCol = c;
        this.setBackground(this.bgCol);
    }

    public void setForegroundColor(Color c) {
        this.fgCol = c;
        this.setForeground(this.fgCol);
    }

    @Override
    public void setBackgroundTranslucence(float alpha) {
        this.bgAC = AlphaComposite.getInstance(3, alpha);
    }

    @Override
    public void setForegroundTranslucence(float alpha) {
        this.fgAC = AlphaComposite.getInstance(3, alpha);
    }

    public void setRolloverBackgroundTranslucence(float alpha) {
        this.bgAC = AlphaComposite.getInstance(3, alpha);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.cursorInside) {
            g2d.setComposite(this.bgACro);
        } else {
            g2d.setComposite(this.bgAC);
        }
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setComposite(this.fgAC);
        g2d.setColor(this.getForeground());
        g2d.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        super.paint(g2d);
    }
}

